/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.print;

import com.oracle.svm.webimage.print.WebImageOutputStream;
import com.oracle.svm.webimage.print.WebImagePrintingProvider;
import java.io.PrintStream;

public class WebImagePrintStream
extends PrintStream {
    private final WebImagePrintingProvider.Descriptor fd;
    private boolean isClosed = false;
    private boolean hasError = false;
    private static final char[] NEW_LINE_CHARS = new char[]{'\n'};
    private static final char[] NULL_CHARS = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] TRUE_CHARS = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] FALSE_CHARS = new char[]{'f', 'a', 'l', 's', 'e'};

    public WebImagePrintStream(WebImageOutputStream out) {
        super(out, true);
        this.fd = out.fd;
    }

    @Override
    public void close() {
        super.close();
        this.isClosed = true;
    }

    @Override
    public boolean checkError() {
        return this.hasError || super.checkError();
    }

    @Override
    protected void clearError() {
        this.hasError = false;
        super.clearError();
    }

    protected void doWrite(char[] buf) {
        WebImagePrintingProvider.singleton().print(this.fd, buf);
    }

    @Override
    public void flush() {
        WebImagePrintingProvider.singleton().flush(this.fd);
    }

    private void write(char[] buf) {
        if (this.isClosed) {
            this.hasError = true;
            return;
        }
        this.doWrite(buf);
    }

    private void write(String s) {
        this.write(s.toCharArray());
    }

    private void newLine() {
        this.write(NEW_LINE_CHARS);
    }

    @Override
    public void print(boolean b) {
        this.write(b ? TRUE_CHARS : FALSE_CHARS);
    }

    @Override
    public void print(char c) {
        this.write(new char[]{c});
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void print(String s) {
        if (s == null) {
            this.write(NULL_CHARS);
        } else {
            this.write(s);
        }
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(Object x) {
        this.print(String.valueOf(x));
        this.newLine();
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        if (csq == null) {
            this.write(NULL_CHARS);
        } else {
            this.write(csq.subSequence(start, end).toString());
        }
        return this;
    }
}

