/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.print;

import com.oracle.svm.webimage.print.WebImagePrintingProvider;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;

public class WebImageOutputStream
extends OutputStream {
    public final WebImagePrintingProvider.Descriptor fd;

    WebImageOutputStream(FileDescriptor fd) {
        this.fd = WebImagePrintingProvider.Descriptor.from(fd);
    }

    @Override
    public void write(int b) throws IOException {
        WebImagePrintingProvider.singleton().print(this.fd, (byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        WebImagePrintingProvider.singleton().print(this.fd, b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        WebImagePrintingProvider.singleton().close(this.fd);
    }
}

