/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.print;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.print.WebImagePrintingProvider;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton(value={WebImagePrintingProvider.class})
@Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
public class WebImageJSPrintingProvider
extends WebImagePrintingProvider {
    @Override
    public void print(WebImagePrintingProvider.Descriptor fd, char[] chars) {
        switch (fd) {
            case OUT: {
                JSCallNode.call1(JSCallNode.PRINT_CHARS_OUT, chars);
                break;
            }
            case ERR: {
                JSCallNode.call1(JSCallNode.PRINT_CHARS_ERR, chars);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }

    @Override
    public void flush(WebImagePrintingProvider.Descriptor fd) {
        switch (fd) {
            case OUT: {
                JSCallNode.call(JSCallNode.PRINT_FLUSH_OUT);
                break;
            }
            case ERR: {
                JSCallNode.call(JSCallNode.PRINT_FLUSH_ERR);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }

    @Override
    public void close(WebImagePrintingProvider.Descriptor fd) {
        switch (fd) {
            case OUT: {
                JSCallNode.call(JSCallNode.PRINT_CLOSE_OUT);
                break;
            }
            case ERR: {
                JSCallNode.call(JSCallNode.PRINT_CLOSE_ERR);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }
}

