/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.print;

import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.List;

public class JSDecodeBuffer {
    public final Charset cs;
    private final ArrayList<Byte> bytes = new ArrayList(128);
    private final List<Character> chars = new ArrayList<Character>(128);

    public JSDecodeBuffer(Charset cs) {
        this.cs = cs;
    }

    public JSDecodeBuffer() {
        this(Charset.defaultCharset());
    }

    public void write(byte b) {
        this.bytes.add(b);
        this.tryDecode();
    }

    public void write(byte[] bs) {
        this.write(bs, 0, bs.length);
    }

    public void write(byte[] bs, int offset, int len) {
        this.bytes.ensureCapacity(this.bytes.size() + len);
        for (int i = 0; i < len; ++i) {
            this.bytes.add(bs[offset + i]);
        }
        this.tryDecode();
    }

    public int remaining() {
        return this.chars.size();
    }

    public char[] popAll() {
        char[] c = new char[this.remaining()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.chars.get(i).charValue();
        }
        this.chars.clear();
        return c;
    }

    public boolean hasNext() {
        return this.remaining() > 0;
    }

    protected void tryDecode() {
        ByteBuffer bb = ByteBuffer.allocate(this.bytes.size());
        bb.mark();
        for (Byte b : this.bytes) {
            bb.put(b);
        }
        bb.reset();
        this.bytes.clear();
        try {
            CharBuffer cb = this.decode(bb);
            int limit = cb.limit();
            for (int i = 0; i < limit; ++i) {
                this.chars.add(Character.valueOf(cb.get(i)));
            }
            while (bb.hasRemaining()) {
                this.bytes.add(bb.get());
            }
        }
        catch (CharacterCodingException e) {
            throw VMError.shouldNotReachHere((Throwable)e);
        }
    }

    protected CharBuffer decode(ByteBuffer in) throws CharacterCodingException {
        CoderResult cr;
        CharsetDecoder dec = this.cs.newDecoder();
        int n = (int)((float)in.remaining() * dec.averageCharsPerByte());
        CharBuffer out = CharBuffer.allocate(n);
        if (n == 0 && in.remaining() == 0) {
            return out;
        }
        dec.reset();
        while (!(cr = dec.decode(in, out, false)).isUnderflow()) {
            if (cr.isOverflow()) {
                n = 2 * n + 1;
                CharBuffer o = CharBuffer.allocate(n);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        out.flip();
        return out;
    }
}

