/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.object;

import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;

public abstract class ObjectInspector {
    public static final ObjectType NULL = new ObjectType(JavaConstant.NULL_POINTER, null, null, null);
    public static final ValueType TRUE = ValueType.forConstant(JavaConstant.TRUE);
    public static final ValueType FALSE = ValueType.forConstant(JavaConstant.FALSE);
    public static final ValueType ZERO_BYTE = ValueType.forConstant(JavaConstant.forByte((byte)0));
    public static final ValueType ZERO_SHORT = ValueType.forConstant(JavaConstant.forShort((short)0));
    public static final ValueType ZERO_CHAR = ValueType.forConstant(JavaConstant.forChar((char)'\u0000'));
    public static final ValueType ZERO_INT = ValueType.forConstant(JavaConstant.INT_0);
    public static final ValueType ZERO_LONG = ValueType.forConstant(JavaConstant.LONG_0);
    public static final ValueType ZERO_FLOAT = ValueType.forConstant(JavaConstant.FLOAT_0);
    public static final ValueType ZERO_DOUBLE = ValueType.forConstant(JavaConstant.DOUBLE_0);
    protected boolean isFrozen = false;

    public void freeze() {
        assert (!this.isFrozen) : "Object inspector is already frozen";
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public abstract ObjectDefinition inspectObject(JavaConstant var1, Object var2, ConstantIdentityMapping var3);

    public static class ObjectType
    extends ObjectDefinition {
        public List<ObjectDefinition> members;
        public final HostedType type;
        public final ClassFieldList fields;

        public ObjectType(JavaConstant constant, HostedType type, ClassFieldList fields, Object reason) {
            super(constant, reason);
            this.type = type;
            this.fields = fields;
        }

        public boolean isNull() {
            return this.getConstant().isNull();
        }

        @Override
        public long getSize() {
            return this.fields.fields.stream().mapToLong(f -> ObjectType.getKindSize(f.getJavaKind())).sum();
        }

        public String toString() {
            return "ObjectType(" + this.type.toClassName() + ", " + String.valueOf(this.getConstant()) + ")";
        }
    }

    public static class ClassFieldList {
        public List<HostedField> fields;
        public HostedType type;
        private static final AtomicInteger ID = new AtomicInteger(0);
        private final int id = ID.getAndIncrement();

        public static int getNumIDs() {
            return ID.get();
        }

        public int getId() {
            return this.id;
        }
    }

    public static final class ValueType
    extends ObjectDefinition {
        public final JavaKind kind;

        private ValueType(PrimitiveConstant constant) {
            super((JavaConstant)constant, null);
            this.kind = constant.getJavaKind();
        }

        public static ValueType forConstant(PrimitiveConstant c) {
            ValueType t = new ValueType(c);
            t.guaranteeHasType();
            return t;
        }

        public PrimitiveConstant getConstant() {
            return (PrimitiveConstant)super.getConstant();
        }

        @Override
        public long getSize() {
            return ValueType.getKindSize(this.kind);
        }

        public boolean asBoolean() {
            assert (this.kind == JavaKind.Boolean) : this.kind;
            return this.getConstant().asBoolean();
        }

        public byte asByte() {
            assert (this.kind == JavaKind.Byte) : this.kind;
            return (byte)this.getConstant().asInt();
        }

        public short asShort() {
            assert (this.kind == JavaKind.Short) : this.kind;
            return (short)this.getConstant().asInt();
        }

        public char asChar() {
            assert (this.kind == JavaKind.Char) : this.kind;
            return (char)this.getConstant().asInt();
        }

        public int asInt() {
            assert (this.kind == JavaKind.Int) : this.kind;
            return this.getConstant().asInt();
        }

        public long asLong() {
            assert (this.kind == JavaKind.Long) : this.kind;
            return this.getConstant().asLong();
        }

        public float asFloat() {
            assert (this.kind == JavaKind.Float) : this.kind;
            return this.getConstant().asFloat();
        }

        public double asDouble() {
            assert (this.kind == JavaKind.Double) : this.kind;
            return this.getConstant().asDouble();
        }

        public Object getBoxed() {
            return this.getConstant().asBoxedPrimitive();
        }

        public static String floatWithSpecialCases(float f) {
            if (Float.isNaN(f)) {
                return "Number.NaN";
            }
            if (f == Float.NEGATIVE_INFINITY) {
                return "Number.NEGATIVE_INFINITY";
            }
            if (f == Float.POSITIVE_INFINITY) {
                return "Number.POSITIVE_INFINITY";
            }
            return String.valueOf(f);
        }

        public static String doubleWithSpecialCases(double d) {
            if (Double.isNaN(d)) {
                return "Number.NaN";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "Number.NEGATIVE_INFINITY";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "Number.POSITIVE_INFINITY";
            }
            return String.valueOf(d);
        }

        public void guaranteeHasType() {
            JVMCIError.guarantee((this.kind.isPrimitive() && this.kind != JavaKind.Void ? 1 : 0) != 0, (String)"Primitive value cannot be without any type", (Object[])new Object[0]);
        }

        public String toString() {
            return "ValueType(" + this.getConstant().toString() + ")";
        }
    }

    public static class MethodPointerType
    extends ObjectDefinition {
        private final ResolvedJavaMethod method;
        private final long index;

        public MethodPointerType(JavaConstant constant, ResolvedJavaMethod method, int index, Object reason) {
            super(constant, reason);
            Objects.requireNonNull(method);
            this.method = method;
            this.index = index + 1;
        }

        public ResolvedJavaMethod getMethod() {
            return this.method;
        }

        public long getIndex() {
            return this.index;
        }

        @Override
        public long getSize() {
            return MethodPointerType.getKindSize(JavaKind.Long);
        }

        public String toString() {
            return "MethodPointerType(" + this.index + "," + this.method.getName() + ")";
        }
    }

    public static class StringType
    extends ObjectDefinition {
        public final String stringVal;
        protected byte[] bytes = null;

        public StringType(JavaConstant constant, String stringVal, Object reason) {
            super(constant, reason);
            this.stringVal = stringVal;
        }

        @Override
        public long getSize() {
            return this.getBytes().length;
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = this.stringVal.getBytes(StandardCharsets.UTF_8);
            }
            return this.bytes;
        }

        public String toString() {
            return "StringType(" + this.stringVal + ")";
        }
    }

    public static class ArrayType<T extends ObjectDefinition>
    extends ObjectDefinition {
        public List<T> elements;
        public final HostedType componentType;
        public boolean isAllEqual = false;

        public ArrayType(JavaConstant constant, HostedType componentType, Object reason) {
            super(constant, reason);
            this.componentType = componentType;
        }

        public int length() {
            return this.elements.size();
        }

        @Override
        public long getSize() {
            return (long)this.length() * ArrayType.getKindSize(this.componentType.getJavaKind());
        }

        public boolean isPrimitive() {
            return this.componentType.isPrimitive();
        }

        public String toString() {
            return "ArrayType(" + this.componentType.toClassName() + ", " + this.elements.size() + ")";
        }
    }

    public static abstract class ObjectDefinition {
        public int offset = -1;
        private final EconomicSet<Object> reasons = EconomicSet.create();
        private final JavaConstant constant;

        protected ObjectDefinition(JavaConstant constant, Object reason) {
            this.constant = constant;
            this.addReason(reason);
        }

        public final void addReason(Object r) {
            if (r != null) {
                this.reasons.add(r);
            }
        }

        public Object[] getReasons() {
            return this.reasons.toArray(new Object[this.reasons.size()]);
        }

        public JavaConstant getConstant() {
            return this.constant;
        }

        public abstract long getSize();

        public static long getKindSize(JavaKind kind) {
            return kind.isObject() ? 8L : (long)kind.getByteCount();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectDefinition) {
                ObjectDefinition other = (ObjectDefinition)obj;
                return Objects.equals(this.getConstant(), other.getConstant());
            }
            return false;
        }

        public int hashCode() {
            return this.getConstant().hashCode();
        }
    }
}

