/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.object;

import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.webimage.JSNameGenerator;
import com.oracle.svm.webimage.object.ObjectInspector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class ConstantIdentityMapping {
    private final EconomicMap<JavaConstant, IdentityNode> objectToIdentityLink;
    private final EconomicMap<HostedType, ObjectInspector.ClassFieldList> typeToFieldList;
    private final Set<ObjectInspector.StringType> internedStrings = new HashSet<ObjectInspector.StringType>();
    private final ArrayList<ResolvedJavaMethod> methodPointers = new ArrayList();
    private boolean allowInternStrings = true;

    public ConstantIdentityMapping() {
        this.objectToIdentityLink = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        this.typeToFieldList = EconomicMap.create();
    }

    public void putString(ObjectInspector.StringType str) {
        if (HostedStringDeduplication.isInternedString((String)str.stringVal)) {
            assert (this.allowInternStrings) : "Can no longer add interned strings: '" + String.valueOf(str) + "'";
            this.internedStrings.add(str);
        }
    }

    public int addMethodPointer(ResolvedJavaMethod method) {
        int i = this.methodPointers.indexOf(method);
        if (i == -1) {
            this.methodPointers.add(method);
            return this.methodPointers.size() - 1;
        }
        return i;
    }

    public ResolvedJavaMethod[] getMethodPointers() {
        return this.methodPointers.toArray(new ResolvedJavaMethod[0]);
    }

    public String[] getInternedStrings() {
        return (String[])this.internedStrings.stream().map(s -> s.stringVal).sorted().toArray(String[]::new);
    }

    public void disallowInternStrings() {
        this.allowInternStrings = false;
    }

    public void putFieldList(ObjectInspector.ClassFieldList list) {
        assert (!this.hasListForType(list.type)) : "Type " + String.valueOf(list.type) + " already has a field list";
        assert (list.type.getStorageKind() == JavaKind.Object) : list.type;
        this.typeToFieldList.put((Object)list.type, (Object)list);
    }

    public boolean hasListForType(HostedType ty) {
        return this.typeToFieldList.containsKey((Object)ty);
    }

    public ObjectInspector.ClassFieldList getListForType(HostedType ty) {
        assert (this.hasListForType(ty)) : "Type " + String.valueOf(ty) + " does not have a field list";
        return (ObjectInspector.ClassFieldList)this.typeToFieldList.get((Object)ty);
    }

    public Iterator<ObjectInspector.ClassFieldList> classFieldListIterator() {
        return this.typeToFieldList.getValues().iterator();
    }

    public void putObjectDef(ObjectInspector.ObjectDefinition def) {
        JavaConstant c = def.getConstant();
        assert (!this.objectToIdentityLink.containsKey((Object)c)) : "An identity mapping for object '" + String.valueOf(c) + "' already exists";
        this.objectToIdentityLink.put((Object)c, (Object)new IdentityNode(def));
    }

    public boolean hasMappingForObject(JavaConstant c) {
        return this.objectToIdentityLink.containsKey((Object)c);
    }

    public ObjectInspector.ObjectDefinition getDefByObject(JavaConstant c) {
        return this.getIdentityNode(c).getDefinition();
    }

    public IdentityNode getIdentityNode(JavaConstant c) {
        assert (this.objectToIdentityLink.containsKey((Object)c)) : "An identity mapping for object '" + String.valueOf(c) + "' does not exists";
        return (IdentityNode)this.objectToIdentityLink.get((Object)c);
    }

    public Iterable<IdentityNode> identityNodes() {
        return this.objectToIdentityLink.getValues();
    }

    public static final class IdentityNode {
        private final ObjectInspector.ObjectDefinition definition;
        private final int num;
        private String nodeName;
        private static final JSNameGenerator.NameCache<Integer> nameCache = new JSNameGenerator.NameCache("c");
        private static final AtomicInteger constantsIndex = new AtomicInteger(0);

        public IdentityNode(ObjectInspector.ObjectDefinition definition) {
            this.definition = definition;
            this.num = constantsIndex.getAndIncrement();
        }

        public String requestName() {
            if (!this.hasName()) {
                this.nodeName = nameCache.get(this.num);
            }
            return this.nodeName;
        }

        public String getName() {
            assert (this.hasName()) : "Identity node " + String.valueOf(this) + " does not have a name";
            return this.nodeName;
        }

        public boolean hasName() {
            return this.nodeName != null;
        }

        public int getNum() {
            return this.num;
        }

        public ObjectInspector.ObjectDefinition getDefinition() {
            return this.definition;
        }
    }
}

