/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.longemulation;

import com.oracle.svm.webimage.annotation.JSRawCall;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.webimage.api.JS;

@Platforms(value={WebImageJSPlatform.class})
public class Long64 {
    private static final int MASK_32 = -1;
    private static final int HWORD = 65535;
    private static final int HWORDW = 16;
    private static final int IntMinValue = Integer.MIN_VALUE;
    private static final int AskRemainder = 0;
    private static final int AskQuotient = 1;
    private static final int UnsignedSafeDoubleMask = -2097152;
    private static final double TwoPow32 = 4.294967296E9;
    public static Long64 LongZero = new Long64(0, 0);
    public static Long64 LongMinValue = new Long64(0, Integer.MIN_VALUE);
    public static Long64 LongMaxValue = new Long64(-1, Integer.MAX_VALUE);
    private final int low;
    private final int high;

    public Long64(int low, int high) {
        this.low = low;
        this.high = high;
    }

    public static Long64 fromInt(int n) {
        return new Long64(n, n >> 31);
    }

    @JSRawCall
    @JS(value="return a | 0;")
    private static native int rawToInt(double var0);

    public static Long64 fromDouble(double number) {
        if (Double.isNaN(number)) {
            return LongZero;
        }
        if (number >= 9.223372036854776E18) {
            return LongMaxValue;
        }
        if (number <= -9.223372036854776E18) {
            return LongMinValue;
        }
        int low = Long64.rawToInt(number % 4.294967296E9);
        int high = Long64.rawToInt(number / 4.294967296E9);
        if (number < 0.0 && low != 0) {
            --high;
        }
        return new Long64(low, high);
    }

    private static Long64 fromUnsignedSafeDouble(double number) {
        return new Long64(Long64.unsignedSafeDoubleLo(number), Long64.unsignedSafeDoubleHi(number));
    }

    private static int unsignedSafeDoubleHi(double number) {
        return Long64.rawToInt(number / 4.294967296E9);
    }

    private static int unsignedSafeDoubleLo(double number) {
        return Long64.rawToInt(number);
    }

    private static Long64 addInternal(int low1, int high1, int low2, int high2) {
        int low = low1 + low2;
        int high = (low ^ Integer.MIN_VALUE) < (low1 ^ Integer.MIN_VALUE) ? high1 + high2 + 1 : high1 + high2;
        return new Long64(low, high);
    }

    private static Long64 subInternal(int l1, int h1, int l2, int h2) {
        int low = l1 - l2;
        int high = (low ^ Integer.MIN_VALUE) > (l1 ^ Integer.MIN_VALUE) ? h1 - h2 - 1 : h1 - h2;
        return Long64.fromTwoInt(low, high);
    }

    private static Long64 mulInternal(int l1, int h1, int l2, int h2) {
        int a0 = l1 & 0xFFFF;
        int a1 = l1 >>> 16;
        int b0 = l2 & 0xFFFF;
        int b1 = l2 >>> 16;
        int a0b0 = a0 * b0;
        int a1b0 = a1 * b0;
        int a0b1 = a0 * b1;
        int low = a0b0 + (a1b0 + a0b1 << 16);
        int c1part = (a0b0 >>> 16) + a0b1;
        int high = l1 * h2 + h1 * l2 + a1 * b1 + (c1part >>> 16) + ((c1part & 0xFFFF) + a1b0 >>> 16);
        return Long64.fromTwoInt(low, high);
    }

    private static boolean isInt32(int l, int h) {
        return h == l >> 31;
    }

    private static Long64 absInternal(int low, int high) {
        if (high < 0) {
            int newHigh = low != 0 ? ~high : -high;
            return new Long64(-low, newHigh);
        }
        return new Long64(low, high);
    }

    private static Long64 divInternal(int l1, int h1, int l2, int h2) {
        if (Long64.isInt32(l1, h1)) {
            if (Long64.isInt32(l2, h2)) {
                if (l1 == Integer.MIN_VALUE && l2 == -1) {
                    return new Long64(Integer.MIN_VALUE, 0);
                }
                int low = l1 / l2;
                return new Long64(low, low >> 31);
            }
            if (l1 == Integer.MIN_VALUE && l2 == Integer.MIN_VALUE && h2 == 0) {
                return new Long64(-1, -1);
            }
            return LongZero;
        }
        boolean dividendIsNegative = h1 < 0;
        boolean divisorIsNegative = h2 < 0;
        int newL1 = l1;
        int newH1 = h1;
        int newL2 = l2;
        int newH2 = h2;
        if (h2 < 0) {
            newH2 = l2 != 0 ? ~h2 : -h2;
            newL2 = -l2;
        }
        if (h1 < 0) {
            newH1 = l1 != 0 ? ~h1 : -h1;
            newL1 = -l1;
        }
        Long64 quotient = Long64.divUnsignedInternal(newL1, newH1, newL2, newH2);
        if (dividendIsNegative && !divisorIsNegative || !dividendIsNegative && divisorIsNegative) {
            int newLow = ~quotient.low;
            int newHigh = ~quotient.high;
            if (++newLow == 0) {
                ++newHigh;
            }
            return new Long64(newLow, newHigh);
        }
        return quotient;
    }

    private static Long64 modInternal(int l1, int h1, int l2, int h2) {
        if (Long64.isInt32(l1, h1)) {
            if (Long64.isInt32(l2, h2)) {
                return Long64.fromTwoInt(l1 % l2, l1 >> 31);
            }
            if (l1 == Integer.MIN_VALUE && l2 == Integer.MIN_VALUE && h2 == 0) {
                return LongZero;
            }
            return Long64.fromTwoInt(l1, h1);
        }
        int newL1 = l1;
        int newH1 = h1;
        int newL2 = l2;
        int newH2 = h2;
        if (h2 < 0) {
            newH2 = l2 != 0 ? ~h2 : -h2;
            newL2 = -l2;
        }
        if (h1 < 0) {
            newH1 = l1 != 0 ? ~h1 : -h1;
            newL1 = -l1;
        }
        Long64 rem = Long64.modUnsignedInternal(newL1, newH1, newL2, newH2);
        int remLow = rem.low;
        int remHigh = rem.high;
        if (h1 < 0) {
            remLow = ~rem.low;
            remHigh = ~rem.high;
            if (++remLow == 0) {
                ++remHigh;
            }
        }
        return new Long64(remLow, remHigh);
    }

    private static Long64 divUnsignedInternal(int l1, int h1, int l2, int h2) {
        if (Long64.isUnsignedSafeDouble(h1)) {
            if (Long64.isUnsignedSafeDouble(h2)) {
                double dividendAsDouble = Long64.toNumber(new Long64(l1, h1));
                double divisorAsDouble = Long64.toNumber(new Long64(l2, h2));
                double resultDouble = dividendAsDouble / divisorAsDouble;
                return Long64.fromUnsignedSafeDouble(resultDouble);
            }
            return LongZero;
        }
        if (h2 == 0 && Long64.isPowerOfTwoIKnowItsNotZero(l2)) {
            int pow = Long64.log2OfPowerOfTwo(l2);
            return Long64.fromTwoInt(l1 >>> pow | h1 << 1 << 31 - pow, h1 >>> pow);
        }
        if (l2 == 0 && Long64.isPowerOfTwoIKnowItsNotZero(h2)) {
            int pow = Long64.log2OfPowerOfTwo(h2);
            return Long64.fromTwoInt(h1 >>> pow, 0);
        }
        return Long64.unsignedDivModHelper(l1, h1, l2, h2, 1);
    }

    @JSRawCall
    @JS(value="return a >>> 0;")
    private static native double asUInt(int var0);

    private static double asUnsignedSafeDouble(int low, int high) {
        return (double)high * 4.294967296E9 + Long64.asUInt(low);
    }

    private static Long64 modUnsignedInternal(int l1, int h1, int l2, int h2) {
        if (Long64.isUnsignedSafeDouble(h1)) {
            if (Long64.isUnsignedSafeDouble(h2)) {
                double dividendDouble = Long64.asUnsignedSafeDouble(l1, h1);
                double divisorDouble = Long64.asUnsignedSafeDouble(l2, h2);
                double remDouble = dividendDouble % divisorDouble;
                return Long64.fromUnsignedSafeDouble(remDouble);
            }
            return Long64.fromTwoInt(l1, h1);
        }
        if (h2 == 0 && Long64.isPowerOfTwoIKnowItsNotZero(l2)) {
            return Long64.fromTwoInt(l1 & l2 - 1, 0);
        }
        if (l2 == 0 && Long64.isPowerOfTwoIKnowItsNotZero(h2)) {
            return Long64.fromTwoInt(l1, h1 & h2 - 1);
        }
        return Long64.unsignedDivModHelper(l1, h1, l2, h2, 0);
    }

    private static Long64 unsignedDivModHelper(int l1, int h1, int l2, int h2, int mode) {
        int shift;
        Long64 initialBShift = Long64.slFromNum(Long64.fromTwoInt(l2, h2), shift);
        int bShiftLo = initialBShift.low;
        int bShiftHi = initialBShift.high;
        int remLo = l1;
        int remHi = h1;
        int quotLo = 0;
        int quotHi = 0;
        for (shift = Long64.numberOfLeadingZeroes(l2, h2) - Long64.numberOfLeadingZeroes(l1, h1); shift >= 0 && (remHi & 0xFFE00000) != 0; --shift) {
            if (Long64.unsignedGE(remLo, remHi, bShiftLo, bShiftHi)) {
                Long64 newRem = Long64.sub(Long64.fromTwoInt(remLo, remHi), Long64.fromTwoInt(bShiftLo, bShiftHi));
                remLo = newRem.low;
                remHi = newRem.high;
                if (shift < 32) {
                    quotLo |= 1 << shift;
                } else {
                    quotHi |= 1 << shift - 32;
                }
            }
            Long64 newBShift = Long64.usrFromNum(Long64.fromTwoInt(bShiftLo, bShiftHi), 1);
            bShiftLo = newBShift.low;
            bShiftHi = newBShift.high;
        }
        if (Long64.unsignedGE(remLo, remHi, l2, h2)) {
            double remDouble = Long64.toNumber(Long64.fromTwoInt(remLo, remHi));
            double bDouble = Long64.toNumber(Long64.fromTwoInt(l2, h2));
            if (mode == 1) {
                Long64 remDivBDouble = Long64.fromUnsignedSafeDouble(remDouble / bDouble);
                Long64 newQuot = Long64.addInternal(quotLo, quotHi, remDivBDouble.low, remDivBDouble.high);
                quotLo = newQuot.low;
                quotHi = newQuot.high;
            }
            if (mode == 0) {
                double remDivDouble = remDouble % bDouble;
                Long64 rem = Long64.fromUnsignedSafeDouble(remDivDouble);
                remLo = rem.low;
                remHi = rem.high;
            }
        }
        if (mode == 1) {
            return Long64.fromTwoInt(quotLo, quotHi);
        }
        return Long64.fromTwoInt(remLo, remHi);
    }

    private static Long64 slInternal(int l1, int h1, int l2) {
        int toShift = l2 & 0x3F;
        if (toShift == 0) {
            return new Long64(l1, h1);
        }
        if (toShift >= 32) {
            int shiftout = l1 << toShift - 32;
            return Long64.fromTwoInt(0, shiftout);
        }
        int shiftIn = l1 >>> 32 - toShift;
        return Long64.fromTwoInt(l1 << toShift, shiftIn | h1 << toShift);
    }

    private static Long64 srInternal(int l1, int h1, int l2) {
        int toShift = l2 & 0x3F;
        if (toShift == 0) {
            return Long64.fromTwoInt(l1, h1);
        }
        if (toShift >= 32) {
            return Long64.fromTwoInt(h1 >> toShift - 32, h1 >= 0 ? 0 : -1);
        }
        int shiftout = h1 << 32 - toShift;
        return Long64.fromTwoInt(l1 >>> toShift | shiftout, h1 >> toShift);
    }

    private static Long64 usrInternal(int l1, int h1, int l2) {
        int toShift = l2 & 0x3F;
        if (toShift == 0) {
            return Long64.fromTwoInt(l1, h1);
        }
        if (toShift == 32) {
            return Long64.fromTwoInt(h1, 0);
        }
        if (toShift >= 32) {
            return Long64.fromTwoInt(h1 >>> toShift - 32, 0);
        }
        int shiftout = h1 << 32 - toShift;
        return Long64.fromTwoInt(l1 >>> toShift | shiftout, h1 >>> toShift);
    }

    private static Long64 andInternal(int l1, int h1, int l2, int h2) {
        return Long64.fromTwoInt(l1 & l2, h1 & h2);
    }

    private static Long64 orInternal(int l1, int h1, int l2, int h2) {
        return Long64.fromTwoInt(l1 | l2, h1 | h2);
    }

    private static Long64 xorInternal(int l1, int h1, int l2, int h2) {
        return Long64.fromTwoInt(l1 ^ l2, h1 ^ h2);
    }

    private static Long64 notInternal(int l1, int h1) {
        return Long64.fromTwoInt(~l1, ~h1);
    }

    private static Long64 negateInternal(int low, int high) {
        return Long64.fromTwoInt(-low, low != 0 ? ~high : -high);
    }

    private static boolean equalInternal(int l1, int h1, int l2, int h2) {
        return l1 == l2 && h1 == h2;
    }

    private static boolean testInternal(int l1, int h1, int l2, int h2) {
        return (l1 & l2) == 0 && (h1 & h2) == 0;
    }

    public static Long64 add(Long64 left, Long64 right) {
        return Long64.addInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 sub(Long64 left, Long64 right) {
        return Long64.subInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 mul(Long64 left, Long64 right) {
        return Long64.mulInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 div(Long64 left, Long64 right) {
        return Long64.divInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 and(Long64 left, Long64 right) {
        return Long64.andInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 or(Long64 left, Long64 right) {
        return Long64.orInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 xor(Long64 left, Long64 right) {
        return Long64.xorInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 abs(Long64 x) {
        return Long64.absInternal(x.low, x.high);
    }

    public static Long64 not(Long64 left) {
        return Long64.notInternal(left.low, left.high);
    }

    public static Long64 mod(Long64 left, Long64 right) {
        return Long64.modInternal(left.low, left.high, right.low, right.high);
    }

    public static Long64 sl(Long64 left, Long64 right) {
        return Long64.slInternal(left.low, left.high, right.low);
    }

    public static Long64 sr(Long64 left, Long64 right) {
        return Long64.srInternal(left.low, left.high, right.low);
    }

    public static Long64 usr(Long64 left, Long64 right) {
        return Long64.usrInternal(left.low, left.high, right.low);
    }

    public static Long64 slFromNum(Long64 left, int num) {
        return Long64.slInternal(left.low, left.high, num);
    }

    public static Long64 srFromNum(Long64 left, int num) {
        return Long64.srInternal(left.low, left.high, num);
    }

    public static Long64 usrFromNum(Long64 left, int num) {
        return Long64.usrInternal(left.low, left.high, num);
    }

    public static Long64 negate(Long64 a) {
        return Long64.negateInternal(a.low, a.high);
    }

    public static boolean equal(Long64 l, Long64 r) {
        return Long64.equalInternal(l.low, l.high, r.low, r.high);
    }

    public static boolean lessThan(Long64 l, Long64 r) {
        if (l.high == r.high) {
            return (l.low ^ Integer.MIN_VALUE) < (r.low ^ Integer.MIN_VALUE);
        }
        return l.high < r.high;
    }

    public static boolean belowThan(Long64 l, Long64 r) {
        if (l.high == r.high) {
            return (l.low ^ Integer.MIN_VALUE) < (r.low ^ Integer.MIN_VALUE);
        }
        return (l.high ^ Integer.MIN_VALUE) < (r.high ^ Integer.MIN_VALUE);
    }

    public static boolean test(Long64 l, Long64 r) {
        return Long64.testInternal(l.low, l.high, r.low, r.high);
    }

    private static boolean unsignedGE(int l1, int h1, int l2, int h2) {
        if (h1 == h2) {
            return (l1 ^ Integer.MIN_VALUE) >= (l2 ^ Integer.MIN_VALUE);
        }
        return (h1 ^ Integer.MIN_VALUE) >= (h2 ^ Integer.MIN_VALUE);
    }

    private static int numberOfLeadingZeroes(int low, int high) {
        if (high != 0) {
            return Long64.numberOfLeadingZeroesInt(high);
        }
        return Long64.numberOfLeadingZeroesInt(low) + 32;
    }

    private static int log2OfPowerOfTwo(int h2) {
        return 31 - Long64.numberOfLeadingZeroesInt(h2);
    }

    private static int numberOfLeadingZeroesInt(int k) {
        int i = k;
        if (i == 0) {
            return 32;
        }
        int n = 1;
        if (i >>> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >>> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >>> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >>> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n -= i >>> 31;
    }

    private static boolean isPowerOfTwoIKnowItsNotZero(int a) {
        return (a & a - 1) == 0;
    }

    private static boolean isUnsignedSafeDouble(int h1) {
        return (h1 & 0xFFE00000) == 0;
    }

    public static Long64 fromTwoInt(int low, int high) {
        return new Long64(low, high);
    }

    public static Long64 fromZeroExtend(int a) {
        return new Long64(a, 0);
    }

    public static int lowBits(Long64 a) {
        return a.low;
    }

    public static int highBits(Long64 a) {
        return a.high;
    }

    public static int compare(Long64 a, Long64 b) {
        if (a.high == b.high) {
            if (a.low == b.low) {
                return 0;
            }
            if ((a.low ^ Integer.MIN_VALUE) < (b.low ^ Integer.MIN_VALUE)) {
                return -1;
            }
            return 1;
        }
        if (a.high < b.high) {
            return -1;
        }
        return 1;
    }

    public static int compareUnsigned(Long64 a, Long64 b) {
        if (a.high == b.high) {
            if (a.low == b.low) {
                return 0;
            }
            if ((a.low ^ Integer.MIN_VALUE) < (b.low ^ Integer.MIN_VALUE)) {
                return -1;
            }
            return 1;
        }
        if ((a.high ^ Integer.MIN_VALUE) < (b.high ^ Integer.MIN_VALUE)) {
            return -1;
        }
        return 1;
    }

    public static double toNumber(Long64 a) {
        return Long64.asUnsignedSafeDouble(a.low, a.high);
    }
}

