/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.jni;

import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.EconomicMap;
import org.graalvm.webimage.api.JS;
import org.graalvm.webimage.api.JSObject;
import org.graalvm.webimage.api.JSString;
import org.graalvm.webimage.api.JSUndefined;
import org.graalvm.word.PointerBase;

public class WebImageNativeLibrarySupport
extends PlatformNativeLibrarySupport {
    public PlatformNativeLibrarySupport.NativeLibrary createLibrary(String canonical, boolean builtIn) {
        return new JSNativeLibrary(this, canonical, builtIn);
    }

    public PointerBase findBuiltinSymbol(String name) {
        return Word.nullPointer();
    }

    public boolean initializeBuiltinLibraries() {
        return false;
    }

    @JS(value="return loadPrefetchedJSLibrary(content);")
    private static native JSObject loadPrefetchedJSLibrary(JSString var0);

    @JS.Coerce
    @JS(value="return runtime.addToFuntab(f)")
    private static native int addFunctionToFuntab(JSObject var0);

    class JSNativeLibrary
    implements PlatformNativeLibrarySupport.NativeLibrary {
        private final String canonicalIdentifier;
        private final boolean builtin;
        private final EconomicMap<String, Integer> symbolAddresses;
        private JSObject symbolTable;

        JSNativeLibrary(WebImageNativeLibrarySupport this$0, String canonicalIdentifier, boolean builtin) {
            this.canonicalIdentifier = canonicalIdentifier;
            this.builtin = builtin;
            this.symbolTable = null;
            this.symbolAddresses = EconomicMap.create();
        }

        public String getCanonicalIdentifier() {
            return this.canonicalIdentifier;
        }

        public boolean isBuiltin() {
            return this.builtin;
        }

        public boolean isLoaded() {
            return this.symbolTable != null;
        }

        public boolean load() {
            assert (this.symbolTable == null) : "Symbol table for library already loaded: " + String.valueOf(this.symbolTable);
            assert (!this.builtin);
            try {
                byte[] bytes = Files.readAllBytes(new File(this.canonicalIdentifier).toPath());
                String content = new String(bytes, StandardCharsets.UTF_8);
                this.symbolTable = WebImageNativeLibrarySupport.loadPrefetchedJSLibrary(JSString.of((String)content));
            }
            catch (Throwable ignored) {
                return false;
            }
            return this.symbolTable != null;
        }

        public boolean unload() {
            throw VMError.unimplemented((String)"Unloading native libraries is not implemented on Web Image");
        }

        public PointerBase findSymbol(String name) {
            Integer address = (Integer)this.symbolAddresses.get((Object)name);
            if (address == null) {
                Object entry = this.symbolTable.get((Object)name);
                if (entry == null || entry == JSUndefined.undefined()) {
                    return Word.nullPointer();
                }
                address = WebImageNativeLibrarySupport.addFunctionToFuntab((JSObject)entry);
                this.symbolAddresses.put((Object)name, (Object)address);
            }
            return Word.pointer((long)address.intValue());
        }
    }
}

