/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.heap;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapLayouter;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.remset.NoRememberedSet;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.webimage.heap.WebImageJSHeap;
import com.oracle.svm.webimage.heap.WebImageNopAllocationSupport;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import jdk.graal.compiler.nodes.gc.NoBarrierSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageJSPlatform.class})
public class JSHeapFeature
implements InternalFeature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(GCAllocationSupport.class, (Object)new WebImageNopAllocationSupport());
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(BarrierSetProvider.class, metaAccess -> new NoBarrierSet());
        ImageSingletons.add(Heap.class, (Object)((Object)new WebImageJSHeap()));
        ImageSingletons.add(RememberedSet.class, (Object)new NoRememberedSet());
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        ChunkedImageHeapLayouter heapLayouter = new ChunkedImageHeapLayouter(new ImageHeapInfo(), (long)Heap.getHeap().getImageHeapOffsetInAddressSpace());
        ImageSingletons.add(ImageHeapLayouter.class, (Object)heapLayouter);
    }
}

