/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.functionintrinsics;

import com.oracle.svm.webimage.functionintrinsics.JSFunctionDefinition;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.IEmitter;

public class JSGenericFunctionDefinition
implements JSFunctionDefinition {
    protected final String functionName;
    protected final int nrOfArgs;
    protected final boolean staticFunction;
    protected final String protoTypeName;
    protected final boolean isNewInstance;

    public JSGenericFunctionDefinition(String functionName, int nrOfArgs, boolean staticFunction, String protoTypeName, boolean isNewInstance) {
        this.functionName = functionName;
        this.nrOfArgs = nrOfArgs;
        this.staticFunction = staticFunction;
        this.protoTypeName = protoTypeName;
        this.isNewInstance = isNewInstance;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public int getNrOfArgs() {
        return this.nrOfArgs;
    }

    @Override
    public boolean isStatic() {
        return this.staticFunction;
    }

    @Override
    public void emitReference(CodeGenTool loweringTool) {
        CodeBuffer masm = loweringTool.getCodeBuffer();
        if (!this.isNewInstance && this.staticFunction) {
            masm.emitText(this.protoTypeName);
            masm.emitText(".");
        }
        masm.emitText(this.functionName);
    }

    protected void emitCallPrefix(CodeGenTool jsLTools) {
        CodeBuffer masm = jsLTools.getCodeBuffer();
        if (this.isNewInstance) {
            masm.emitText("new ");
        }
        this.emitReference(jsLTools);
    }

    @Override
    public void emitCall(CodeGenTool jsLTools, IEmitter ... params) {
        CodeBuffer masm = jsLTools.getCodeBuffer();
        this.emitCallPrefix(jsLTools);
        masm.emitText("(");
        if (params != null) {
            jsLTools.genCommaList(params);
        }
        masm.emitText(")");
    }

    public String toString() {
        return "JSGenericFunction - name:" + this.functionName + " nrOfParams:" + this.nrOfArgs + " ProtoName:" + this.protoTypeName;
    }
}

