/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.functionintrinsics;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.ExitError;
import com.oracle.svm.webimage.annotation.JSRawCall;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import java.util.Arrays;
import org.graalvm.webimage.api.JS;

public class JSFunctionIntrinsics {
    @JSRawCall
    @JS(value="return o === undefined;")
    public static native boolean isUndefined(Object var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(boolean var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(byte var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(short var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(char var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(int var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(float var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(long var0);

    @JSRawCall
    @JS(value="return o;")
    public static native Object getRaw(double var0);

    public static void setExitCode(int exitCode) {
        JSCallNode.intConsumer(JSCallNode.SET_EXIT_CODE, exitCode);
    }

    public static void printNative(Object o) {
        JSCallNode.call1(JSCallNode.LLOG, o);
    }

    public static void arrayCopy(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        JSCallNode.arrayCopy(JSCallNode.ARRAY_COPY, fromArray, fromIndex, toArray, toIndex, length);
    }

    public static void exit(int status) {
        throw new ExitError(status);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long currentTimeMillis() {
        return (long)JSCallNode.doubleSupplier(JSCallNode.CURRENT_TIME_MILLIS_DATE);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static double performanceNow() {
        return JSCallNode.doubleSupplier(JSCallNode.PERFORMANCE_NOW);
    }

    public static int readBytesFromStdIn(byte[] b, int off, int len) {
        throw VMError.unimplemented((String)("readBytesFromStdIn(" + Arrays.toString(b) + ", " + off + ", " + len + ")"));
    }

    public static Object generateStackTrace() {
        return JSCallNode.supplier(JSCallNode.GEN_CALL_STACK);
    }

    public static Object generateBacktrace() {
        return JSCallNode.supplier(JSCallNode.GEN_BACKTRACE);
    }

    public static String formatStacktrace(Object backtrace) {
        return (String)JSCallNode.function(JSCallNode.FORMAT_STACKTRACE, backtrace);
    }

    public static String getCurrentWorkingDirectory() {
        return (String)JSCallNode.supplier(JSCallNode.GET_CURRENT_WORKING_DIRECTORY);
    }

    public static boolean canReadFile() {
        return true;
    }

    public static double sin(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_SIN, a);
    }

    public static double cos(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_COS, a);
    }

    public static double tan(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_TAN, a);
    }

    public static double asin(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_ASIN, a);
    }

    public static double acos(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_ACOS, a);
    }

    public static double atan(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_ATAN, a);
    }

    public static double exp(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_EXP, a);
    }

    public static double log(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_LOG, a);
    }

    public static double log10(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_LOG10, a);
    }

    public static double sqrt(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_SQRT, a);
    }

    public static double IEEEremainder(double a, double b) {
        return a % b;
    }

    public static double atan2(double a, double b) {
        return JSCallNode.toDoubleBiFunction(JSCallNode.STRICT_MATH_ATAN2, a, b);
    }

    public static double sinh(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_SINH, a);
    }

    public static double cosh(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_COSH, a);
    }

    public static double tanh(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_TANH, a);
    }

    public static double hypot(double a, double b) {
        return JSCallNode.toDoubleBiFunction(JSCallNode.STRICT_MATH_HYPOT, a, b);
    }

    public static double expm1(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_EXPM1, a);
    }

    public static double log1p(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_LOG1P, a);
    }

    public static double pow(double a, double b) {
        return JSCallNode.toDoubleBiFunction(JSCallNode.STRICT_MATH_POW, a, b);
    }

    public static double cbrt(double a) {
        return JSCallNode.toDoubleFunction(JSCallNode.STRICT_MATH_CBRT, a);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long malloc(long size) {
        return JSCallNode.toLongFunction(JSCallNode.MEM_MALLOC, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long calloc(long size) {
        return JSCallNode.toLongFunction(JSCallNode.MEM_CALLOC, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long realloc(long ptr, long newSize) {
        return JSCallNode.toLongBiFunction(JSCallNode.MEM_REALLOC, ptr, newSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(long ptr) {
        JSCallNode.longConsumer(JSCallNode.MEM_FREE, ptr);
    }

    @JSRawCall
    @JS(value="return toJavaString(i.toString());")
    public static native String numberToString(int var0);

    private static void ensureInitialized(DynamicHub hub) {
        hub.ensureInitialized();
    }
}

