/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.functionintrinsics;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.JSExceptionSupport;
import com.oracle.svm.webimage.JSNameGenerator;
import com.oracle.svm.webimage.annotation.JSRawCall;
import com.oracle.svm.webimage.annotation.WebImage;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.wasmgc.annotation.WasmExport;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.webimage.api.JS;
import org.graalvm.webimage.api.JSBigInt;
import org.graalvm.webimage.api.JSBoolean;
import org.graalvm.webimage.api.JSError;
import org.graalvm.webimage.api.JSNumber;
import org.graalvm.webimage.api.JSObject;
import org.graalvm.webimage.api.JSString;
import org.graalvm.webimage.api.JSSymbol;
import org.graalvm.webimage.api.JSUndefined;
import org.graalvm.webimage.api.JSValue;

public abstract class JSConversion {
    @Fold
    static JSConversion instance() {
        return (JSConversion)ImageSingletons.lookup(JSConversion.class);
    }

    @WasmExport(value="class.getkindordinal", comment="Ordinal of the JavaKind the given class represents")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static int getKindOrdinal(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return JavaKind.Boolean.ordinal();
        }
        if (clazz == Byte.TYPE) {
            return JavaKind.Byte.ordinal();
        }
        if (clazz == Short.TYPE) {
            return JavaKind.Short.ordinal();
        }
        if (clazz == Character.TYPE) {
            return JavaKind.Char.ordinal();
        }
        if (clazz == Integer.TYPE) {
            return JavaKind.Int.ordinal();
        }
        if (clazz == Long.TYPE) {
            return JavaKind.Long.ordinal();
        }
        if (clazz == Float.TYPE) {
            return JavaKind.Float.ordinal();
        }
        if (clazz == Double.TYPE) {
            return JavaKind.Double.ordinal();
        }
        if (clazz == Void.TYPE) {
            return JavaKind.Void.ordinal();
        }
        return JavaKind.Object.ordinal();
    }

    private static <T extends JSValue> T createJSValue(Class<T> clazz, Object jsNativeObject) {
        try {
            Constructor<T> defaultCtor = clazz.getDeclaredConstructor(new Class[0]);
            defaultCtor.setAccessible(true);
            JSValue instance = (JSValue)defaultCtor.newInstance(new Object[0]);
            JSConversion.setJavaScriptNative(instance, jsNativeObject);
            return (T)instance;
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere((String)("Failed to create " + clazz.getName() + " object"), (Throwable)e);
        }
    }

    @WasmExport(value="convert.create.jsundefined")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static JSUndefined createJSUndefined() {
        return JSValue.undefined();
    }

    @WasmExport(value="convert.create.jsboolean")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static JSBoolean createJSBoolean(Object jsBoolean) {
        return JSConversion.createJSValue(JSBoolean.class, jsBoolean);
    }

    @WasmExport(value="convert.create.jsnumber")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static JSNumber createJSNumber(Object jsNumber) {
        return JSConversion.createJSValue(JSNumber.class, jsNumber);
    }

    @WasmExport(value="convert.create.jsbigint")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static JSBigInt createJSBigInt(Object jsBigInt) {
        return JSConversion.createJSValue(JSBigInt.class, jsBigInt);
    }

    @WasmExport(value="convert.create.jsstring")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static JSString createJSString(Object jsString) {
        return JSConversion.createJSValue(JSString.class, jsString);
    }

    @WasmExport(value="convert.create.jssymbol")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static JSSymbol createJSSymbol(Object jsSymbol) {
        return JSConversion.createJSValue(JSSymbol.class, jsSymbol);
    }

    @WasmExport(value="convert.create.jsobject")
    public static JSObject createJSObject(Object jsObject) {
        return JSConversion.createJSValue(JSObject.class, jsObject);
    }

    @WasmExport(value="unbox.double")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static double extractJavaScriptNumber(Double d) {
        return d;
    }

    @JSRawCall
    @JS(value="return conversion.extractJavaScriptString(s);")
    public static native Object extractJavaScriptString(String var0);

    public abstract void setJavaScriptNativeImpl(JSValue var1, Object var2);

    public static void setJavaScriptNative(JSValue self, Object jsNative) {
        JSConversion.instance().setJavaScriptNativeImpl(self, jsNative);
    }

    public abstract Object extractJavaScriptNativeImpl(JSValue var1);

    public static Object extractJavaScriptNative(JSValue self) {
        return JSConversion.instance().extractJavaScriptNativeImpl(self);
    }

    @JSRawCall
    @JS(value="return undefined;")
    private static native Object javaScriptUndefined();

    @JSRawCall
    @JS(value="return conversion.toProxy(self);")
    public static native Object extractJavaScriptProxy(Object var0);

    @JSRawCall
    @JS(value="const javaNative = proxy[runtime.symbol.javaNative]; return javaNative === undefined ? null : javaNative;")
    public static native Object unproxy(Object var0);

    @WasmExport(value="box.boolean")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Boolean createJavaBoolean(boolean b) {
        return b;
    }

    @WasmExport(value="box.byte")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Byte createJavaByte(byte b) {
        return b;
    }

    @WasmExport(value="box.short")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Short createJavaShort(short s) {
        return s;
    }

    @WasmExport(value="box.char")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Character createJavaCharacter(char c) {
        return Character.valueOf(c);
    }

    @WasmExport(value="box.int")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Integer createJavaInteger(int i) {
        return i;
    }

    @WasmExport(value="box.float")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Float createJavaFloat(float f) {
        return Float.valueOf(f);
    }

    @WasmExport(value="box.long")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Long createJavaLong(long l) {
        return l;
    }

    @WasmExport(value="box.double")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Double createJavaDouble(double d) {
        return d;
    }

    @WasmExport(value="convert.coerce.boolean")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static boolean coerceToJavaScriptBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw JSConversion.throwClassCastException(obj, "boolean");
    }

    @WasmExport(value="convert.coerce.number")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static double coerceToJavaScriptNumber(Object obj) {
        if (obj instanceof Double || obj instanceof Long || obj instanceof Integer || obj instanceof Float || obj instanceof Short || obj instanceof Byte) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        throw JSConversion.throwClassCastException(obj, "number");
    }

    @WebImage.OmitClosureReturnType
    @WasmExport(value="convert.coerce.bigint")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Object coerceToJavaScriptBigInt(Object obj) {
        if (obj instanceof Double || obj instanceof Long || obj instanceof Integer || obj instanceof Float || obj instanceof Short || obj instanceof Byte) {
            String s = Long.valueOf(((Number)obj).longValue()).toString();
            return JSConversion.extractJavaScriptString(s);
        }
        if (obj instanceof Character) {
            return JSConversion.extractJavaScriptString(Long.valueOf(((Character)obj).charValue()).toString());
        }
        if (obj instanceof BigInteger) {
            return JSConversion.extractJavaScriptString(obj.toString());
        }
        throw JSConversion.throwClassCastException(obj, "number");
    }

    @WasmExport(value="convert.coerce.string")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Object coerceToJavaScriptString(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return JSConversion.extractJavaScriptString(str);
        }
        throw JSConversion.throwClassCastException(obj, "string");
    }

    @WasmExport(value="convert.coerce.object")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static Object coerceToJavaScriptObject(Object obj) {
        if (obj instanceof boolean[] || obj instanceof byte[] || obj instanceof char[] || obj instanceof short[] || obj instanceof int[] || obj instanceof float[] || obj instanceof long[] || obj instanceof double[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "object");
    }

    public static Object coerceToJavaScriptUint8Array(Object obj) {
        if (obj instanceof boolean[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "Uint8Array");
    }

    public static Object coerceToJavaScriptInt8Array(Object obj) {
        if (obj instanceof byte[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "Int8Array");
    }

    public static Object coerceToJavaScriptUint16Array(Object obj) {
        if (obj instanceof char[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "Uint16Array");
    }

    public static Object coerceToJavaScriptInt16Array(Object obj) {
        if (obj instanceof short[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "Int16Array");
    }

    public static Object coerceToJavaScriptInt32Array(Object obj) {
        if (obj instanceof int[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "Int32Array");
    }

    public static Object coerceToJavaScriptFloat32Array(Object obj) {
        if (obj instanceof float[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "Float32Array");
    }

    public static Object coerceToJavaScriptBigInt64Array(Object obj) {
        if (obj instanceof long[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "BigInt64Array");
    }

    public static char[] createCharArray(int length) {
        return new char[length];
    }

    public static Object coerceToJavaScriptFloat64Array(Object obj) {
        if (obj instanceof double[]) {
            return obj;
        }
        throw JSConversion.throwClassCastException(obj, "Float64Array");
    }

    public static int lengthOf(Object[] array) {
        return array.length;
    }

    public static Class<?> hubOf(Object x) {
        return x.getClass();
    }

    public static boolean isSupertype(Class<?> x, Class<?> y) {
        return x.isAssignableFrom(y);
    }

    @WasmExport(value="convert.isjavalangstring")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static boolean isJavaLangString(Object x) {
        return x instanceof String;
    }

    @JSRawCall
    @JS(value="return conversion.isInternalJavaObject(obj) ? obj : toJavaString(obj.toString());")
    private static native Object asJavaObjectOrString(Object var0);

    public static ClassCastException throwClassCastExceptionForClass(Object obj, Class<?> tpe) {
        throw new ClassCastException("'" + String.valueOf(JSConversion.asJavaObjectOrString(obj)) + "' cannot be coerced to '" + tpe.getSimpleName() + "'.");
    }

    @WasmExport(value="convert.throwClassCastException")
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    public static ClassCastException throwClassCastException(Object obj, String tpe) {
        throw new ClassCastException("'" + String.valueOf(JSConversion.asJavaObjectOrString(obj)) + "' cannot be coerced to a JavaScript '" + tpe + "'.");
    }

    @WasmExport(value="convert.javatojavascript")
    public static Object javaToJavaScript(Object x) {
        JSValue jsValue;
        Object javaScriptValue;
        if (x == null) {
            return null;
        }
        if (x == JSValue.undefined()) {
            return JSConversion.javaScriptUndefined();
        }
        if (x instanceof JSValue && (javaScriptValue = JSConversion.extractJavaScriptNative(jsValue = (JSValue)x)) != null) {
            return javaScriptValue;
        }
        return JSConversion.extractJavaScriptProxy(x);
    }

    @JSRawCall
    @JS(value="return conversion.javaScriptToJava(x);")
    public static native Object javaScriptToJava(Object var0);

    public static Object coerceJavaToJavaScript(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof JSValue) {
            return x;
        }
        if (x instanceof Number) {
            Number num = (Number)x;
            if (x instanceof BigInteger) {
                BigInteger bigInt = (BigInteger)x;
                return JSBigInt.of((BigInteger)bigInt);
            }
            if (x instanceof Long) {
                Long l = (Long)x;
                return JSBigInt.of((long)l);
            }
            if (x instanceof Integer || x instanceof Float || x instanceof Double || x instanceof Byte || x instanceof Short) {
                return JSNumber.of((double)num.doubleValue());
            }
        }
        if (x instanceof String) {
            String str = (String)x;
            return JSString.of((String)str);
        }
        if (x instanceof Boolean) {
            Boolean bool = (Boolean)x;
            return JSBoolean.of((boolean)bool);
        }
        if (x instanceof Character) {
            Character c = (Character)x;
            return JSNumber.of((double)c.charValue());
        }
        Class<?> cls = x.getClass();
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            return JSConversion.createJSObject(x);
        }
        return x;
    }

    public static <T> T coerceJavaScriptToJava(Object x, Class<T> target) {
        if (x == null) {
            return null;
        }
        if (x instanceof JSValue) {
            JSValue jsValue = (JSValue)x;
            return (T)jsValue.as(target);
        }
        if (target.isAssignableFrom(x.getClass())) {
            return (T)x;
        }
        throw JSConversion.throwClassCastExceptionForClass(x, target);
    }

    public static void handleJSError(Object excp) throws Throwable {
        if (JSExceptionSupport.isThrowable(excp)) {
            throw (Throwable)excp;
        }
        Object obj = JSConversion.javaScriptToJava(excp);
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            throw t;
        }
        throw new JSError(obj);
    }

    static {
        JSNameGenerator.registerReservedSymbols("$as", "$vm");
    }
}

