/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.functionintrinsics;

import com.oracle.svm.webimage.functionintrinsics.JSSystemFunction;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(nameTemplate="JSCall#{p#function}", cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Setting a value for the cycles does not make sense in the Web Image context", size=NodeSize.SIZE_IGNORED)
@Node.NodeIntrinsicFactory
public class JSCallNode
extends FixedWithNextNode {
    public static final NodeClass<JSCallNode> TYPE = NodeClass.create(JSCallNode.class);
    public static final String WEB_IMAGE_CYCLES_RATIONALE = "Setting a value for the cycles does not make sense in the Web Image context";
    public static final Stamp DOUBLE_STAMP = StampFactory.forKind((JavaKind)JavaKind.Double);
    public static final Stamp LONG_STAMP = StampFactory.forKind((JavaKind)JavaKind.Long);
    public static final Stamp INTEGER_STAMP = StampFactory.forKind((JavaKind)JavaKind.Int);
    public static final JSSystemFunction LLOG = new JSSystemFunction("llog", JavaKind.Object);
    public static final JSSystemFunction SET_EXIT_CODE = new JSSystemFunction("runtime.setExitCode", JavaKind.Int);
    public static final JSSystemFunction ARRAY_COPY = new JSSystemFunction("arrayCopy", JavaKind.Object, JavaKind.Int, JavaKind.Object, JavaKind.Int, JavaKind.Int);
    public static final JSSystemFunction SHOULD_NOT_REACH_HERE = new JSSystemFunction("ShouldNotReachHere", JavaKind.Object);
    public static final JSSystemFunction CURRENT_TIME_MILLIS_DATE = new JSSystemFunction("Date.now", DOUBLE_STAMP, new JavaKind[0]);
    public static final JSSystemFunction PERFORMANCE_NOW = new JSSystemFunction("performance.now", DOUBLE_STAMP, new JavaKind[0]);
    public static final JSSystemFunction ARRAYS_COPY_OF_0 = new JSSystemFunction("arraysCopyOf", StampFactory.objectNonNull(), JavaKind.Object, JavaKind.Int, null);
    public static final JSSystemFunction ARRAYS_COPY_OF_1 = new JSSystemFunction("arraysCopyOfWithHub", StampFactory.objectNonNull(), JavaKind.Object, JavaKind.Int, JavaKind.Object, null);
    public static final JSSystemFunction PRINT_CHARS_OUT = new JSSystemFunction("stdoutWriter.printChars", JavaKind.Object);
    public static final JSSystemFunction PRINT_CHARS_ERR = new JSSystemFunction("stderrWriter.printChars", JavaKind.Object);
    public static final JSSystemFunction PRINT_FLUSH_OUT = new JSSystemFunction("stdoutWriter.flush", new JavaKind[0]);
    public static final JSSystemFunction PRINT_CLOSE_OUT = new JSSystemFunction("stdoutWriter.close", new JavaKind[0]);
    public static final JSSystemFunction PRINT_FLUSH_ERR = new JSSystemFunction("stderrWriter.flush", new JavaKind[0]);
    public static final JSSystemFunction PRINT_CLOSE_ERR = new JSSystemFunction("stderrWriter.close", new JavaKind[0]);
    public static final JSSystemFunction GEN_BACKTRACE = new JSSystemFunction("genBacktrace", StampFactory.objectNonNull(), new JavaKind[0]);
    public static final JSSystemFunction FORMAT_STACKTRACE = new JSSystemFunction("formatStackTrace", StampFactory.objectNonNull(), JavaKind.Object);
    public static final JSSystemFunction GEN_CALL_STACK = new JSSystemFunction("gen_call_stack", StampFactory.objectNonNull(), new JavaKind[0]);
    public static final JSSystemFunction GET_CURRENT_WORKING_DIRECTORY = new JSSystemFunction("getCurrentWorkingDirectory", StampFactory.objectNonNull(), new JavaKind[0]);
    public static final JSSystemFunction PRINT_STACK_TRACE = new JSSystemFunction("console.trace", new JavaKind[0]);
    public static final JSSystemFunction STRICT_MATH_SIN = new JSSystemFunction("Math.sin", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_COS = new JSSystemFunction("Math.cos", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_TAN = new JSSystemFunction("Math.tan", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_ASIN = new JSSystemFunction("Math.asin", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_ACOS = new JSSystemFunction("Math.acos", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_ATAN = new JSSystemFunction("Math.atan", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_EXP = new JSSystemFunction("Math.exp", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_LOG = new JSSystemFunction("Math.log", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_LOG10 = new JSSystemFunction("Math.log10", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_SQRT = new JSSystemFunction("Math.sqrt", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_ATAN2 = new JSSystemFunction("Math.atan2", DOUBLE_STAMP, JavaKind.Double, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_SINH = new JSSystemFunction("Math.sinh", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_COSH = new JSSystemFunction("Math.cosh", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_TANH = new JSSystemFunction("Math.tanh", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_HYPOT = new JSSystemFunction("Math.hypot", DOUBLE_STAMP, JavaKind.Double, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_EXPM1 = new JSSystemFunction("Math.exmp1", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_LOG1P = new JSSystemFunction("Math.log1p", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_POW = new JSSystemFunction("Math.pow", DOUBLE_STAMP, JavaKind.Double, JavaKind.Double);
    public static final JSSystemFunction STRICT_MATH_CBRT = new JSSystemFunction("Math.cbrt", DOUBLE_STAMP, JavaKind.Double);
    public static final JSSystemFunction MATH_IMUL = new JSSystemFunction("Math.imul", INTEGER_STAMP, JavaKind.Int, JavaKind.Int);
    public static final JSSystemFunction MEM_MALLOC = new JSSystemFunction("heap.malloc", LONG_STAMP, JavaKind.Long);
    public static final JSSystemFunction MEM_CALLOC = new JSSystemFunction("heap.calloc", LONG_STAMP, JavaKind.Long);
    public static final JSSystemFunction MEM_REALLOC = new JSSystemFunction("heap.realloc", LONG_STAMP, JavaKind.Long, JavaKind.Long);
    public static final JSSystemFunction MEM_FREE = new JSSystemFunction("heap.free", JavaKind.Long);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    protected final JSSystemFunction function;

    public JSSystemFunction getFunctionDefinition() {
        return this.function;
    }

    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    public JSCallNode(JSSystemFunction function, Stamp s, ValueNode ... args) {
        super(TYPE, s);
        this.arguments = new NodeInputList((Node)this, (Node[])args);
        this.function = function;
        assert (args.length == function.getNrOfArgs()) : "Function " + String.valueOf(function) + " has " + function.getNrOfArgs() + " arguments, but " + args.length + " were given.";
        for (int i = 0; i < args.length; ++i) {
            JavaKind argKind = args[i].getStackKind();
            JavaKind expected = function.getArgKinds()[i];
            if (expected != null) assert (expected.getStackKind() == argKind) : String.valueOf(function) + ": For argument " + i + ", expected " + String.valueOf(expected) + ", but got " + String.valueOf(argKind);
        }
    }

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter Stamp s, JSSystemFunction function, ValueNode ... args) {
        JSCallNode node = new JSCallNode(function, s, args);
        node.asNode().setStamp(s);
        JavaKind returnKind = s.getStackKind();
        if (returnKind == JavaKind.Void) {
            b.add((Node)node.asNode());
        } else {
            b.addPush(returnKind, node.asNode());
        }
        return true;
    }

    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return "JSCall#" + String.valueOf(this.function);
        }
        return super.toString(verbosity);
    }

    @Node.NodeIntrinsic
    public static native void call(@Node.ConstantNodeParameter JSSystemFunction var0);

    @Node.NodeIntrinsic
    public static native void call1(@Node.ConstantNodeParameter JSSystemFunction var0, Object var1);

    @Node.NodeIntrinsic
    public static native Object supplier(@Node.ConstantNodeParameter JSSystemFunction var0);

    @Node.NodeIntrinsic
    public static native Object function(@Node.ConstantNodeParameter JSSystemFunction var0, Object var1);

    @Node.NodeIntrinsic
    public static native double doubleSupplier(@Node.ConstantNodeParameter JSSystemFunction var0);

    @Node.NodeIntrinsic
    public static native double toDoubleFunction(@Node.ConstantNodeParameter JSSystemFunction var0, double var1);

    @Node.NodeIntrinsic
    public static native double toDoubleBiFunction(@Node.ConstantNodeParameter JSSystemFunction var0, double var1, double var3);

    @Node.NodeIntrinsic
    public static native long toLongFunction(@Node.ConstantNodeParameter JSSystemFunction var0, long var1);

    @Node.NodeIntrinsic
    public static native long toLongBiFunction(@Node.ConstantNodeParameter JSSystemFunction var0, long var1, long var3);

    @Node.NodeIntrinsic
    public static native void longConsumer(@Node.ConstantNodeParameter JSSystemFunction var0, long var1);

    @Node.NodeIntrinsic
    public static native void intConsumer(@Node.ConstantNodeParameter JSSystemFunction var0, int var1);

    @Node.NodeIntrinsic
    public static native void arrayCopy(@Node.ConstantNodeParameter JSSystemFunction var0, Object var1, int var2, Object var3, int var4, int var5);
}

