/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.functionintrinsics;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.word.LocationIdentity;

public class ImplicitExceptions {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CHECK_NULL_POINTER = SnippetRuntime.findForeignCall(ImplicitExceptions.class, (String)"checkNullPointer", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.ANY_LOCATION});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CHECK_ARRAY_BOUND = SnippetRuntime.findForeignCall(ImplicitExceptions.class, (String)"checkArrayBound", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.ANY_LOCATION});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CHECK_NULL_POINTER, CHECK_ARRAY_BOUND};

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    @NeverInline(value="outlining for smaller code size")
    public static NullPointerException createNewNullPointerException() {
        return new NullPointerException();
    }

    @NeverInline(value="outlining for smaller code size")
    public static ArrayIndexOutOfBoundsException createNewOutOfBoundsException() {
        return new ArrayIndexOutOfBoundsException();
    }

    @NeverInline(value="outlining for smaller code size")
    public static ArrayIndexOutOfBoundsException createNewOutOfBoundsExceptionWithArgs(int index, int length) {
        return new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for length " + length);
    }

    @NeverInline(value="outlining for smaller code size")
    public static ClassCastException createNewClassCastExceptionWithArgs(Object object, Class<?> expectedClass) {
        assert (object != null) : "null can be cast to any type, so it cannot show up as a source of a ClassCastException";
        return new ClassCastException(object.getClass().getTypeName() + " cannot be cast to " + expectedClass.getTypeName());
    }

    @NeverInline(value="outlining for smaller code size")
    public static ArrayStoreException createNewArrayStoreExceptionWithArgs(Object value) {
        assert (value != null) : "null can be stored into any array, so it cannot show up as a source of an ArrayStoreException";
        return new ArrayStoreException(value.getClass().getTypeName());
    }

    @NeverInline(value="outlining for smaller code size")
    public static NegativeArraySizeException createNegativeArraySizeException(int length) {
        return new NegativeArraySizeException(String.valueOf(length));
    }

    @NeverInline(value="outlining for smaller code size")
    public static IncompatibleClassChangeError createNewIncompatibleClassChangeError() {
        return new IncompatibleClassChangeError();
    }

    @NeverInline(value="outlining for smaller code size")
    public static IllegalArgumentException createNewNegativeLengthException() {
        return new IllegalArgumentException("Negative length");
    }

    @NeverInline(value="outlining for smaller code size")
    public static IllegalArgumentException createNewArgumentIsNotArrayException() {
        return new IllegalArgumentException("Argument is not an array");
    }

    @NeverInline(value="outlining for smaller code size")
    public static ArithmeticException createNewArithmeticException() {
        return new ArithmeticException();
    }

    @NeverInline(value="outlining for smaller code size")
    public static ArithmeticException createNewDivisionByZeroException() {
        return new ArithmeticException("/ by zero");
    }

    @NeverInline(value="outlining for smaller code size")
    public static AssertionError createNewAssertionErrorNullary() {
        return new AssertionError();
    }

    @NeverInline(value="outlining for smaller code size")
    public static AssertionError createNewAssertionErrorObject(Object detailMessage) {
        return new AssertionError(detailMessage);
    }

    @NeverInline(value="outlining for smaller code size")
    public static void throwNewNullPointerException() {
        throw ImplicitExceptions.createNewNullPointerException();
    }

    @NeverInline(value="outlining for smaller code size")
    public static void throwNewOutOfBoundsException() {
        throw ImplicitExceptions.createNewOutOfBoundsException();
    }

    @NeverInline(value="outlining for smaller code size")
    public static void throwNewOutOfBoundsExceptionWithArgs(int index, int length) {
        throw ImplicitExceptions.createNewOutOfBoundsExceptionWithArgs(index, length);
    }

    @NeverInline(value="outlining for smaller code size")
    public static void throwNewClassCastExceptionWithArgs(Object object, Class<?> expectedClass) {
        throw ImplicitExceptions.createNewClassCastExceptionWithArgs(object, expectedClass);
    }

    @NeverInline(value="outlining for smaller code size")
    public static void throwNewArrayStoreExceptionWithArgs(Object value) {
        throw ImplicitExceptions.createNewArrayStoreExceptionWithArgs(value);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @NeverInline(value="outlining null checks")
    public static void checkNullPointer(Object obj) {
        if (obj == null) {
            throw ImplicitExceptions.createNewNullPointerException();
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @NeverInline(value="outlining array bound check")
    public static void checkArrayBound(boolean invalid) {
        if (invalid) {
            throw ImplicitExceptions.createNewOutOfBoundsException();
        }
    }
}

