/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.fs;

import com.oracle.svm.webimage.fs.FileSystemInitializer;
import com.oracle.svm.webimage.fs.WebImageNIOFileSystem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;

public class WebImageNIOFileSystemProvider
extends FileSystemProvider {
    public static final WebImageNIOFileSystemProvider INSTANCE = new WebImageNIOFileSystemProvider();
    private WebImageNIOFileSystem theFileSystem;

    private FileSystemProvider getDelegate() {
        return this.getTheFileSystem().delegate.provider();
    }

    private WebImageNIOFileSystem getTheFileSystem() {
        if (this.theFileSystem == null) {
            this.theFileSystem = new WebImageNIOFileSystem(this, FileSystemInitializer.createFileSystem());
            FileSystemInitializer.populate(this.theFileSystem);
        }
        return this.theFileSystem;
    }

    private static URI convertURI(URI uri) {
        if (uri.getScheme().equals("file")) {
            try {
                return new URI("jimfs", uri.getUserInfo(), "NIVFS", uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return uri;
    }

    private static FileSystemProvider getJimfsSystemProvider() {
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!provider.getScheme().equalsIgnoreCase("jimfs")) continue;
            return provider;
        }
        throw new FileSystemNotFoundException("Provider \"jimfs\" not installed");
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.getTheFileSystem();
    }

    @Override
    public Path getPath(URI uri) {
        this.getTheFileSystem();
        return WebImageNIOFileSystemProvider.getJimfsSystemProvider().getPath(WebImageNIOFileSystemProvider.convertURI(uri));
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getDelegate().newByteChannel(path, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.getDelegate().newDirectoryStream(dir, filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.getDelegate().createDirectory(dir, attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.getDelegate().delete(path);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.getDelegate().copy(source, target, options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.getDelegate().move(source, target, options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.getDelegate().isSameFile(path, path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.getDelegate().isHidden(path);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.getDelegate().getFileStore(path);
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.getDelegate().checkAccess(path, modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.getDelegate().getFileAttributeView(path, type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.getDelegate().readAttributes(path, type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.getDelegate().readAttributes(path, attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.getDelegate().setAttribute(path, attribute, value, options);
    }
}

