/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.fs;

import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.shadowed.com.google.common.jimfs.Configuration;
import org.graalvm.shadowed.com.google.common.jimfs.Jimfs;
import org.graalvm.webimage.api.JS;
import org.graalvm.webimage.api.JSNumber;
import org.graalvm.webimage.api.JSObject;
import org.graalvm.webimage.api.JSString;

public final class FileSystemInitializer {
    public static final String FS_NAME = "NIVFS";
    private static final String WORKING_DIR = System.getProperty("user.dir");
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");

    @JS(value="return runtime.prefetchedLibraryNames();")
    private static native JSObject prefetchedLibraryNames();

    @JS.Coerce
    @JS(value="return runtime.data.libraries[name];")
    private static native String prefetchedLibraryContent(String var0);

    @JS.Coerce
    @JS(value="runtime.data.libraries[name] = null;")
    private static native void clearPrefetchedLibraryContent(String var0);

    static FileSystem createFileSystem() {
        Configuration config = Configuration.unix().toBuilder().setWorkingDirectory(WORKING_DIR).setAttributeViews("basic", new String[]{"posix"}).build();
        return Jimfs.newFileSystem((String)FS_NAME, (Configuration)config);
    }

    static void populate(FileSystem fileSystem) {
        block5: {
            try {
                Files.createDirectories(fileSystem.getPath("/root", new String[0]), new FileAttribute[0]);
                Files.createDirectories(fileSystem.getPath("/usr", "lib"), new FileAttribute[0]);
                Files.createDirectories(fileSystem.getPath(TMP_DIR, new String[0]), new FileAttribute[0]);
                Files.createDirectories(fileSystem.getPath(WORKING_DIR, new String[0]), new FileAttribute[0]);
                Files.createDirectories(fileSystem.getPath("/dev", new String[0]), new FileAttribute[0]);
                Files.createFile(fileSystem.getPath("/dev", "random"), new FileAttribute[0]);
                Files.createFile(fileSystem.getPath("/dev", "urandom"), new FileAttribute[0]);
                if (Platform.includedIn(WebImageWasmLMPlatform.class) || Platform.includedIn(WebImageWasmGCPlatform.class)) break block5;
                JSObject prefetchedLibraryNames = FileSystemInitializer.prefetchedLibraryNames();
                int size = ((JSNumber)prefetchedLibraryNames.get((Object)"length")).asInt();
                for (int i = 0; i < size; ++i) {
                    JSString jsName = (JSString)prefetchedLibraryNames.get((Object)i);
                    String name = jsName.asString();
                    String content = FileSystemInitializer.prefetchedLibraryContent(name);
                    try {
                        Files.writeString(fileSystem.getPath("/usr", "lib", name), (CharSequence)content, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to store shared library.", e);
                    }
                    FileSystemInitializer.clearPrefetchedLibraryContent(name);
                }
            }
            catch (IOException e) {
                throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error while trying to populate in-memory file system");
            }
        }
    }
}

