/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.SystemInOutErrSupport;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.webimage.ExitError;
import com.oracle.svm.webimage.JSExceptionSupport;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionIntrinsics;
import com.oracle.svm.webimage.substitute.system.Target_java_lang_Throwable_Web;
import java.lang.reflect.Method;
import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class WebImageJavaMainSupport
extends JavaMainWrapper.JavaMainSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected WebImageJavaMainSupport(Method javaMainMethod) throws IllegalAccessException {
        super(javaMainMethod);
    }

    public static int run(String[] args) {
        int exitCode = WebImageJavaMainSupport.doRun(args, JavaMainWrapper::invokeMain);
        WebImageJavaMainSupport.setExitCode(exitCode);
        return exitCode;
    }

    public static int initializeLibrary(String[] args) {
        int exitCode = WebImageJavaMainSupport.doRun(args, Runner.NOP);
        WebImageJavaMainSupport.setExitCode(exitCode);
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int doRun(String[] args, Runner runner) {
        try {
            WebImageJavaMainSupport.startMainThread();
            String[] parsedArgs = RuntimeOptionParser.parseAndConsumeAllOptions((String[])args, (boolean)false);
            if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
                ((JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class)).mainArgs = parsedArgs;
            }
            runner.run(parsedArgs);
            int n = 0;
            return n;
        }
        catch (ExitError e) {
            int n = e.exitCode;
            return n;
        }
        catch (Throwable throwable) {
            WebImageJavaMainSupport.handleThrowable((Target_java_lang_Throwable_Web)SubstrateUtil.cast((Object)throwable, Target_java_lang_Throwable_Web.class));
            int n = 1;
            return n;
        }
        finally {
            SystemInOutErrSupport inOut = (SystemInOutErrSupport)ImageSingletons.lookup(SystemInOutErrSupport.class);
            inOut.err().flush();
            inOut.out().flush();
        }
    }

    private static void startMainThread() {
        PlatformThreads.singleton().assignMainThread();
        Isolates.assignStartTime();
    }

    protected static void handleThrowable(Target_java_lang_Throwable_Web t) {
        System.err.print("Exception in thread \"" + Thread.currentThread().getName() + "\" ");
        JSExceptionSupport.printStackTrace(t, System.err::println, new JSExceptionSupport.ExceptionToNonLocalizedString());
    }

    public static void setExitCode(int status) {
        JSFunctionIntrinsics.setExitCode(status);
    }

    public String getJavaCommand() {
        throw GraalError.unimplementedOverride();
    }

    public List<String> getInputArguments() {
        throw GraalError.unimplementedOverride();
    }

    @FunctionalInterface
    protected static interface Runner {
        public static final Runner NOP = ignored -> {};

        public void run(String[] var1) throws Throwable;
    }
}

