/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage;

import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.debug.MetricKey;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import org.graalvm.collections.EconomicMap;

public class Labeler {
    private static final String METHOD_LABEL = "METHOD-";
    private static final String METHOD_LABEL_BODY = "(){}";
    private static final String START_SUFFIX = "-START";
    private static final String END_SUFFIX = "-END";
    private static final int EXTRA_METHOD_LABEL_SIZE = "(){}".length() + 2;
    private static final String LABEL_PREFIX = "\"!p!r!e!f!i!x";
    private static final String LABEL_POSTFIX = "!p!o!s!t!f!i!x\"";
    protected final EconomicMap<Integer, HostedMethod> methodById = EconomicMap.create();

    public Injection injectMetricLabel(CodeBuffer codeBuffer, MetricKey key) {
        return new Injection(codeBuffer, key.getName(), this::injectLabel);
    }

    public Injection injectMethodLabel(CodeBuffer codeBuffer, HostedMethod method) {
        int methodId = this.methodById.size();
        this.methodById.put((Object)methodId, (Object)method);
        return new Injection(codeBuffer, METHOD_LABEL + methodId, this::injectFunctionLabel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSizeBetweenMetricLabels(String jsSource, LabelSizeHandler handler) {
        Pattern pattern = Pattern.compile("\"!p!r!e!f!i!x(\\S+?)(-START|-END)!p!o!s!t!f!i!x\"");
        Matcher labelMatcher = pattern.matcher(jsSource);
        ArrayList<LabelItem> labelStack = new ArrayList<LabelItem>(8);
        String total = "TOTAL";
        labelStack.add(new LabelItem("TOTAL", -1, -1));
        Consumer<Integer> addNestedLabelSize = delta -> {
            LabelItem item = (LabelItem)labelStack.get(labelStack.size() - 1);
            item.nestedLabelSize += delta.intValue();
        };
        boolean found = labelMatcher.find();
        while (found) {
            String label = labelMatcher.group(1);
            int startIndex = labelMatcher.start();
            int endIndex = labelMatcher.end();
            boolean isEndLabel = labelMatcher.group(2).equals(END_SUFFIX);
            int labelSize = labelMatcher.group().length();
            IllegalArgumentException exception = new IllegalArgumentException("Unmatched metric label found in compiled source: " + label);
            if (isEndLabel) {
                if (labelStack.size() < 1) {
                    throw exception;
                }
                LabelItem item = (LabelItem)labelStack.remove(labelStack.size() - 1);
                addNestedLabelSize.accept(item.nestedLabelSize + labelSize);
                if (!item.name.equals(label)) throw exception;
                if (label.startsWith(METHOD_LABEL)) {
                    addNestedLabelSize.accept(EXTRA_METHOD_LABEL_SIZE);
                    int methodId = Integer.parseInt(label.substring(METHOD_LABEL.length()));
                    int size = startIndex - item.endIndex - EXTRA_METHOD_LABEL_SIZE;
                    handler.handle(this.methodById.get((Object)methodId), size);
                } else {
                    int size = startIndex - item.endIndex;
                    handler.handle(label, size - item.nestedLabelSize);
                }
            } else {
                addNestedLabelSize.accept(labelSize);
                if (label.startsWith(METHOD_LABEL)) {
                    addNestedLabelSize.accept(EXTRA_METHOD_LABEL_SIZE);
                }
                labelStack.add(new LabelItem(label, startIndex, endIndex));
            }
            found = labelMatcher.find();
        }
        assert (labelStack.size() == 1 && ((LabelItem)labelStack.get((int)0)).name.equals("TOTAL")) : "Dangling metric label found in compiled source.";
        return ((LabelItem)labelStack.get((int)0)).nestedLabelSize;
    }

    protected void injectLabel(CodeBuffer codeBuffer, String label) {
        codeBuffer.emitText("_:");
        codeBuffer.emitText(LABEL_PREFIX);
        codeBuffer.emitText(label);
        codeBuffer.emitText(LABEL_POSTFIX);
        codeBuffer.emitText(";");
        codeBuffer.emitNewLine();
    }

    protected void injectFunctionLabel(CodeBuffer codeBuffer, String functionName) {
        codeBuffer.emitText(LABEL_PREFIX);
        codeBuffer.emitText(functionName);
        codeBuffer.emitText(LABEL_POSTFIX);
        codeBuffer.emitText(METHOD_LABEL_BODY);
        codeBuffer.emitNewLine();
    }

    public static final class Injection
    implements AutoCloseable {
        private final String label;
        private final CodeBuffer codeBuffer;
        private final BiConsumer<CodeBuffer, String> injectAction;

        private Injection(CodeBuffer codeBuffer, String label, BiConsumer<CodeBuffer, String> injectAction) {
            this.label = label;
            this.codeBuffer = codeBuffer;
            this.injectAction = injectAction;
            injectAction.accept(codeBuffer, label + Labeler.START_SUFFIX);
        }

        @Override
        public void close() {
            this.injectAction.accept(this.codeBuffer, this.label + Labeler.END_SUFFIX);
        }
    }

    private static class LabelItem {
        final String name;
        final int startIndex;
        final int endIndex;
        int nestedLabelSize;

        LabelItem(String name, int startIndex, int endIndex) {
            this.name = name;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }

    public static interface LabelSizeHandler {
        public void handle(Object var1, int var2);
    }

    public static final class NoOpLabeler
    extends Labeler {
        @Override
        protected void injectLabel(CodeBuffer codeBuffer, String label) {
        }

        @Override
        protected void injectFunctionLabel(CodeBuffer codeBuffer, String name) {
        }

        @Override
        public int getSizeBetweenMetricLabels(String jsSource, LabelSizeHandler handler) {
            return 0;
        }
    }
}

