/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionIntrinsics;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredImageSingleton(value={UnmanagedMemorySupport.class})
@Platforms(value={WebImageJSPlatform.class})
public class JSUnmanagedMemorySupport
implements UnmanagedMemorySupport {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T malloc(UnsignedWord size) {
        return (T)Word.pointer((long)JSFunctionIntrinsics.malloc(size.rawValue()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T calloc(UnsignedWord size) {
        return (T)Word.pointer((long)JSFunctionIntrinsics.calloc(size.rawValue()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T realloc(T ptr, UnsignedWord size) {
        return (T)Word.pointer((long)JSFunctionIntrinsics.realloc(ptr.rawValue(), size.rawValue()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void free(PointerBase ptr) {
        JSFunctionIntrinsics.free(ptr.rawValue());
    }
}

