/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class JSNameGenerator {
    private static final char[] CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789$".toCharArray();
    private static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));
    private static final HashSet<String> RESERVED_SYMBOLS = new HashSet<String>(Arrays.asList(new String[0]));
    private final AtomicInteger idx = new AtomicInteger();
    private final String prefix;

    public static String registerReservedSymbol(String name) {
        RESERVED_SYMBOLS.add(name);
        return name;
    }

    public static void registerReservedSymbols(String ... names) {
        for (String name : names) {
            JSNameGenerator.registerReservedSymbol(name);
        }
    }

    public JSNameGenerator(String prefix) {
        this.prefix = prefix;
    }

    private String nextNameInternal() {
        StringBuilder name = new StringBuilder();
        int numChars = CHARS.length;
        name.append(this.prefix);
        int i = this.idx.getAndIncrement();
        int ch = i % numChars;
        i /= numChars;
        name.append(CHARS[ch]);
        while (i > 0) {
            ch = --i % numChars;
            i /= numChars;
            name.append(CHARS[ch]);
        }
        return name.toString();
    }

    public String nextName() {
        String name;
        while (RESERVED_KEYWORDS.contains(name = this.nextNameInternal()) || RESERVED_SYMBOLS.contains(name)) {
        }
        return name;
    }

    public static class NameCache<T> {
        private final ConcurrentMap<T, String> cache = new ConcurrentHashMap<T, String>();
        private final JSNameGenerator generator;

        public NameCache(String prefix) {
            this.generator = new JSNameGenerator(prefix);
        }

        public String get(T id) {
            return this.cache.computeIfAbsent(id, key -> this.generator.nextName());
        }
    }
}

