/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.webimage.functionintrinsics.JSConversion;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionIntrinsics;
import com.oracle.svm.webimage.substitute.system.Target_java_lang_Throwable_Web;
import org.graalvm.webimage.api.JSError;
import org.graalvm.webimage.api.JSObject;
import org.graalvm.webimage.api.JSString;
import org.graalvm.webimage.api.JSValue;

public class JSExceptionSupport {
    @NeverInline(value="Throwable in catch block may also be JS objects (which is a bug) and we want to handle those separately.")
    public static boolean isThrowable(Object o) {
        return o instanceof Throwable;
    }

    public static void printStackTrace(Target_java_lang_Throwable_Web t, Printer s) {
        JSExceptionSupport.printStackTrace(t, s, new ExceptionToString());
    }

    public static void printStackTrace(Target_java_lang_Throwable_Web t, Printer s, ExceptionToString toString) {
        JSExceptionSupport.printStackTrace(t, s, toString, "", "");
    }

    public static void printStackTrace(Target_java_lang_Throwable_Web t, Printer s, ExceptionToString toString, String caption, String prefix) {
        JSObject jsObject;
        Object object;
        JSError jsError;
        Object thrownObject;
        Object object2;
        if (!JSExceptionSupport.isThrowable(t)) {
            Object proxied = JSConversion.unproxy(t);
            if (proxied instanceof Target_java_lang_Throwable_Web) {
                Target_java_lang_Throwable_Web target_java_lang_Throwable_Web = (Target_java_lang_Throwable_Web)proxied;
                JSExceptionSupport.printStackTrace(target_java_lang_Throwable_Web, s, toString, caption, prefix);
            } else {
                s.println(prefix + caption + "<JS Error>:");
                JSFunctionIntrinsics.printNative(t);
            }
            return;
        }
        s.println(prefix + caption + toString.apply(t));
        Object backtrace = t.backtrace;
        if (((Boolean)Options.DisableStackTraces.getValue()).booleanValue()) {
            s.println(prefix + "\tStacktraces have been disabled in this image");
        } else if (backtrace == null) {
            s.println(prefix + "\tThis exception does not have a stacktrace, this is a bug!");
        } else {
            String str;
            String string = backtrace instanceof String ? (str = (String)backtrace) : JSFunctionIntrinsics.formatStacktrace(backtrace);
            JSExceptionSupport.printNativeStacktrace(string, s, prefix);
        }
        for (Target_java_lang_Throwable_Web se : t.getSuppressed()) {
            JSExceptionSupport.printStackTrace(se, s, toString, Target_java_lang_Throwable_Web.SUPPRESSED_CAPTION, prefix + "\t");
        }
        Target_java_lang_Throwable_Web target_java_lang_Throwable_Web = t.getCause();
        if (target_java_lang_Throwable_Web != null) {
            JSExceptionSupport.printStackTrace(target_java_lang_Throwable_Web, s, toString, Target_java_lang_Throwable_Web.CAUSE_CAPTION, prefix);
        }
        if ((object2 = SubstrateUtil.cast((Object)t, Throwable.class)) instanceof JSError && (thrownObject = (jsError = (JSError)object2).getThrownObject()) instanceof JSObject && (object = (jsObject = (JSObject)thrownObject).get((Object)"stack")) instanceof JSValue) {
            JSValue stack = (JSValue)object;
            s.println(prefix + "Caused by JS Error: " + t.getMessage());
            if (stack instanceof JSString) {
                JSString jsString = (JSString)stack;
                JSExceptionSupport.printNativeStacktrace(jsString.asString(), s, prefix);
            } else {
                JSExceptionSupport.printNativeStacktrace("Unexpected stack trace: " + String.valueOf(stack), s, prefix);
            }
        }
    }

    private static void printNativeStacktrace(String stacktrace, Printer s, String prefix) {
        char[] chars = stacktrace.toCharArray();
        int startIdx = 0;
        for (int endIdx = 0; endIdx < chars.length; ++endIdx) {
            if (chars[endIdx] != '\n') continue;
            String line = stacktrace.substring(startIdx, endIdx);
            s.println(prefix + "\t" + line.stripLeading());
            startIdx = endIdx + 1;
        }
    }

    static class ExceptionToString {
        ExceptionToString() {
        }

        public String apply(Target_java_lang_Throwable_Web t) {
            return t.toString();
        }
    }

    @FunctionalInterface
    public static interface Printer {
        public void println(Object var1);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> DisableStackTraces = new HostedOptionKey((Object)false);
    }

    public static class ExceptionToNonLocalizedString
    extends ExceptionToString {
        @Override
        public String apply(Target_java_lang_Throwable_Web t) {
            String s = t.getClass().getName();
            String message = t.getMessage();
            return message != null ? s + ": " + message : s;
        }
    }
}

