/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.types;

import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import jdk.graal.compiler.debug.GraalError;

public abstract class WasmRefType
implements WasmValType {
    private static final Map<Kind, AbsHeap> nonNullTypes = new EnumMap<Kind, AbsHeap>(Kind.class);
    private static final Map<Kind, AbsHeap> nullableTypes = new EnumMap<Kind, AbsHeap>(Kind.class);
    public static final WasmRefType ANYREF = Kind.ANY.nullable();
    public static final WasmRefType FUNCREF = Kind.FUNC.nullable();
    public static final WasmRefType EXTERNREF = Kind.EXTERN.nullable();
    public static final WasmRefType NONE = Kind.NONE.nullable();
    public final boolean nullable;

    public WasmRefType(boolean nullable) {
        this.nullable = nullable;
    }

    public static TypeIndex nonNull(WasmId.Type id) {
        return new TypeIndex(false, id);
    }

    public static TypeIndex nullable(WasmId.Type id) {
        return new TypeIndex(true, id);
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isRef() {
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.nullable);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            return this.innerEquals((WasmRefType)obj);
        }
        return false;
    }

    public boolean equalsWithoutNullability(WasmRefType other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() == other.getClass()) {
            return this.innerEqualsWithoutNullability(other);
        }
        return false;
    }

    protected final boolean innerEquals(WasmRefType other) {
        return this.nullable == other.nullable && this.innerEqualsWithoutNullability(other);
    }

    protected abstract boolean innerEqualsWithoutNullability(WasmRefType var1);

    public WasmRefType withNullability(boolean isNullable) {
        return isNullable ? this.asNullable() : this.asNonNull();
    }

    public final WasmRefType asNonNull() {
        if (!this.nullable) {
            return this;
        }
        return this.constructNonNull();
    }

    public WasmRefType asNullable() {
        if (this.nullable) {
            return this;
        }
        return this.constructNullable();
    }

    protected abstract WasmRefType constructNonNull();

    protected abstract WasmRefType constructNullable();

    public abstract boolean isFuncRef();

    public static final class TypeIndex
    extends WasmRefType {
        public final WasmId.Type id;

        private TypeIndex(boolean nullable, WasmId.Type id) {
            super(nullable);
            this.id = id;
        }

        @Override
        protected boolean innerEqualsWithoutNullability(WasmRefType other) {
            return this.id == ((TypeIndex)other).id;
        }

        @Override
        protected WasmRefType constructNonNull() {
            return this.id.asNonNull();
        }

        @Override
        protected WasmRefType constructNullable() {
            return this.id.asNullable();
        }

        @Override
        public boolean isFuncRef() {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.id);
        }
    }

    public static enum Kind {
        ANY,
        EQ,
        I31,
        STRUCT,
        ARRAY,
        NONE,
        FUNC,
        NOFUNC,
        EXTERN,
        NOEXTERN;


        public AbsHeap nonNull() {
            return nonNullTypes.computeIfAbsent(this, kind -> new AbsHeap(false, (Kind)((Object)kind)));
        }

        public AbsHeap nullable() {
            return nullableTypes.computeIfAbsent(this, kind -> new AbsHeap(true, (Kind)((Object)kind)));
        }
    }

    public static final class AbsHeap
    extends WasmRefType {
        public final Kind kind;

        private AbsHeap(boolean nullable, Kind kind) {
            super(nullable);
            this.kind = kind;
        }

        @Override
        protected boolean innerEqualsWithoutNullability(WasmRefType other) {
            return this.kind == ((AbsHeap)other).kind;
        }

        @Override
        public WasmRefType constructNonNull() {
            return this.kind.nonNull();
        }

        @Override
        public WasmRefType constructNullable() {
            return this.kind.nullable();
        }

        @Override
        public boolean isFuncRef() {
            return this.kind == Kind.FUNC;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.kind});
        }
    }
}

