/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.types;

import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmStorageType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.List;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WasmGCUtil
extends WasmUtil {
    private final WebImageWasmGCProviders wasmProviders;

    public WasmGCUtil(WebImageWasmProviders providers) {
        super((CoreProviders)providers, ((HostedProviders)providers.getProviders()).getGraphBuilderPlugins());
        this.wasmProviders = (WebImageWasmGCProviders)providers;
    }

    @Override
    public WasmRefType typeForJavaClass(Class<?> clazz) {
        return (WasmRefType)super.typeForJavaClass(clazz);
    }

    @Override
    public WasmRefType getJavaLangObjectType() {
        return (WasmRefType)super.getJavaLangObjectType();
    }

    @Override
    public WasmRefType getHubObjectType() {
        return (WasmRefType)super.getHubObjectType();
    }

    @Override
    public WasmRefType getThrowableType() {
        return (WasmRefType)super.getThrowableType();
    }

    @Override
    public ResolvedJavaType canonicalizeJavaType(ResolvedJavaType type) {
        ResolvedJavaType canonical = super.canonicalizeJavaType(type);
        MetaAccessProvider metaAccess = this.providers.getMetaAccess();
        if (canonical.isInterface()) {
            return metaAccess.lookupJavaType(Object.class);
        }
        if (canonical.isArray()) {
            if (canonical.getComponentType().isPrimitive()) {
                return canonical;
            }
            return metaAccess.lookupJavaType(Object[].class);
        }
        return canonical;
    }

    public boolean isJavaLangObject(WasmRefType refType) {
        return refType.equalsWithoutNullability(this.getJavaLangObjectType());
    }

    public WasmId.StructType getJavaLangObjectId() {
        return this.wasmProviders.idFactory().newJavaStruct(this.providers.getMetaAccess().lookupJavaType(Object.class));
    }

    public WasmId.StructType getHubObjectId() {
        return this.wasmProviders.idFactory().newJavaStruct(this.providers.getMetaAccess().lookupJavaType(DynamicHub.class));
    }

    public WasmId.FuncType functionIdForMethod(TypeUse typeUse) {
        WasmIdFactory idFactory = this.wasmProviders.idFactory();
        WasmValType resultType = typeUse.getSingleResult();
        if (resultType != null && resultType.isRef()) {
            WasmRefType javaLangObjectType = this.wasmProviders.util().getJavaLangObjectType();
            TypeUse baseTypeUse = new TypeUse(typeUse.params, List.of(javaLangObjectType));
            WebImageWasmIds.DescriptorFuncType baseFuncType = idFactory.newFuncType(new FunctionTypeDescriptor(null, false, baseTypeUse));
            if (typeUse.hasResults() && resultType.equals(javaLangObjectType)) {
                return baseFuncType;
            }
            return idFactory.newFuncType(new FunctionTypeDescriptor(baseFuncType, true, typeUse));
        }
        return idFactory.newFuncType(FunctionTypeDescriptor.createSimple(typeUse));
    }

    @Override
    public WasmStorageType storageTypeForJavaType(JavaType type) {
        ResolvedJavaType resolvedType = this.canonicalizeJavaType(type.resolve(null));
        if (resolvedType.isPrimitive()) {
            return this.storageTypeForKind(resolvedType.getJavaKind());
        }
        if (resolvedType.isArray()) {
            JavaKind componentKind = resolvedType.getComponentType().getJavaKind();
            return this.wasmProviders.knownIds().arrayStructTypes.get(componentKind).asNullable();
        }
        assert (resolvedType.isInstanceClass());
        return this.wasmProviders.idFactory().newJavaStruct(resolvedType).asNullable();
    }

    @Override
    public WasmValType typeForNode(ValueNode n) {
        JavaKind kind = this.kindForNode(n);
        if (kind.isPrimitive()) {
            return WasmGCUtil.mapPrimitiveType(kind);
        }
        assert (kind == JavaKind.Object) : kind;
        return this.typeForStamp(n.stamp(NodeView.DEFAULT));
    }

    @Override
    protected JavaKind kindForStamp(Stamp stamp) {
        if (stamp.isNonObjectPointerStamp()) {
            throw GraalError.shouldNotReachHere((String)("Pointer stamps are not supported in the WasmGC backend: " + String.valueOf(stamp)));
        }
        return super.kindForStamp(stamp);
    }

    @Override
    public JavaKind kindForNode(ValueNode n) {
        if (n instanceof OffsetAddressNode) {
            return JavaKind.Int;
        }
        return super.kindForNode(n);
    }

    @Override
    public JavaKind memoryKind(Stamp accessStamp) {
        if (accessStamp instanceof AbstractObjectStamp) {
            return JavaKind.Object;
        }
        if (accessStamp instanceof AbstractPointerStamp) {
            throw GraalError.unimplemented((String)("AbstractPointerStamp: " + String.valueOf(accessStamp)));
        }
        return super.memoryKind(accessStamp);
    }
}

