/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.substitute;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.UnsupportedFeatureError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasmgc.substitute.WasmGCVMErrorSubstitutions;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import org.graalvm.nativeimage.Platforms;

@TargetClass(value=VMError.class)
@Platforms(value={WebImageWasmGCPlatform.class})
final class Target_com_oracle_svm_core_util_VMError_Web {
    Target_com_oracle_svm_core_util_VMError_Web() {
    }

    @Substitute
    private static RuntimeException shouldNotReachHere(String msg) {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere(msg, null);
    }

    @Substitute
    private static RuntimeException shouldNotReachHere(Throwable ex) {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere(null, ex);
    }

    @Substitute
    private static RuntimeException shouldNotReachHere(String msg, Throwable ex) {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere(msg, ex);
    }

    @Substitute
    private static RuntimeException shouldNotReachHereSubstitution() {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere("should not reach here: substitution reached at runtime", null);
    }

    @Substitute
    private static RuntimeException shouldNotReachHereUnexpectedInput(Object input) {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere("should not reach here: unexpected input could not be handled", null);
    }

    @Substitute
    private static RuntimeException shouldNotReachHereAtRuntime() {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere("should not reach here: this code is expected to be unreachable at runtime", null);
    }

    @Substitute
    private static RuntimeException shouldNotReachHereOverrideInChild() {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere("should not reach here: method should have been overridden in child", null);
    }

    @Substitute
    private static RuntimeException unsupportedPlatform() {
        throw WasmGCVMErrorSubstitutions.shouldNotReachHere("should not reach here: unsupported platform", null);
    }

    @Substitute
    private static RuntimeException intentionallyUnimplemented() {
        return Target_com_oracle_svm_core_util_VMError_Web.unsupportedFeature("this method has intentionally not been implemented");
    }

    @Substitute
    private static RuntimeException unsupportedFeature(String msg) {
        throw new UnsupportedFeatureError(msg);
    }
}

