/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.snippets;

import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class WasmGCAllocationSnippets
implements Snippets {
    @Snippet(allowMissingProbabilities=true)
    public static Object dynamicNewArraySnippet(Class<?> componentClass, int length) {
        Class nonNullComponentClass = PiNode.piCastNonNullClass(componentClass, (GuardingNode)SnippetAnchorNode.anchor());
        int nonNegativeLength = PiNode.piCastPositive((int)length, (GuardingNode)SnippetAnchorNode.anchor());
        if (nonNullComponentClass == Integer.TYPE) {
            return new int[length];
        }
        if (nonNullComponentClass == Boolean.TYPE) {
            return new boolean[length];
        }
        if (nonNullComponentClass == Byte.TYPE) {
            return new byte[length];
        }
        if (nonNullComponentClass == Short.TYPE) {
            return new short[length];
        }
        if (nonNullComponentClass == Character.TYPE) {
            return new char[length];
        }
        if (nonNullComponentClass == Long.TYPE) {
            return new long[length];
        }
        if (nonNullComponentClass == Float.TYPE) {
            return new float[length];
        }
        if (nonNullComponentClass == Double.TYPE) {
            return new double[length];
        }
        return DynamicNewArrayNode.newArray((Class)nonNullComponentClass, (int)nonNegativeLength, (JavaKind)JavaKind.Object);
    }

    public static class Templates
    extends SubstrateTemplates {
        public final SnippetTemplate.SnippetInfo dynamicNewArraySnippet;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.dynamicNewArraySnippet = this.snippet(providers, WasmGCAllocationSnippets.class, "dynamicNewArraySnippet", new LocationIdentity[0]);
        }
    }
}

