/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.phases;

import com.oracle.svm.hosted.webimage.codegen.phase.OutlineRuntimeChecksPhase;
import com.oracle.svm.hosted.webimage.codegen.phase.ReconstructionVerificationPhase;
import com.oracle.svm.hosted.webimage.codegen.phase.WebImageLowTier;
import com.oracle.svm.hosted.webimage.wasm.phases.UnorderedIsTruePhase;
import com.oracle.svm.hosted.webimage.wasm.phases.ValueDropPhase;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmStackifierReconstructionPhase;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmSwitchPhase;
import com.oracle.svm.hosted.webimage.wasmgc.phases.WasmGCSingleThreadedAtomicsPhase;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.StackifierReconstructionPhase;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.ExpandLogicPhase;
import jdk.graal.compiler.phases.common.LowTierLoweringPhase;

public class WebImageWasmGCLowTier
extends WebImageLowTier {
    public WebImageWasmGCLowTier(OptionValues options) {
        super(options);
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        this.prependPhase(new ValueDropPhase());
        this.prependPhase(new UnorderedIsTruePhase(canonicalizer));
        this.prependPhase(new WasmGCSingleThreadedAtomicsPhase());
        this.prependPhase((BasePhase)new ExpandLogicPhase(canonicalizer));
        this.prependPhase((BasePhase)new LowTierLoweringPhase(canonicalizer));
        this.prependPhase(new WasmSwitchPhase(canonicalizer));
        this.removePhase(ReconstructionVerificationPhase.class);
        this.removePhase(OutlineRuntimeChecksPhase.class);
    }

    @Override
    protected StackifierReconstructionPhase createStackifierPhase() {
        return new WasmStackifierReconstructionPhase();
    }
}

