/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.phases;

import com.oracle.svm.hosted.webimage.wasm.phases.SingleThreadedAtomicsPhase;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.LogicCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.ConstantReflectionProvider;

public class WasmGCSingleThreadedAtomicsPhase
extends SingleThreadedAtomicsPhase {
    @Override
    protected void processCAS(CoreProviders providers, AbstractCompareAndSwapNode cas) {
        FixedWithNextNode finalValue;
        StructuredGraph graph = cas.graph();
        Stamp memoryStamp = cas.getAccessStamp(NodeView.DEFAULT);
        Stamp valueStamp = cas.stamp(NodeView.DEFAULT);
        boolean isLogic = cas instanceof LogicCompareAndSwapNode;
        FixedWithNextNode oldValue = (FixedWithNextNode)graph.add((Node)new ReadNode(cas.getAddress(), cas.getLocationIdentity(), memoryStamp, cas.getBarrierType(), cas.getMemoryOrder()));
        AbstractMergeNode merge = (AbstractMergeNode)graph.add((Node)new MergeNode());
        FixedWithNextNode write = (FixedWithNextNode)graph.add((Node)new WriteNode(cas.getAddress(), cas.getLocationIdentity(), cas.getNewValue(), cas.getBarrierType(), cas.getMemoryOrder()));
        AbstractBeginNode successBegin = BeginNode.begin((FixedNode)write);
        EndNode successEnd = (EndNode)graph.add((Node)new EndNode());
        write.setNext((FixedNode)successEnd);
        EndNode failEnd = (EndNode)graph.add((Node)new EndNode());
        AbstractBeginNode failBegin = BeginNode.begin((FixedNode)failEnd);
        LogicNode condition = CompareNode.createCompareNode((StructuredGraph)graph, (CanonicalCondition)CanonicalCondition.EQ, (ValueNode)oldValue, (ValueNode)cas.getExpectedValue(), (ConstantReflectionProvider)providers.getConstantReflection(), (NodeView)NodeView.DEFAULT);
        IfNode ifNode = (IfNode)graph.add((Node)new IfNode(condition, successBegin, failBegin, ProfileData.BranchProbabilityData.injected((double)0.9)));
        if (isLogic) {
            ConstantNode successValue = ConstantNode.forBoolean((boolean)true, (StructuredGraph)graph);
            ConstantNode failValue = ConstantNode.forBoolean((boolean)false, (StructuredGraph)graph);
            finalValue = (ValueNode)graph.addOrUnique((Node)new ValuePhiNode(valueStamp, merge, new ValueNode[]{successValue, failValue}));
        } else {
            finalValue = oldValue;
        }
        cas.replaceAtUsages((Node)finalValue);
        cas.replaceAtPredecessor((Node)oldValue);
        graph.addAfterFixed(oldValue, (FixedNode)ifNode);
        merge.addForwardEnd(successEnd);
        merge.addForwardEnd(failEnd);
        graph.replaceFixedWithFixed((FixedWithNextNode)cas, (FixedWithNextNode)merge);
    }
}

