/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.image;

import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import java.util.ArrayList;
import java.util.List;

public class WasmGCPartition
implements ImageHeapPartition {
    private final String name;
    private final boolean isPseudo;
    private final List<ImageHeapObject> objects = new ArrayList<ImageHeapObject>();
    private long size = -1L;

    public WasmGCPartition(String name, boolean isPseudo) {
        this.name = name;
        this.isPseudo = isPseudo;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPseudo() {
        return this.isPseudo;
    }

    public List<ImageHeapObject> getObjects() {
        return this.objects;
    }

    public long getStartOffset() {
        return 0L;
    }

    public void setSize(long size) {
        assert (size >= 0L) : "Negative sizes are not allowed: " + size;
        assert (this.size == -1L) : "Size is already set";
        this.size = size;
    }

    public long getSize() {
        assert (this.size >= 0L) : "Size is not yet set";
        return this.size;
    }

    public void add(ImageHeapObject obj) {
        this.objects.add(obj);
        obj.setHeapPartition((ImageHeapPartition)this);
    }
}

