/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.image;

import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasmgc.image.WasmGCImageHeapLayoutInfo;
import com.oracle.svm.hosted.webimage.wasmgc.image.WasmGCPartition;
import java.nio.ByteBuffer;
import java.util.stream.StreamSupport;

public class WasmGCHeapLayouter
implements ImageHeapLayouter {
    private final WasmGCPartition singlePartition = new WasmGCPartition("WasmGCImageHeap", false);
    private final WasmGCPartition pseudoPartition = new WasmGCPartition("WasmGCPseudoPartition", true);
    private final long startOffset = 0L;

    public ImageHeapPartition[] getPartitions() {
        return new ImageHeapPartition[]{this.singlePartition, this.pseudoPartition};
    }

    public void assignObjectToPartition(ImageHeapObject info, boolean immutable, boolean references, boolean relocatable, boolean patched) {
        if (info.getWrapped() instanceof ImageHeapPrimitiveArray) {
            this.singlePartition.add(info);
        } else {
            this.pseudoPartition.add(info);
        }
    }

    public WasmGCImageHeapLayoutInfo layout(ImageHeap imageHeap, int pageSize, ImageHeapLayouter.ImageHeapLayouterCallback callback) {
        this.layoutPseudoPartition();
        this.doLayout();
        long totalSize = StreamSupport.stream(imageHeap.getObjects().spliterator(), false).mapToLong(ImageHeapObject::getSize).sum();
        long serializedSize = this.singlePartition.getStartOffset() + this.singlePartition.getSize() - 0L;
        return new WasmGCImageHeapLayoutInfo(0L, serializedSize, totalSize);
    }

    private void doLayout() {
        int offset = 0;
        for (ImageHeapObject info : this.singlePartition.getObjects()) {
            ImageHeapPrimitiveArray primitiveArray = (ImageHeapPrimitiveArray)info.getWrapped();
            info.setOffsetInPartition((long)offset);
            offset += primitiveArray.getType().getComponentType().getStorageKind().getByteCount() * primitiveArray.getLength();
        }
        this.singlePartition.setSize(offset);
    }

    private void layoutPseudoPartition() {
        long pseudoSize = 0L;
        for (ImageHeapObject info : this.pseudoPartition.getObjects()) {
            info.setOffsetInPartition(0L);
            pseudoSize = info.getSize();
        }
        this.pseudoPartition.setSize(pseudoSize);
    }

    public void writeMetadata(ByteBuffer imageHeapBytes, long imageHeapOffsetInBuffer) {
        throw VMError.shouldNotReachHere((String)"This method does not make sense in this backend");
    }
}

