/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSNodeLowerer;
import com.oracle.svm.hosted.webimage.codegen.node.ReadIdentityHashCodeNode;
import com.oracle.svm.hosted.webimage.codegen.node.WriteIdentityHashCodeNode;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.js.JSBodyNode;
import com.oracle.svm.hosted.webimage.js.JSBodyWithExceptionNode;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmIRWalker;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmBackend;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmNodeLowerer;
import com.oracle.svm.hosted.webimage.wasm.debug.WasmDebug;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmTrapNode;
import com.oracle.svm.hosted.webimage.wasm.snippets.WasmImportForeignCallDescriptor;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCAllocationSupport;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCArrayCopySupport;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCConversion;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCTypeCheckSupport;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCBuilder;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCCloneSupport;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCCodeGenTool;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCUnsafeTemplates;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmGCUtil;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import com.oracle.svm.webimage.functionintrinsics.JSSystemFunction;
import com.oracle.svm.webimage.wasm.WasmForeignCallDescriptor;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasmgc.WasmExtern;
import com.oracle.svm.webimage.wasmgc.WasmGCJSConversion;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.debug.BlackholeNode;
import jdk.graal.compiler.nodes.extended.AbstractBoxingNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.LoadArrayComponentHubNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.extended.PublishWritesNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.java.AbstractNewArrayNode;
import jdk.graal.compiler.nodes.java.AccessFieldNode;
import jdk.graal.compiler.nodes.java.AccessIndexedNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.ReachabilityFenceNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.LIRLowerableAccess;
import jdk.graal.compiler.nodes.memory.MemoryAnchorNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.word.WordCastNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WebImageWasmGCNodeLowerer
extends WebImageWasmNodeLowerer {
    private final WasmGCUtil gcUtil;
    private final WasmGCBuilder builder;
    protected static final Set<Class<?>> IGNORED_NODE_TYPES = new HashSet(WebImageJSNodeLowerer.IGNORED_NODE_TYPES);

    public WebImageWasmGCNodeLowerer(WasmCodeGenTool codeGenTool) {
        super(codeGenTool);
        this.gcUtil = (WasmGCUtil)this.util;
        this.builder = ((WasmGCCodeGenTool)codeGenTool).getWasmProviders().builder();
    }

    @Override
    protected WasmGCCodeGenTool masm() {
        return (WasmGCCodeGenTool)super.masm();
    }

    @Override
    public Collection<Class<?>> getIgnoredNodeTypes() {
        return IGNORED_NODE_TYPES;
    }

    @Override
    protected Instruction lowerTopLevelStatement(Node n, WasmIRWalker.Requirements reqs) {
        assert (!this.util.hasValue(n)) : n;
        if (n instanceof BlackholeNode) {
            BlackholeNode blackhole = (BlackholeNode)n;
            return this.lowerDrop(blackhole.getValue());
        }
        if (n instanceof ReturnNode) {
            ReturnNode returnNode = (ReturnNode)n;
            return this.lowerReturn(returnNode);
        }
        if (n instanceof ReachabilityFenceNode) {
            ReachabilityFenceNode reachabilityFence = (ReachabilityFenceNode)n;
            return this.lowerReachabilityFence(reachabilityFence);
        }
        if (n instanceof LoweredDeadEndNode) {
            return new Instruction.Unreachable();
        }
        if (n instanceof WasmTrapNode) {
            return new Instruction.Unreachable();
        }
        if (n instanceof MemoryAnchorNode) {
            return null;
        }
        if (n instanceof AssertionNode) {
            AssertionNode assertion = (AssertionNode)n;
            return WebImageWasmGCNodeLowerer.lowerAssert(assertion);
        }
        assert (n instanceof ValueNode) : n;
        return this.dispatch((ValueNode)n, reqs);
    }

    @Override
    protected Instruction lowerReturn(ReturnNode returnNode) {
        Instruction result;
        ValueNode resultNode = returnNode.result();
        if (resultNode == null) {
            result = null;
        } else {
            ResolvedJavaType returnType = this.masm.compilationResult.getReturnType();
            result = this.optionalDowncast(this.lowerExpression(resultNode), resultNode, resultNode.stamp(NodeView.DEFAULT), returnType);
        }
        return new Instruction.Return(result);
    }

    @Override
    protected Instruction lowerExpression(ValueNode n, WasmIRWalker.Requirements reqs) {
        AbstractPointerStamp pointerStamp;
        Instruction inst = super.lowerExpression(n, reqs);
        Stamp stamp = n.stamp(NodeView.DEFAULT);
        if (stamp instanceof AbstractPointerStamp && (pointerStamp = (AbstractPointerStamp)stamp).alwaysNull()) {
            if (!(inst instanceof Instruction.LocalGet)) {
                this.masm.genInst(new Instruction.Drop(inst));
            }
            return new Instruction.RefNull(WasmRefType.NONE);
        }
        return inst;
    }

    protected Instruction lowerUnwind(UnwindNode n) {
        return new Instruction.Call(this.masm().getKnownIds().throwTemplate.requestFunctionId(), this.lowerExpression(n.exception()));
    }

    @Override
    protected Instruction dispatch(ValueNode n, WasmIRWalker.Requirements reqs) {
        ValueNode valueNode = n;
        Objects.requireNonNull(valueNode);
        ValueNode valueNode2 = valueNode;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantNode.class, ParameterNode.class, BinaryNode.class, CompressionNode.class, UnwindNode.class, UnaryNode.class, ReadExceptionObjectNode.class, BoxNode.class, UnboxNode.class, LogicNode.class, ConditionalNode.class, FixedAccessNode.class, PiNode.class, IntegerDivRemNode.class, FixedValueAnchorNode.class, PublishWritesNode.class, LoadFieldNode.class, StoreFieldNode.class, ArrayLengthNode.class, AccessIndexedNode.class, InvokeNode.class, InvokeWithExceptionNode.class, ForeignCall.class, NewInstanceNode.class, DynamicNewInstanceNode.class, NewArrayNode.class, DynamicNewArrayNode.class, NewMultiArrayNode.class, ReadIdentityHashCodeNode.class, WriteIdentityHashCodeNode.class, LoadArrayComponentHubNode.class, LoadHubNode.class, JSCallNode.class, JSBodyNode.class, JSBodyWithExceptionNode.class, WordCastNode.class, FloatingWordCastNode.class}, (Object)valueNode2, n2)) {
            case 0 -> {
                ConstantNode constant = (ConstantNode)valueNode2;
                yield this.lowerConstant(constant);
            }
            case 1 -> {
                ParameterNode param = (ParameterNode)valueNode2;
                yield this.lowerParam(param);
            }
            case 2 -> {
                BinaryNode binary = (BinaryNode)valueNode2;
                yield this.lowerBinary(binary);
            }
            case 3 -> {
                CompressionNode compression = (CompressionNode)valueNode2;
                yield this.lowerCompression(compression, reqs);
            }
            case 4 -> {
                UnwindNode unwind = (UnwindNode)valueNode2;
                yield this.lowerUnwind(unwind);
            }
            case 5 -> {
                UnaryNode unary = (UnaryNode)valueNode2;
                yield this.lowerUnary(unary);
            }
            case 6 -> {
                ReadExceptionObjectNode readExceptionObject = (ReadExceptionObjectNode)valueNode2;
                yield this.lowerReadException(readExceptionObject);
            }
            case 7 -> {
                BoxNode box = (BoxNode)valueNode2;
                yield this.lowerBox(box, reqs);
            }
            case 8 -> {
                UnboxNode unbox = (UnboxNode)valueNode2;
                yield this.lowerUnbox(unbox);
            }
            case 9 -> {
                LogicNode logic = (LogicNode)valueNode2;
                yield this.lowerLogicNode(logic, reqs);
            }
            case 10 -> {
                ConditionalNode conditional = (ConditionalNode)valueNode2;
                yield this.lowerConditional(conditional);
            }
            case 11 -> {
                FixedAccessNode fixedAccess = (FixedAccessNode)valueNode2;
                yield this.lowerFixedAccess(fixedAccess);
            }
            case 12 -> {
                PiNode pi = (PiNode)valueNode2;
                yield this.lowerPi(pi, reqs);
            }
            case 13 -> {
                IntegerDivRemNode divRem = (IntegerDivRemNode)valueNode2;
                yield this.lowerDivRem(divRem);
            }
            case 14 -> {
                FixedValueAnchorNode fixedValueAnchor = (FixedValueAnchorNode)valueNode2;
                yield this.lowerExpression(fixedValueAnchor.object());
            }
            case 15 -> {
                PublishWritesNode publishWrites = (PublishWritesNode)valueNode2;
                yield this.lowerExpression(publishWrites.getOriginalNode());
            }
            case 16 -> {
                LoadFieldNode loadField = (LoadFieldNode)valueNode2;
                yield this.lowerLoadField(loadField);
            }
            case 17 -> {
                StoreFieldNode storeField = (StoreFieldNode)valueNode2;
                yield this.lowerStoreField(storeField);
            }
            case 18 -> {
                ArrayLengthNode arrayLength = (ArrayLengthNode)valueNode2;
                yield this.lowerArrayLength(arrayLength);
            }
            case 19 -> {
                AccessIndexedNode accessIndexed = (AccessIndexedNode)valueNode2;
                yield this.lowerAccessIndexed(accessIndexed);
            }
            case 20 -> {
                InvokeNode invoke = (InvokeNode)valueNode2;
                yield this.lowerInvoke(invoke);
            }
            case 21 -> {
                InvokeWithExceptionNode invoke = (InvokeWithExceptionNode)valueNode2;
                yield this.lowerInvoke(invoke);
            }
            case 22 -> {
                ForeignCall foreignCall = (ForeignCall)valueNode2;
                yield this.lowerForeignCall(foreignCall);
            }
            case 23 -> {
                NewInstanceNode newInstance = (NewInstanceNode)valueNode2;
                yield this.lowerNewInstance(newInstance);
            }
            case 24 -> {
                DynamicNewInstanceNode dynamicNewInstance = (DynamicNewInstanceNode)valueNode2;
                yield this.lowerDynamicNewInstance(dynamicNewInstance);
            }
            case 25 -> {
                NewArrayNode newArray = (NewArrayNode)valueNode2;
                yield this.lowerNewArray(newArray);
            }
            case 26 -> {
                DynamicNewArrayNode newArray = (DynamicNewArrayNode)valueNode2;
                yield this.lowerDynamicNewArray(newArray);
            }
            case 27 -> {
                NewMultiArrayNode newMultiArray = (NewMultiArrayNode)valueNode2;
                yield this.lowerMultiNewArray(newMultiArray);
            }
            case 28 -> {
                ReadIdentityHashCodeNode readIdentityHashCode = (ReadIdentityHashCodeNode)valueNode2;
                yield this.lowerReadIdentityHashCode(readIdentityHashCode);
            }
            case 29 -> {
                WriteIdentityHashCodeNode writeIdentityHashCode = (WriteIdentityHashCodeNode)valueNode2;
                yield this.lowerWriteIdentityHashCode(writeIdentityHashCode);
            }
            case 30 -> {
                LoadArrayComponentHubNode loadArrayComponentHub = (LoadArrayComponentHubNode)valueNode2;
                yield this.lowerLoadArrayComponentHub(loadArrayComponentHub);
            }
            case 31 -> {
                LoadHubNode loadHub = (LoadHubNode)valueNode2;
                yield this.lowerLoadHub(loadHub);
            }
            case 32 -> {
                JSCallNode jsCall = (JSCallNode)valueNode2;
                yield this.lowerJSCall(jsCall);
            }
            case 33 -> {
                JSBodyNode jsBody = (JSBodyNode)valueNode2;
                yield this.lowerJSBody(jsBody);
            }
            case 34 -> {
                JSBodyWithExceptionNode jsBody = (JSBodyWithExceptionNode)valueNode2;
                yield this.lowerJSBody(jsBody);
            }
            case 35 -> {
                WordCastNode wordCast = (WordCastNode)valueNode2;
                yield this.lowerWordCast(wordCast);
            }
            case 36 -> {
                FloatingWordCastNode wordCast = (FloatingWordCastNode)valueNode2;
                yield this.lowerFloatingWordCast(wordCast);
            }
            default -> {
                if (!$assertionsDisabled && this.isForbiddenNode((Node)n)) {
                    throw new AssertionError((Object)this.reportForbiddenNode((Node)n));
                }
                if (((Boolean)WebImageOptions.DebugOptions.VerificationPhases.getValue()).booleanValue()) {
                    throw GraalError.shouldNotReachHere((String)("Tried to lower unknown node: " + String.valueOf(n)));
                }
                yield this.getStub((Node)n);
            }
        };
    }

    private Instruction optionalDowncast(Instruction original, ValueNode node, ResolvedJavaType fromType) {
        return this.optionalDowncast(original, node, fromType, node.stamp(NodeView.DEFAULT));
    }

    private Instruction optionalDowncast(Instruction original, ValueNode node, Stamp fromStamp, ResolvedJavaType toType) {
        return this.optionalDowncast(original, node, fromStamp.javaType(this.masm.getProviders().getMetaAccess()), toType);
    }

    private Instruction optionalDowncast(Instruction original, ValueNode node, ResolvedJavaType fromType, Stamp toStamp) {
        return this.optionalDowncast(original, node, fromType, toStamp.javaType(this.masm.getProviders().getMetaAccess()));
    }

    private Instruction optionalDowncast(Instruction original, ValueNode node, ResolvedJavaType fromType, ResolvedJavaType toType) {
        ResolvedJavaType wasmFromType = this.util.canonicalizeJavaType(fromType);
        ResolvedJavaType wasmToType = this.util.canonicalizeJavaType(toType);
        if (wasmFromType.getJavaKind() != JavaKind.Object || wasmToType.getJavaKind() != JavaKind.Object) {
            return original;
        }
        boolean toIsSubtype = wasmFromType.isAssignableFrom(wasmToType);
        assert (toIsSubtype || wasmToType.isAssignableFrom(wasmFromType)) : String.valueOf(wasmToType) + " is not compatible with " + String.valueOf(wasmFromType) + ", at " + String.valueOf(node);
        if (toIsSubtype && !wasmFromType.equals((Object)wasmToType)) {
            original.setComment(this.masm.getNodeComment((Node)node));
            Instruction.RefCast cast = new Instruction.RefCast(original, (WasmRefType)this.util.typeForJavaType((JavaType)wasmToType));
            cast.setComment("Explicit downcast due to type mismatch, expected " + wasmToType.getName() + ", got " + wasmFromType.getName());
            return cast;
        }
        return original;
    }

    private Instruction lowerNewInstance(NewInstanceNode newInstance) {
        return new Instruction.Call(this.masm().getKnownIds().instanceCreateTemplate.requestFunctionId(OriginalClassProvider.getJavaClass((JavaType)newInstance.instanceClass())), new Instruction[0]);
    }

    private Instruction lowerDynamicNewInstance(DynamicNewInstanceNode newInstance) {
        return this.masm().getWasmProviders().builder().createUninitialized(this.lowerExpression(newInstance.getInstanceType()));
    }

    private Instruction allocateArray(AbstractNewArrayNode newArray, JavaKind elementKind, Instruction hub) {
        Instruction length = this.lowerExpression(newArray.length());
        Instruction.ArrayNew innerArray = new Instruction.ArrayNew(this.masm().getKnownIds().innerArrayTypes.get(elementKind), length);
        return this.allocateArrayWithInnerArray(elementKind, hub, innerArray);
    }

    private Instruction allocateArrayWithInnerArray(JavaKind elementKind, Instruction hub, Instruction innerArray) {
        return new Instruction.StructNew(this.masm().getKnownIds().arrayStructTypes.get(elementKind), hub, Instruction.Const.forInt(0), innerArray);
    }

    private Instruction lowerNewArray(NewArrayNode newArray) {
        JavaKind elementKind = newArray.elementType().getJavaKind();
        JavaConstant hubConstant = this.masm.getProviders().getConstantReflection().asJavaClass(newArray.elementType().getArrayClass());
        assert (!hubConstant.isNull()) : hubConstant;
        return this.allocateArray((AbstractNewArrayNode)newArray, elementKind, this.lowerConstant((Constant)hubConstant));
    }

    private Instruction lowerDynamicNewArray(DynamicNewArrayNode newArray) {
        assert (newArray.getKnownElementKind() == JavaKind.Object) : newArray.getKnownElementKind();
        WasmId.StructType hubTypeId = this.masm().getWasmProviders().util().getHubObjectId();
        ResolvedJavaField hubCompanionField = this.masm.getProviders().getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(DynamicHub.class, (String)"companion"));
        WebImageWasmGCIds.JavaField companionFieldId = this.masm.idFactory.newJavaField(hubCompanionField);
        WebImageWasmGCIds.JavaStruct companionTypeId = this.masm.idFactory.newJavaStruct(this.masm.getWasmProviders().getMetaAccess().lookupJavaType(DynamicHubCompanion.class));
        ResolvedJavaField companionArrayHubField = this.masm.getProviders().getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(DynamicHubCompanion.class, (String)"arrayHub"));
        WebImageWasmGCIds.JavaField arrayHubFieldId = this.masm.idFactory.newJavaField(companionArrayHubField);
        Instruction.StructGet companion = new Instruction.StructGet(hubTypeId, companionFieldId, WasmUtil.Extension.None, this.lowerExpression(newArray.getElementType()));
        Instruction.StructGet arrayHub = new Instruction.StructGet(companionTypeId, arrayHubFieldId, WasmUtil.Extension.None, companion);
        return this.allocateArray((AbstractNewArrayNode)newArray, JavaKind.Object, arrayHub);
    }

    private Instruction lowerMultiNewArray(NewMultiArrayNode newMultiArray) {
        MetaAccessProvider metaAccess = this.masm.getProviders().getMetaAccess();
        Instruction[] dimensions = new Instruction[newMultiArray.dimensionCount()];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = this.lowerExpression(newMultiArray.dimension(i));
        }
        Instruction.ArrayNewFixed innerArray = new Instruction.ArrayNewFixed(this.masm().getKnownIds().innerArrayTypes.get(JavaKind.Int), dimensions);
        JavaConstant dimsArrayHubConstant = this.masm.getProviders().getConstantReflection().asJavaClass(metaAccess.lookupJavaType(int[].class));
        Instruction dimensionsArrayStruct = this.allocateArrayWithInnerArray(JavaKind.Int, this.lowerConstant((Constant)dimsArrayHubConstant), innerArray);
        JavaConstant hubConstant = this.masm.getProviders().getConstantReflection().asJavaClass(newMultiArray.type());
        Instruction multiArray = this.lowerSubstrateForeignCall(WasmGCAllocationSupport.NEW_MULTI_ARRAY, this.lowerConstant((Constant)hubConstant), dimensionsArrayStruct);
        return this.optionalDowncast(multiArray, (ValueNode)newMultiArray, metaAccess.lookupJavaType(Object.class));
    }

    private Instruction lowerReadIdentityHashCode(ReadIdentityHashCodeNode readIdentityHashCode) {
        return new Instruction.StructGet(this.gcUtil.getJavaLangObjectId(), this.masm().getKnownIds().identityHashCodeField, WasmUtil.Extension.None, this.lowerExpression(readIdentityHashCode.getObject()));
    }

    private Instruction lowerWriteIdentityHashCode(WriteIdentityHashCodeNode writeIdentityHashCode) {
        return new Instruction.StructSet(this.gcUtil.getJavaLangObjectId(), this.masm().getKnownIds().identityHashCodeField, this.lowerExpression(writeIdentityHashCode.getObject()), this.lowerExpression(writeIdentityHashCode.getHashCode()));
    }

    private Instruction lowerLoadHub(LoadHubNode loadHub) {
        return this.masm().getWasmProviders().builder().getHub(this.lowerExpression(loadHub.getValue()));
    }

    private Instruction lowerLoadArrayComponentHub(LoadArrayComponentHubNode loadArrayComponentHub) {
        ResolvedJavaField componentTypeField = this.masm.getProviders().getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(DynamicHub.class, (String)"componentType"));
        WasmId.StructType hubTypeId = this.masm().getWasmProviders().util().getHubObjectId();
        WebImageWasmGCIds.JavaField componentTypeFieldId = this.masm.idFactory.newJavaField(componentTypeField);
        return new Instruction.StructGet(hubTypeId, componentTypeFieldId, WasmUtil.Extension.None, this.lowerExpression(loadArrayComponentHub.getValue()));
    }

    private Instruction lowerFixedAccess(FixedAccessNode n) {
        if (!n.getAddress().getBase().stamp(NodeView.DEFAULT).isObjectStamp()) {
            this.logError("Detected off-heap memory access. This is currently not supported");
            return super.getStub((Node)n);
        }
        AddressNode addressNode = n.getAddress();
        if (!(addressNode instanceof OffsetAddressNode)) {
            throw GraalError.shouldNotReachHere((String)("Unexpected address node in " + String.valueOf(n) + " : " + String.valueOf(n.getAddress())));
        }
        OffsetAddressNode address = (OffsetAddressNode)addressNode;
        if (n instanceof ReadNode || n instanceof WriteNode) {
            Instruction.Call dispatch;
            WebImageWasmGCProviders providers = this.masm().getWasmProviders();
            JavaKind accessKind = providers.util().memoryKind(((LIRLowerableAccess)n).getAccessStamp(NodeView.DEFAULT));
            ResolvedJavaType returnedType = providers.getMetaAccess().lookupJavaType(accessKind == JavaKind.Object ? Object.class : accessKind.toJavaClass());
            WasmGCUnsafeTemplates.DispatchAccess dispatchAccessTemplate = providers.knownIds().dispatchAccessTemplate;
            Instruction base = this.lowerExpression(address.getBase());
            Instruction offset = this.lowerExpression(address.getOffset());
            if (n instanceof WriteNode) {
                WriteNode write = (WriteNode)n;
                dispatch = new Instruction.Call(dispatchAccessTemplate.requestWriteFunctionId(accessKind), base, offset, this.lowerExpression(write.value()));
            } else {
                dispatch = new Instruction.Call(dispatchAccessTemplate.requestReadFunctionId(accessKind), base, offset);
            }
            return this.optionalDowncast(dispatch, (ValueNode)n, returnedType);
        }
        throw GraalError.shouldNotReachHere((String)n.toString());
    }

    @Override
    protected Instruction lowerParam(ParameterNode param) {
        Instruction paramGet = super.lowerParam(param);
        ResolvedJavaType fromType = this.masm.compilationResult.getParamTypes()[param.index()];
        return this.optionalDowncast(paramGet, (ValueNode)param, fromType);
    }

    private WebImageWasmGCIds.StaticField getStaticFieldId(ResolvedJavaField field) {
        assert (field.isStatic());
        return this.masm.idFactory.forStaticField(this.masm.wasmProviders.util().typeForJavaType(field.getType()), field);
    }

    private Instruction fieldAccessObject(AccessFieldNode node) {
        return this.optionalDowncast(this.lowerExpression(node.object()), (ValueNode)node, node.object().stamp(NodeView.DEFAULT), node.field().getDeclaringClass());
    }

    private Instruction lowerLoadField(LoadFieldNode node) {
        ResolvedJavaField field = node.field();
        Instruction getter = field.isStatic() ? this.getStaticFieldId(field).getter() : new Instruction.StructGet(this.masm.idFactory.newJavaStruct(field.getDeclaringClass()), this.masm.idFactory.newJavaField(field), WasmUtil.Extension.forKind(field.getJavaKind()), this.fieldAccessObject((AccessFieldNode)node));
        return this.optionalDowncast(getter, (ValueNode)node, (ResolvedJavaType)field.getType());
    }

    private Instruction lowerStoreField(StoreFieldNode node) {
        ResolvedJavaField field = node.field();
        if (field.isStatic()) {
            return this.getStaticFieldId(field).setter(this.lowerExpression(node.value()));
        }
        return new Instruction.StructSet(this.masm.idFactory.newJavaStruct(field.getDeclaringClass()), this.masm.idFactory.newJavaField(field), this.fieldAccessObject((AccessFieldNode)node), this.lowerExpression(node.value()));
    }

    private Instruction lowerArrayLength(ArrayLengthNode node) {
        ValueNode arrayNode = node.array();
        Instruction array = this.lowerExpression(arrayNode);
        Stamp arrayNodeStamp = arrayNode.stamp(NodeView.DEFAULT);
        if (!arrayNodeStamp.javaType(this.masm().getProviders().getMetaAccess()).isArray()) {
            array = new Instruction.RefCast(array, this.masm().getKnownIds().baseArrayType.asNonNull());
        }
        return this.builder.getArrayLength(array);
    }

    private Instruction lowerAccessIndexed(AccessIndexedNode node) {
        JavaKind componentKind = node.elementKind();
        ValueNode array = node.array();
        Instruction arrayStruct = this.lowerExpression(array);
        Instruction index = this.lowerExpression(node.index());
        if (node instanceof LoadIndexedNode) {
            AbstractObjectStamp objectStamp;
            ResolvedJavaType componentType;
            WasmRefType componentWasmType;
            LoadIndexedNode loadIndexed = (LoadIndexedNode)node;
            Instruction getter = this.builder.getArrayElement(arrayStruct, index, componentKind);
            Stamp stamp = loadIndexed.stamp(NodeView.DEFAULT);
            if (stamp instanceof AbstractObjectStamp && !this.gcUtil.isJavaLangObject(componentWasmType = (WasmRefType)this.util.typeForJavaType((JavaType)(componentType = (objectStamp = (AbstractObjectStamp)stamp).javaType(this.masm.getProviders().getMetaAccess()))))) {
                getter = new Instruction.RefCast(getter, componentWasmType);
            }
            return getter;
        }
        if (node instanceof StoreIndexedNode) {
            StoreIndexedNode storeIndexed = (StoreIndexedNode)node;
            return this.builder.setArrayElement(arrayStruct, index, this.lowerExpression(storeIndexed.value()), componentKind);
        }
        throw GraalError.shouldNotReachHere((String)node.toString());
    }

    @Override
    protected Instruction lowerLogicNode(LogicNode n, WasmIRWalker.Requirements reqs) {
        if (n instanceof ObjectIsArrayNode) {
            ObjectIsArrayNode objectIsArray = (ObjectIsArrayNode)n;
            return this.lowerObjectIsArray(objectIsArray);
        }
        if (n instanceof InstanceOfNode) {
            InstanceOfNode instanceOf = (InstanceOfNode)n;
            return this.lowerInstanceOf(instanceOf);
        }
        if (n instanceof InstanceOfDynamicNode) {
            InstanceOfDynamicNode instanceOfDynamic = (InstanceOfDynamicNode)n;
            return this.lowerInstanceOfDynamic(instanceOfDynamic);
        }
        if (n instanceof ClassIsAssignableFromNode) {
            ClassIsAssignableFromNode classIsAssignableFrom = (ClassIsAssignableFromNode)n;
            return this.lowerClassIsAssignableFrom(classIsAssignableFrom);
        }
        return super.lowerLogicNode(n, reqs);
    }

    protected Instruction lowerInstanceOfDynamic(InstanceOfDynamicNode node) {
        boolean allowsNull = node.allowsNull();
        if (node.isExact()) {
            SnippetRuntime.SubstrateForeignCallDescriptor descriptor = allowsNull ? WasmGCTypeCheckSupport.IS_EXACT_OR_NULL : WasmGCTypeCheckSupport.IS_EXACT_NON_NULL;
            return this.lowerSubstrateForeignCall(descriptor, this.lowerExpression(node.getObject()), this.lowerExpression(node.getMirrorOrHub()));
        }
        SnippetRuntime.SubstrateForeignCallDescriptor descriptor = WasmGCTypeCheckSupport.INSTANCEOF_DYNAMIC;
        return this.lowerSubstrateForeignCall(descriptor, this.lowerExpression(node.getMirrorOrHub()), this.lowerExpression(node.getObject()), Instruction.Const.forBoolean(allowsNull));
    }

    protected Instruction lowerClassIsAssignableFrom(ClassIsAssignableFromNode node) {
        SnippetRuntime.SubstrateForeignCallDescriptor descriptor = WasmGCTypeCheckSupport.CLASS_IS_ASSIGNABLE_FROM;
        return this.lowerSubstrateForeignCall(descriptor, this.lowerExpression(node.getThisClass()), this.lowerExpression(node.getOtherClass()));
    }

    protected Instruction lowerObjectIsArray(ObjectIsArrayNode node) {
        return this.masm().getWasmProviders().builder.isArrayStruct(this.lowerExpression(node.getValue()), null);
    }

    protected Instruction lowerInstanceOf(InstanceOfNode node) {
        TypeReference typeReference = node.type();
        HostedType checkType = (HostedType)node.type().getType();
        assert (!checkType.isPrimitive()) : "instanceof primitive";
        DynamicHub hub = checkType.getHub();
        boolean allowsNull = node.allowsNull();
        Instruction object = this.lowerExpression(node.getValue());
        if (typeReference.isExact()) {
            SnippetRuntime.SubstrateForeignCallDescriptor descriptor = allowsNull ? WasmGCTypeCheckSupport.IS_EXACT_OR_NULL : WasmGCTypeCheckSupport.IS_EXACT_NON_NULL;
            return this.lowerSubstrateForeignCall(descriptor, object, this.lowerConstant((Constant)this.masm().getProviders().getConstantReflection().asJavaClass((ResolvedJavaType)checkType)));
        }
        if (checkType.isInstanceClass()) {
            return WebImageWasmGCNodeLowerer.lowerRefTestCheck(this.masm.idFactory.newJavaStruct((ResolvedJavaType)checkType), allowsNull, object);
        }
        HostedType componentType = checkType.getComponentType();
        if (checkType.isArray() && (componentType.isPrimitive() || componentType.isJavaLangObject())) {
            return WebImageWasmGCNodeLowerer.lowerRefTestCheck(this.masm().getKnownIds().arrayStructTypes.get(componentType.getJavaKind()), allowsNull, object);
        }
        return this.lowerSubstrateForeignCall(WasmGCTypeCheckSupport.INSTANCEOF, object, Instruction.Const.forBoolean(allowsNull), Instruction.Const.forInt(hub.getTypeCheckStart()), Instruction.Const.forInt(hub.getTypeCheckRange()), Instruction.Const.forInt(hub.getTypeCheckSlot()));
    }

    private static Instruction lowerRefTestCheck(WasmId.Type testWasmId, boolean allowsNull, Instruction objectToCheck) {
        WasmRefType testWasmType = allowsNull ? testWasmId.asNullable() : testWasmId.asNonNull();
        return new Instruction.RefTest(objectToCheck, testWasmType);
    }

    @Override
    protected Instruction lowerIsNull(IsNullNode n) {
        return Instruction.Unary.Op.RefIsNull.create(this.lowerExpression(n.getValue()));
    }

    protected Instruction lowerBox(BoxNode node, WasmIRWalker.Requirements reqs) {
        CoreProviders providers = this.masm.getProviders();
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        JavaKind boxedKind = node.getBoxingKind();
        ResolvedJavaType boxing = metaAccess.lookupJavaType(boxedKind.toBoxedJavaClass());
        WebImageWasmGCIds.JavaStruct boxedStruct = this.masm().idFactory.newJavaStruct(boxing);
        if (boxedKind == JavaKind.Boolean) {
            Instruction.Relocation trueValue = this.masm().getConstantRelocation(providers.getSnippetReflection().forObject((Object)Boolean.TRUE));
            Instruction.Relocation falseValue = this.masm().getConstantRelocation(providers.getSnippetReflection().forObject((Object)Boolean.FALSE));
            return new Instruction.Select(trueValue, falseValue, this.lowerExpression(node.getValue(), reqs.setStrictLogic(false)), boxedStruct.asNullable());
        }
        return new Instruction.Call(this.masm().getKnownIds().allocatingBoxTemplate.requestFunctionId(boxedKind), this.lowerExpression(node.getValue(), reqs));
    }

    protected Instruction lowerUnbox(UnboxNode node) {
        MetaAccessProvider metaAccess = this.codeGenTool.getProviders().getMetaAccess();
        JavaKind boxedKind = node.getBoxingKind();
        ResolvedJavaType boxing = metaAccess.lookupJavaType(boxedKind.toBoxedJavaClass());
        ResolvedJavaField valueField = AbstractBoxingNode.getValueField((ResolvedJavaType)boxing);
        WebImageWasmGCIds.JavaStruct boxedStruct = this.masm().idFactory.newJavaStruct(boxing);
        return new Instruction.StructGet(boxedStruct, this.masm().idFactory.newJavaField(valueField), WasmUtil.Extension.forKind(boxedKind), this.lowerExpression(node.getValue()));
    }

    protected Instruction lowerPi(PiNode n, WasmIRWalker.Requirements reqs) {
        Stamp oldStamp = n.getOriginalNode().stamp(NodeView.DEFAULT);
        Stamp newStamp = n.stamp(NodeView.DEFAULT);
        Instruction inner = this.lowerExpression(n.getOriginalNode(), reqs);
        if (newStamp instanceof PrimitiveStamp) {
            return inner;
        }
        if (newStamp.isObjectStamp() && oldStamp.isObjectStamp()) {
            boolean changedToSubtype;
            ResolvedJavaType oldType = this.util.canonicalizeJavaType(oldStamp.javaType(this.masm.wasmProviders.getMetaAccess()));
            ResolvedJavaType newType = this.util.canonicalizeJavaType(newStamp.javaType(this.masm.wasmProviders.getMetaAccess()));
            boolean bl = changedToSubtype = !newType.equals((Object)oldType) && oldType.isAssignableFrom(newType);
            if (changedToSubtype) {
                return new Instruction.RefCast(inner, (WasmRefType)this.util.typeForNode((ValueNode)n));
            }
            return inner;
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)newStamp);
    }

    protected <T extends FixedNode> Instruction lowerInvoke(T node) {
        Instruction.AbstractCall call;
        HostedMethod singleTarget;
        CallTargetNode callTarget = ((Invoke)node).callTarget();
        Instructions params = new Instructions();
        callTarget.arguments().forEach(param -> params.add(this.lowerExpression((ValueNode)param)));
        HostedMethod targetMethod = (HostedMethod)callTarget.targetMethod();
        if (targetMethod == null) {
            IndirectCallTargetNode indirectCallTarget = (IndirectCallTargetNode)callTarget;
            assert (!indirectCallTarget.invokeKind().hasReceiver()) : "Calls to an address cannot have receivers: " + String.valueOf(indirectCallTarget);
            MetaAccessProvider metaAccess = this.masm().getProviders().getMetaAccess();
            ResolvedJavaType returnType = indirectCallTarget.returnStamp().getTrustedStamp().javaType(metaAccess);
            TypeUse typeUse = WebImageWasmBackend.signatureToTypeUse(this.masm().wasmProviders, indirectCallTarget.signature(), (JavaType)returnType);
            WasmId.FuncType targetFuncType = this.masm().getWasmProviders().util().functionIdForMethod(typeUse);
            Instruction.Unary index = Instruction.Unary.Op.I32Wrap64.create(this.lowerExpression(indirectCallTarget.computedAddress()));
            return this.masm().getCall(null, false, new Instruction.CallIndirect(this.masm().getKnownIds().functionTable, (Instruction)index, targetFuncType, typeUse, params));
        }
        CallTargetNode.InvokeKind invokeKind = callTarget.invokeKind();
        HostedMethod[] implementations = targetMethod.getImplementations();
        HostedMethod hostedMethod = singleTarget = implementations.length == 1 ? implementations[0] : targetMethod;
        if (invokeKind.isDirect() || implementations.length == 1) {
            WebImageWasmIds.MethodName targetMethodId = this.masm.idFactory.forMethod((ResolvedJavaMethod)singleTarget);
            call = this.masm.getCall((InvokeTarget)singleTarget, true, new Instruction.Call((WasmId.Func)targetMethodId, params));
        } else {
            call = this.masm.getCall((InvokeTarget)singleTarget, false, new Instruction.Call(this.masm().getKnownIds().indirectCallBridgeTemplate.requestFunctionId(singleTarget), params));
        }
        ResolvedJavaType returnType = WebImageWasmBackend.constructReturnType((ResolvedJavaMethod)singleTarget);
        return this.optionalDowncast(call, (ValueNode)node, returnType);
    }

    protected void logError(String msg) {
        Instruction.Relocation string = this.masm().getConstantRelocation(this.codeGenTool.getProviders().getConstantReflection().forString(msg.intern()));
        this.masm.genInst(this.lowerSubstrateForeignCall(WasmDebug.LOG_ERROR, string), msg);
    }

    @Override
    protected Instruction getStub(Node n) {
        if (WebImageWasmOptions.fatalUnsupportedNodes()) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Node of type ").append(n.getClass()).append(" is not supported: ");
            NodeSourcePosition nsp = n.getNodeSourcePosition();
            if (nsp == null) {
                errorMessage.append(((StructuredGraph)n.graph()).method().format("%H.%n(%P)"));
            } else {
                errorMessage.append(System.lineSeparator());
                errorMessage.append(nsp);
            }
            this.logError(errorMessage.toString());
        }
        return super.getStub(n);
    }

    @Override
    protected Instruction getValueStub(ValueNode node) {
        JavaKind wasmKind = this.util.kindForNode(node);
        if (wasmKind != JavaKind.Object) {
            return super.getValueStub(node);
        }
        WasmRefType.TypeIndex type = (WasmRefType.TypeIndex)this.util.typeForNode(node);
        if (type.nullable) {
            return new Instruction.RefNull(type);
        }
        AbstractObjectStamp stamp = (AbstractObjectStamp)node.stamp(NodeView.DEFAULT);
        ResolvedJavaType javaType = stamp.javaType(this.masm.wasmProviders.getMetaAccess());
        if (javaType.isArray()) {
            return new Instruction.StructNew((WasmId.StructType)type.id, Instruction.Const.forInt(0), new Instruction.ArrayNew(this.masm().getKnownIds().innerArrayTypes.get(javaType.getComponentType().getJavaKind()), Instruction.Const.forInt(0)));
        }
        return new Instruction.StructNew((WasmId.StructType)type.id);
    }

    @Override
    protected Instruction lowerConstant(ConstantNode n) {
        if (n.isNullConstant()) {
            return new Instruction.RefNull((WasmRefType.TypeIndex)this.util.typeForNode((ValueNode)n));
        }
        return super.lowerConstant(n);
    }

    private Instruction callToExtern(Instruction wasmExtern) {
        return new Instruction.Call(this.masm().getKnownIds().toExternTemplate.requestFunctionId(), wasmExtern);
    }

    private Instruction callWrapExtern(Instruction externref) {
        return new Instruction.Call(this.masm().getKnownIds().wrapExternTemplate.requestFunctionId(), externref);
    }

    @Override
    protected Instruction lowerWasmImportForeignCall(WasmImportForeignCallDescriptor descriptor, Instructions args) {
        Class[] argTypes = descriptor.getArgumentTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (argTypes[i] != WasmExtern.class) continue;
            args.get().set(i, this.callToExtern(args.get().get(i)));
        }
        WasmId.FunctionImport target = this.masm.idFactory.forFunctionImport(descriptor.getImportDescriptor(this.masm.wasmProviders));
        Instruction result = new Instruction.Call((WasmId.Func)target, args);
        if (descriptor.getResultType() == WasmExtern.class) {
            result = new Instruction.RefCast(this.callWrapExtern(result), (WasmRefType)this.masm().getWasmProviders().util().typeForJavaClass((Class)WasmExtern.class));
        }
        return result;
    }

    @Override
    protected Instruction lowerWasmForeignCall(WasmForeignCallDescriptor descriptor, Instructions args) {
        if (WasmGCArrayCopySupport.COPY_FOREIGN_CALLS.containsKey((Object)descriptor)) {
            JavaKind componentKind = WasmGCArrayCopySupport.COPY_FOREIGN_CALLS.get((Object)descriptor);
            return new Instruction.Call(this.masm().getKnownIds().arrayCopyTemplate.requestFunctionId(componentKind), args);
        }
        if (descriptor == WasmGCTypeCheckSupport.SLOT_TYPE_CHECK) {
            return this.lowerSlotTypeCheck(args);
        }
        if (descriptor == WasmGCCloneSupport.CLONE_TEMPLATE) {
            return new Instruction.Call(this.masm().getKnownIds().genericCloneTemplate.requestFunctionId(), args);
        }
        if (descriptor == WasmGCJSConversion.EXTRACT_JS_NATIVE) {
            return new Instruction.Call(this.masm().getKnownIds().extractJSValueTemplate.requestGetterFunctionId(), args);
        }
        if (descriptor == WasmGCJSConversion.SET_JS_NATIVE) {
            return new Instruction.Call(this.masm().getKnownIds().extractJSValueTemplate.requestSetterFunctionId(), args);
        }
        return super.lowerWasmForeignCall(descriptor, args);
    }

    @Override
    protected Instruction lowerForeignCall(ForeignCall n) {
        ResolvedJavaType returnedType = this.masm().wasmProviders.getMetaAccess().lookupJavaType(n.getDescriptor().getResultType());
        return this.optionalDowncast(super.lowerForeignCall(n), n.asNode(), returnedType);
    }

    protected Instruction lowerSlotTypeCheck(Instructions args) {
        List<Instruction> instrs = args.get();
        assert (instrs.size() == 4) : "Unexpected number of arguments for slot type check: " + String.valueOf(instrs);
        WebImageWasmGCIds.JavaStruct hubType = this.masm().idFactory.newJavaStruct(this.masm().getProviders().getMetaAccess().lookupJavaType(DynamicHub.class));
        WasmId.Field typeCheckSlotsField = this.masm().getKnownIds().typeCheckSlotsField;
        WasmId.ArrayType typeCheckSlotsFieldType = this.masm().getKnownIds().typeCheckSlotsFieldType;
        Instruction start = instrs.get(0);
        Instruction range = instrs.get(1);
        Instruction slot = instrs.get(2);
        Instruction checkedHub = instrs.get(3);
        Instruction.StructGet typeCheckSlots = new Instruction.StructGet(hubType, typeCheckSlotsField, WasmUtil.Extension.None, checkedHub);
        Instruction.ArrayGet checkedTypeId = new Instruction.ArrayGet(typeCheckSlotsFieldType, WasmUtil.Extension.forKind(JavaKind.Short), typeCheckSlots, slot);
        return Instruction.Binary.Op.I32LtU.create(Instruction.Binary.Op.I32Sub.create(checkedTypeId, start), range);
    }

    private Instruction lowerJSCall(JSCallNode n) {
        JSSystemFunction func = n.getFunctionDefinition();
        Instructions params = new Instructions();
        for (ValueNode param : n.getArguments()) {
            Instruction paramInstruction = this.lowerExpression(param);
            if (param.stamp(NodeView.DEFAULT).isObjectStamp()) {
                paramInstruction = this.lowerSubstrateForeignCall(WasmGCConversion.PROXY_OBJECT, Instructions.asInstructions(paramInstruction));
                paramInstruction = new Instruction.Call(this.masm().getWasmProviders().knownIds().toExternTemplate.requestFunctionId(), paramInstruction);
            }
            params.add(paramInstruction);
        }
        Instruction callResult = new Instruction.Call(this.masm.wasmProviders.getJSCounterparts().idForJSFunction(this.masm.wasmProviders, func), params);
        if (func.stamp().isObjectStamp()) {
            callResult = this.callWrapExtern(callResult);
        }
        return callResult;
    }

    private <T extends FixedNode> Instruction lowerJSBody(T jsBody) {
        WebImageWasmGCProviders wasmProviders = this.masm().getWasmProviders();
        Instructions params = new Instructions();
        for (ValueNode param : ((JSBody)jsBody).getArguments()) {
            Instruction paramInstruction = this.lowerExpression(param);
            if (param.stamp(NodeView.DEFAULT).isObjectStamp()) {
                paramInstruction = new Instruction.Call(wasmProviders.knownIds().toExternTemplate.requestFunctionId(), paramInstruction);
            }
            params.add(paramInstruction);
        }
        Instruction.Call returnValue = new Instruction.Call(wasmProviders.getJSCounterparts().idForJSBody(wasmProviders, (JSBody)jsBody), params);
        if (jsBody.stamp(NodeView.DEFAULT).isObjectStamp()) {
            returnValue = new Instruction.Call(wasmProviders.knownIds().wrapExternTemplate.requestFunctionId(), returnValue);
        }
        return returnValue;
    }

    @Override
    protected Instruction lowerWordCast(WordCastNode n) {
        this.logError("This method should never be reached and cannot be supported.");
        return super.getStub((Node)n);
    }

    static {
        IGNORED_NODE_TYPES.add(OffsetAddressNode.class);
    }
}

