/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.LowerableResource;
import com.oracle.svm.hosted.webimage.codegen.LowerableResources;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmElementCreator;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmRelocationVisitor;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmLMLowerableResources;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCodeGen;
import com.oracle.svm.hosted.webimage.wasmgc.WasmFunctionIdConstant;
import com.oracle.svm.hosted.webimage.wasmgc.WebImageWasmGCCodeCache;
import com.oracle.svm.hosted.webimage.wasmgc.ast.visitors.WasmGCElementCreator;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCHeapWriter;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCLowerableResources;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.image.WasmGCImageHeapLayoutInfo;
import com.oracle.svm.webimage.JSKeyword;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.hightiercodegen.Keyword;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.VMConstant;

public class WebImageWasmGCCodeGen
extends WebImageWasmCodeGen {
    public WebImageWasmGCCodeGen(WebImageCodeCache codeCache, List<HostedMethod> hostedEntryPoints, HostedMethod mainEntryPoint, WebImageProviders providers, DebugContext debug, WebImageHostedConfiguration config) {
        super(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, config);
    }

    @Override
    protected WebImageWasmGCProviders getProviders() {
        return (WebImageWasmGCProviders)super.getProviders();
    }

    @Override
    protected void writeImageHeap() {
        WasmGCHeapWriter heapWriter = new WasmGCHeapWriter(this.codeCache, this.getProviders());
        WasmGCImageHeapLayoutInfo layout = heapWriter.layout();
        this.setLayout(layout);
        this.afterHeapLayout();
        heapWriter.write(layout, this.module);
        this.processRelocations(heapWriter);
    }

    @Override
    protected void genWasmModule() {
        String exportedName;
        HostedMethod m;
        super.genWasmModule();
        for (Map.Entry<HostedMethod, String> entry : ((WebImageWasmGCCodeCache)this.codeCache).getExportedMethodMetadata().entrySet()) {
            m = entry.getKey();
            exportedName = entry.getValue();
            this.module.addFunctionExport(this.getProviders().idFactory().forMethod((ResolvedJavaMethod)m), exportedName, m.format("Metadata for %h.%n(%p)%r"));
        }
        for (Map.Entry<HostedMethod, String> entry : ((WebImageWasmGCCodeCache)this.codeCache).getExportedSingleAbstractMethods().entrySet()) {
            m = entry.getKey();
            exportedName = entry.getValue();
            this.module.addFunctionExport(this.getProviders().idFactory().forMethod((ResolvedJavaMethod)m), exportedName, "Single abstract method for " + m.getDeclaringClass().getName());
        }
    }

    private void processRelocations(final WasmGCHeapWriter heapWriter) {
        new WasmRelocationVisitor(this){
            final /* synthetic */ WebImageWasmGCCodeGen this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitUnprocessedRelocation(Instruction.Relocation relocation) {
                Reference targetRef = relocation.target;
                if (targetRef instanceof ConstantReference) {
                    VMConstant constant;
                    ConstantReference constantReference = (ConstantReference)targetRef;
                    VMConstant vMConstant = constant = constantReference.getConstant();
                    Objects.requireNonNull(vMConstant);
                    VMConstant vMConstant2 = vMConstant;
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageHeapConstant.class, SubstrateMethodPointerConstant.class, WasmFunctionIdConstant.class}, (Object)vMConstant2, n)) {
                        case 0: {
                            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)vMConstant2;
                            WasmGCHeapWriter.ObjectData data = heapWriter.getConstantInfo((JavaConstant)imageHeapConstant);
                            assert (data.isEmbedded()) : "Found relocation that referenced an object that was not seen before " + String.valueOf(relocation) + ", " + String.valueOf(imageHeapConstant);
                            relocation.setValue(data.getGlobalVariable().getter());
                            break;
                        }
                        case 1: {
                            SubstrateMethodPointerConstant methodPointerConstant = (SubstrateMethodPointerConstant)vMConstant2;
                            MethodPointer methodPointer = methodPointerConstant.pointer();
                            int funtableIndex = this.this$0.getFunctionTableIndex(methodPointer);
                            relocation.setValue(Instruction.Const.forLong(funtableIndex));
                            relocation.setComment(methodPointer.getMethod().format("Method pointer for: %H.%n(%P)"));
                            break;
                        }
                        case 2: {
                            WasmFunctionIdConstant functionIdConstant = (WasmFunctionIdConstant)vMConstant2;
                            WasmId.Func function = functionIdConstant.function();
                            int funtableIndex = this.this$0.getFunctionTableIndex(function);
                            relocation.setValue(Instruction.Const.forInt(funtableIndex));
                            relocation.setComment("Function id for: " + String.valueOf(function));
                            break;
                        }
                        default: {
                            throw GraalError.unimplemented((String)("Unsupported constant relocation: " + String.valueOf(constant)));
                        }
                    }
                } else {
                    throw GraalError.unimplemented((String)("Unsupported relocation reference: " + String.valueOf(targetRef)));
                }
                GraalError.guarantee((boolean)relocation.wasProcessed(), (String)"Relocation %s was not processed, target: %s", (Object)relocation, (Object)targetRef);
            }
        }.visitModule(this.module);
    }

    @Override
    protected WasmElementCreator getElementsCreator() {
        return new WasmGCElementCreator(this.getProviders());
    }

    @Override
    protected void validateModule() {
    }

    @Override
    protected void emitBootstrapDefinitions() {
        super.emitBootstrapDefinitions();
        this.emitJSBodyImports();
    }

    protected void emitJSBodyImports() {
        TreeMap<String, IEmitter> jsBodyDefinitions = new TreeMap<String, IEmitter>();
        for (Map.Entry<JSBody.JSCode, WasmId.FunctionImport> entry : this.getProviders().getJSCounterparts().getJsBodyFunctions().entrySet()) {
            JSBody.JSCode jsCode = entry.getKey();
            WasmId.FunctionImport functionImport = entry.getValue();
            jsBodyDefinitions.put(functionImport.getDescriptor().name, t -> {
                CodeBuffer masm = t.getCodeBuffer();
                masm.emitText("(...args) => ");
                masm.emitKeyword((Keyword)JSKeyword.LPAR);
                masm.emitKeyword((Keyword)JSKeyword.FUNCTION);
                masm.emitKeyword((Keyword)JSKeyword.LPAR);
                this.codeGenTool.genCommaList(Arrays.stream(jsCode.getArgs()).map(Emitter::of).collect(Collectors.toList()));
                masm.emitKeyword((Keyword)JSKeyword.RPAR);
                masm.emitScopeBegin();
                masm.emitTry();
                for (String line : jsCode.getBody().split("\n")) {
                    masm.emitText(line);
                    masm.emitNewLine();
                }
                masm.emitCatch("e");
                masm.emitText("conversion.handleJSError(e);");
                masm.emitScopeEnd();
                masm.emitScopeEnd();
                masm.emitKeyword((Keyword)JSKeyword.RPAR);
                masm.emitText(".call(...args)");
            });
        }
        this.codeGenTool.genResolvedVarAssignmentPrefix("wasmImports.jsbody");
        this.codeGenTool.genObject(jsBodyDefinitions);
        this.codeGenTool.getCodeBuffer().emitInsEnd();
        LowerableResources.lower(this.codeGenTool, LowerableResources.JSCONVERSION_COMMON);
        LowerableResources.lower(this.codeGenTool, WasmGCLowerableResources.JSCONVERSIONS);
    }

    @Override
    protected List<LowerableResource> getWasmBootstrapResources() {
        return List.of(WasmLMLowerableResources.BOOTSTRAP, WasmGCLowerableResources.CONVERSION, WasmGCLowerableResources.IMPORTS, WasmGCLowerableResources.RUNNER, LowerableResources.STACK_TRACE, LowerableResources.CWD);
    }
}

