/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCUnalignedUnsafeSupport;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCUnsafeSupport;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.GCKnownIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCCodeGenTool;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmGCUtil;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WasmGCUnsafeTemplates {
    private static Instruction checkForFatalError(WasmCodeGenTool codeGenTool, boolean isRead, Instruction condition, Instruction receiver, String errorMessage, Instruction offset) {
        if (WasmGCUnsafeSupport.includeErrorMessage()) {
            Instruction.If check = new Instruction.If(null, condition);
            check.thenInstructions.add(WasmGCUnsafeTemplates.fatalError(codeGenTool, isRead, receiver, errorMessage, offset));
            return check;
        }
        return new Instruction.Nop();
    }

    private static Instruction fatalError(WasmCodeGenTool codeGenTool, boolean isRead, Instruction receiver, String errorMessage, Instruction offset) {
        if (WasmGCUnsafeSupport.includeErrorMessage()) {
            ResolvedJavaMethod method = WasmGCUnsafeSupport.FATAL_ACCESS_ERROR.findMethod(codeGenTool.getProviders().getMetaAccess());
            Instruction.Relocation string = codeGenTool.getConstantRelocation(codeGenTool.getProviders().getConstantReflection().forString(errorMessage.intern()));
            return new Instruction.Call((WasmId.Func)codeGenTool.idFactory.forMethod(method), receiver, string, offset, Instruction.Const.forBoolean(isRead));
        }
        return new Instruction.Unreachable();
    }

    private static String getReadWriteString(boolean isRead) {
        return isRead ? "read" : "write";
    }

    public static class ArrayAccess
    extends WasmFunctionTemplate<DispatchAccessParam> {
        public ArrayAccess(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected boolean isValidParameter(DispatchAccessParam param) {
            return param.isValid();
        }

        public WasmId.Func requestReadFunctionId(JavaKind accessKind) {
            return this.requestFunctionId(new DispatchAccessParam(accessKind, true));
        }

        public WasmId.Func requestWriteFunctionId(JavaKind accessKind) {
            return this.requestFunctionId(new DispatchAccessParam(accessKind, false));
        }

        @Override
        protected String getFunctionName(DispatchAccessParam param) {
            return "unsafe." + WasmGCUnsafeTemplates.getReadWriteString(param.isRead()) + ".array." + String.valueOf(param.accessKind());
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            DispatchAccessParam param = (DispatchAccessParam)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            MetaAccessProvider metaAccess = providers.getMetaAccess();
            WasmGCCodeGenTool codeGenTool = (WasmGCCodeGenTool)ctxt.getCodeGenTool();
            boolean isRead = param.isRead();
            JavaKind componentKind = param.accessKind();
            ResolvedJavaType receiverType = metaAccess.lookupJavaType((Class)(componentKind == JavaKind.Object ? Object.class : componentKind.toJavaClass()).arrayType());
            int baseOffset = metaAccess.getArrayBaseOffset(componentKind);
            int indexScale = metaAccess.getArrayIndexScale(componentKind);
            assert (CodeUtil.isPowerOf2((int)indexScale));
            int indexScaleBits = CodeUtil.log2((int)indexScale);
            long indexScaleMask = CodeUtil.mask((int)indexScaleBits);
            TypeUse typeUse = isRead ? TypeUse.withResult(util.mapType(componentKind), util.typeForJavaType((JavaType)receiverType), WasmPrimitiveType.i64) : TypeUse.withoutResult(util.typeForJavaType((JavaType)receiverType), WasmPrimitiveType.i64, util.mapType(componentKind));
            Function f = ctxt.createFunction(typeUse, (Object)("Unsafe array " + WasmGCUnsafeTemplates.getReadWriteString(isRead) + " of type " + String.valueOf(componentKind)));
            WasmId.Local objectParam = f.getParam(0);
            WasmId.Local offsetParam = f.getParam(1);
            WasmId.Local valueParam = isRead ? null : f.getParam(2);
            WebImageWasmIds.TempLocal scaledIndex = this.idFactory.newTemporaryVariable(WasmPrimitiveType.i64);
            Instructions instructions = f.getInstructions();
            instructions.add(scaledIndex.setter(Instruction.Binary.Op.I64Sub.create(offsetParam.getter(), Instruction.Const.forLong(baseOffset))));
            Instruction.Binary offsetAlignmentCheck = Instruction.Binary.Op.I64Ne.create(Instruction.Binary.Op.I64And.create(scaledIndex.getter(), Instruction.Const.forLong(indexScaleMask)), Instruction.Const.forLong(0L));
            if (componentKind.isPrimitive()) {
                Instruction.If offsetCheckIf = new Instruction.If(null, offsetAlignmentCheck);
                instructions.add(offsetCheckIf);
                DispatchAccess.generateUnalignedArrayAccess(codeGenTool, isRead, componentKind, objectParam.getter(), offsetParam.getter(), isRead ? null : valueParam.getter(), offsetCheckIf.thenInstructions::add);
            } else {
                instructions.add(WasmGCUnsafeTemplates.checkForFatalError(codeGenTool, isRead, offsetAlignmentCheck, objectParam.getter(), "Between array elements", offsetParam.getter()));
            }
            Instruction.Unary index = Instruction.Unary.Op.I32Wrap64.create(Instruction.Binary.Op.I64ShrU.create(scaledIndex.getter(), Instruction.Const.forLong(indexScaleBits)));
            if (isRead) {
                instructions.add(providers.builder.getArrayElement(objectParam.getter(), index, componentKind));
            } else {
                instructions.add(providers.builder.setArrayElement(objectParam.getter(), index, valueParam.getter(), componentKind));
            }
            return f;
        }
    }

    public static class GetDispatchIndex
    extends WasmFunctionTemplate<Boolean> {
        public GetDispatchIndex(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected boolean isValidParameter(Boolean isRead) {
            return isRead != null;
        }

        @Override
        protected String getFunctionName(Boolean isRead) {
            return "unsafe.dispatch." + WasmGCUnsafeTemplates.getReadWriteString(isRead) + ".getindex";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            GCKnownIds knownIds = providers.knownIds();
            WasmId.StructType baseObjectId = util.getJavaLangObjectId();
            WasmId.StructType hubObjectId = util.getHubObjectId();
            boolean isRead = (Boolean)ctxt.getParameter();
            Function f = ctxt.createFunction(TypeUse.withResult(WasmPrimitiveType.i32, baseObjectId.asNullable(), WasmPrimitiveType.i64), (Object)("Get function table index for the " + WasmGCUnsafeTemplates.getReadWriteString(isRead) + " function of the given object at the given offset"));
            WasmId.Local objectParam = f.getParam(0);
            WasmId.Local offsetParam = f.getParam(1);
            Instructions instructions = f.getInstructions();
            Instruction.Binary arrayIndexInstr = Instruction.Binary.Op.I32Mul.create(Instruction.Unary.Op.I32Wrap64.create(offsetParam.getter()), Instruction.Const.forInt(2));
            if (!isRead) {
                arrayIndexInstr = Instruction.Binary.Op.I32Add.create(arrayIndexInstr, Instruction.Const.forInt(1));
            }
            WebImageWasmIds.TempLocal arrayIndex = this.idFactory.newTemporaryVariable(WasmPrimitiveType.i32);
            instructions.add(arrayIndex.setter(arrayIndexInstr));
            WebImageWasmIds.TempLocal array = this.idFactory.newTemporaryVariable(knownIds.accessDispatchFieldType.asNullable());
            instructions.add(array.setter(new Instruction.StructGet(hubObjectId, knownIds.accessDispatchField, WasmUtil.Extension.None, providers.builder().getHub(objectParam.getter()))));
            instructions.add(WasmGCUnsafeTemplates.checkForFatalError(ctxt.getCodeGenTool(), isRead, Instruction.Unary.Op.RefIsNull.create(array.getter()), objectParam.getter(), "No unsafe accessible fields available", offsetParam.getter()));
            instructions.add(WasmGCUnsafeTemplates.checkForFatalError(ctxt.getCodeGenTool(), isRead, Instruction.Binary.Op.I32Or.create(Instruction.Binary.Op.I32LtS.create(arrayIndex.getter(), Instruction.Const.forInt(0)), Instruction.Binary.Op.I32GeS.create(arrayIndex.getter(), new Instruction.ArrayLen(array.getter()))), objectParam.getter(), "Outside of object boundary", offsetParam.getter()));
            instructions.add(new Instruction.ArrayGet(knownIds.accessDispatchFieldType, WasmUtil.Extension.None, array.getter(), arrayIndex.getter()));
            return f;
        }
    }

    public static class DispatchAccess
    extends WasmFunctionTemplate<DispatchAccessParam> {
        public DispatchAccess(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected boolean isValidParameter(DispatchAccessParam param) {
            return param.isValid();
        }

        public WasmId.Func requestReadFunctionId(JavaKind accessKind) {
            return this.requestFunctionId(new DispatchAccessParam(accessKind, true));
        }

        public WasmId.Func requestWriteFunctionId(JavaKind accessKind) {
            return this.requestFunctionId(new DispatchAccessParam(accessKind, false));
        }

        @Override
        protected String getFunctionName(DispatchAccessParam param) {
            return "unsafe.dispatch." + WasmGCUnsafeTemplates.getReadWriteString(param.isRead()) + "." + String.valueOf(param.accessKind);
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            JavaKind[] componentKindsToCheck;
            JavaKind[] javaKindArray;
            DispatchAccessParam param = (DispatchAccessParam)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            WasmGCCodeGenTool codeGenTool = (WasmGCCodeGenTool)ctxt.getCodeGenTool();
            boolean isRead = param.isRead();
            JavaKind accessKind = param.accessKind;
            WasmValType accessType = util.mapType(accessKind);
            TypeUse typeUse = isRead ? TypeUse.withResult(accessType, util.getJavaLangObjectType(), WasmPrimitiveType.i64) : TypeUse.withoutResult(util.getJavaLangObjectType(), WasmPrimitiveType.i64, accessType);
            Function f = ctxt.createFunction(typeUse, (Object)("Unsafe " + WasmGCUnsafeTemplates.getReadWriteString(isRead) + " for type " + String.valueOf(accessKind)));
            WasmId.Local objectParam = f.getParam(0);
            WasmId.Local offsetParam = f.getParam(1);
            WasmId.Local valueParam = isRead ? null : f.getParam(2);
            Instructions instructions = f.getInstructions();
            instructions.add(WasmGCUnsafeTemplates.checkForFatalError(codeGenTool, isRead, Instruction.Unary.Op.RefIsNull.create(objectParam.getter()), objectParam.getter(), "Access on null object", offsetParam.getter()));
            Instruction.If arrayCheck = new Instruction.If(null, providers.builder.isArrayStruct(objectParam.getter(), null));
            instructions.add(arrayCheck);
            switch (accessKind) {
                case Boolean: 
                case Byte: {
                    JavaKind[] javaKindArray2 = new JavaKind[2];
                    javaKindArray2[0] = JavaKind.Boolean;
                    javaKindArray = javaKindArray2;
                    javaKindArray2[1] = JavaKind.Byte;
                    break;
                }
                case Short: 
                case Char: {
                    JavaKind[] javaKindArray3 = new JavaKind[2];
                    javaKindArray3[0] = JavaKind.Short;
                    javaKindArray = javaKindArray3;
                    javaKindArray3[1] = JavaKind.Char;
                    break;
                }
                default: {
                    JavaKind[] javaKindArray4 = new JavaKind[1];
                    javaKindArray = javaKindArray4;
                    javaKindArray4[0] = accessKind;
                }
            }
            for (JavaKind componentKind : componentKindsToCheck = javaKindArray) {
                arrayCheck.thenInstructions.add(DispatchAccess.getArrayDispatch(providers, isRead, objectParam, offsetParam, valueParam, componentKind));
            }
            if (accessKind.isPrimitive()) {
                DispatchAccess.generateUnalignedArrayAccess(codeGenTool, isRead, accessKind, objectParam.getter(), offsetParam.getter(), isRead ? null : valueParam.getter(), arrayCheck.thenInstructions::add);
            } else {
                arrayCheck.thenInstructions.add(WasmGCUnsafeTemplates.fatalError(codeGenTool, isRead, objectParam.getter(), "Array type mismatch. Attempt to access array element of type " + Arrays.stream(componentKindsToCheck).map(JavaKind::toString).collect(Collectors.joining(" or ")), offsetParam.getter()));
            }
            if (isRead && providers.getWordTypes().getWordKind() == accessKind) {
                instructions.add(DispatchAccess.getHubVtableDispatch(providers, objectParam, offsetParam));
            }
            WebImageWasmIds.TempLocal functionIdx = this.idFactory.newTemporaryVariable(WasmPrimitiveType.i32);
            instructions.add(functionIdx.setter(new Instruction.Call(providers.knownIds().getDispatchIndexTemplate.requestFunctionId(isRead), objectParam.getter(), offsetParam.getter())));
            instructions.add(WasmGCUnsafeTemplates.checkForFatalError(codeGenTool, isRead, Instruction.Unary.Op.I32Eqz.create(functionIdx.getter()), objectParam.getter(), "No accessor for field type " + String.valueOf(accessKind) + " exists", offsetParam.getter()));
            TypeUse accessorTypeUse = isRead ? TypeUse.withResult(accessType, util.getJavaLangObjectType()) : TypeUse.withoutResult(util.getJavaLangObjectType(), accessType);
            WebImageWasmIds.DescriptorFuncType accessorFuncType = this.idFactory.newFuncType(FunctionTypeDescriptor.createSimple(accessorTypeUse));
            Instructions args = new Instructions();
            args.add(objectParam.getter());
            if (!isRead) {
                args.add(valueParam.getter());
            }
            WebImageWasmIds.TempLocal funcref = this.idFactory.newTemporaryVariable(WasmRefType.FUNCREF);
            instructions.add(funcref.setter(new Instruction.TableGet(providers.knownIds().functionTable, functionIdx.getter())));
            instructions.add(WasmGCUnsafeTemplates.checkForFatalError(codeGenTool, isRead, Instruction.Unary.Op.I32Eqz.create(new Instruction.RefTest(funcref.getter(), accessorFuncType.asNonNull())), objectParam.getter(), "Field type mismatch, expected " + String.valueOf(accessKind), offsetParam.getter()));
            instructions.add(new Instruction.CallRef(accessorFuncType, (Instruction)new Instruction.RefCast(funcref.getter(), accessorFuncType.asNonNull()), args));
            return f;
        }

        private static Instruction getArrayDispatch(WebImageWasmGCProviders providers, boolean isRead, WasmId.Local objectParam, WasmId.Local offsetParam, WasmId.Local valueParam, JavaKind componentKind) {
            Instruction.If arrayCheck = new Instruction.If(null, providers.builder.isArrayStruct(objectParam.getter(), componentKind));
            Instructions instructions = arrayCheck.thenInstructions;
            Instruction.RefCast castArray = new Instruction.RefCast(objectParam.getter(), providers.knownIds().getArrayStructType(componentKind).asNonNull());
            if (isRead) {
                instructions.add(new Instruction.Return(new Instruction.Call(providers.knownIds().arrayAccessTemplate.requestReadFunctionId(componentKind), castArray, offsetParam.getter())));
            } else {
                instructions.add(new Instruction.Call(providers.knownIds().arrayAccessTemplate.requestWriteFunctionId(componentKind), castArray, offsetParam.getter(), valueParam.getter()));
                instructions.add(new Instruction.Return());
            }
            return arrayCheck;
        }

        private static void generateUnalignedArrayAccess(WasmGCCodeGenTool codeGenTool, boolean isRead, JavaKind accessKind, Instruction object, Instruction offset, Instruction value, Consumer<Instruction> gen) {
            assert (accessKind.isPrimitive()) : "Only primitive arrays can have unaligned accesses, got " + String.valueOf(accessKind);
            WebImageWasmGCProviders providers = codeGenTool.getWasmProviders();
            SnippetRuntime.SubstrateForeignCallDescriptor descriptor = (isRead ? WasmGCUnalignedUnsafeSupport.READ_ARRAY_FOREIGN_CALLS : WasmGCUnalignedUnsafeSupport.WRITE_ARRAY_FOREIGN_CALLS).get(accessKind);
            ResolvedJavaMethod method = descriptor.findMethod(providers.getMetaAccess());
            WebImageWasmIds.MethodName methodId = providers.idFactory().forMethod(method);
            if (isRead) {
                gen.accept(new Instruction.Return(codeGenTool.getCall((InvokeTarget)method, true, new Instruction.Call((WasmId.Func)methodId, object, offset))));
            } else {
                gen.accept(codeGenTool.getCall((InvokeTarget)method, true, new Instruction.Call((WasmId.Func)methodId, object, offset, value)));
                gen.accept(new Instruction.Return());
            }
        }

        private static Instruction getHubVtableDispatch(WebImageWasmGCProviders providers, WasmId.Local objectParam, WasmId.Local offsetParam) {
            GCKnownIds knownIds = providers.knownIds();
            WasmGCUtil util = providers.util();
            KnownOffsets knownOffsets = KnownOffsets.singleton();
            WasmRefType hubObjectType = util.getHubObjectType();
            Instruction.Binary condition = Instruction.Binary.Op.I32And.create(new Instruction.RefTest(objectParam.getter(), hubObjectType), Instruction.Binary.Op.I64GeS.create(offsetParam.getter(), Instruction.Const.forLong(knownOffsets.getVTableBaseOffset())));
            Instruction.If hubCheck = new Instruction.If(null, condition);
            Instruction.StructGet vtable = new Instruction.StructGet(util.getHubObjectId(), knownIds.vtableField, WasmUtil.Extension.None, new Instruction.RefCast(objectParam.getter(), hubObjectType));
            Instruction.Binary vtableIndex = Instruction.Binary.Op.I32DivS.create(Instruction.Binary.Op.I32Sub.create(Instruction.Unary.Op.I32Wrap64.create(offsetParam.getter()), Instruction.Const.forInt(knownOffsets.getVTableBaseOffset())), Instruction.Const.forInt(knownOffsets.getVTableEntrySize()));
            hubCheck.thenInstructions.add(new Instruction.Return(new Instruction.ArrayGet(knownIds.vtableFieldType, WasmUtil.Extension.None, vtable, vtableIndex)));
            return hubCheck;
        }
    }

    protected record DispatchAccessParam(JavaKind accessKind, boolean isRead) {
        boolean isValid() {
            return this.accessKind.getSlotCount() > 0;
        }
    }

    public static class FieldAccess
    extends WasmFunctionTemplate<Param> {
        public FieldAccess(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        public WasmId.Func requestReadFunctionId(HostedField field) {
            return this.requestFunctionId(new Param(field, true));
        }

        public WasmId.Func requestWriteFunctionId(HostedField field) {
            return this.requestFunctionId(new Param(field, false));
        }

        @Override
        protected boolean isValidParameter(Param param) {
            return param.isValid();
        }

        @Override
        protected String getFunctionName(Param param) {
            return "unsafe." + WasmGCUnsafeTemplates.getReadWriteString(param.isRead()) + ".field." + WebImageNamingConvention.getInstance().identForType((ResolvedJavaType)param.field().getDeclaringClass()) + "." + param.field().getName();
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            Param param = (Param)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            boolean isRead = param.isRead();
            HostedField field = param.field();
            ResolvedJavaType fieldType = util.canonicalizeJavaType((ResolvedJavaType)field.getType());
            JavaKind accessKind = util.memoryKind(fieldType.getJavaKind());
            WasmValType accessType = util.mapType(accessKind);
            TypeUse typeUse = isRead ? TypeUse.withResult(accessType, util.getJavaLangObjectType()) : TypeUse.withoutResult(util.getJavaLangObjectType(), accessType);
            Function f = ctxt.createFunction(typeUse, (Object)("Unsafe field " + WasmGCUnsafeTemplates.getReadWriteString(isRead) + " for field " + field.format("%H.%n of type %T")));
            WasmId.Local valueParam = isRead ? null : f.getParam(1);
            Instructions instructions = f.getInstructions();
            if (field.isStatic()) {
                WasmValType fieldWasmType = util.typeForJavaType((JavaType)fieldType);
                WebImageWasmGCIds.StaticField staticField = this.idFactory.forStaticField(fieldWasmType, (ResolvedJavaField)field);
                if (isRead) {
                    instructions.add(staticField.getter());
                } else {
                    instructions.add(staticField.setter(FieldAccess.downcastFieldValue(util, fieldType, valueParam.getter())));
                }
            } else {
                ResolvedJavaType receiverType = util.canonicalizeJavaType((ResolvedJavaType)field.getDeclaringClass());
                WebImageWasmGCIds.JavaStruct receiverStruct = this.idFactory.newJavaStruct(receiverType);
                WebImageWasmGCIds.JavaField javaField = this.idFactory.newJavaField((ResolvedJavaField)field);
                WasmId.Local objectParam = f.getParam(0);
                Instruction.RefCast downCastReceiver = new Instruction.RefCast(objectParam.getter(), (WasmRefType)util.typeForJavaType((JavaType)receiverType));
                if (isRead) {
                    instructions.add(new Instruction.StructGet(receiverStruct, javaField, WasmUtil.Extension.forKind(fieldType.getJavaKind()), downCastReceiver));
                } else {
                    Instruction value = FieldAccess.downcastFieldValue(util, fieldType, valueParam.getter());
                    instructions.add(new Instruction.StructSet(receiverStruct, javaField, downCastReceiver, value));
                }
            }
            return f;
        }

        private static Instruction downcastFieldValue(WasmUtil util, ResolvedJavaType fieldType, Instruction originalValue) {
            if (!fieldType.isPrimitive() && !fieldType.isJavaLangObject()) {
                return new Instruction.RefCast(originalValue, (WasmRefType)util.typeForJavaType((JavaType)fieldType));
            }
            return originalValue;
        }

        protected record Param(HostedField field, boolean isRead) {
            boolean isValid() {
                return this.field.hasLocation();
            }
        }
    }
}

