/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmGCUtil;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import com.oracle.svm.webimage.wasmgc.WasmExtern;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.webimage.api.JSValue;

public class WasmGCJSBodyTemplates {

    public static class IsJavaObject
    extends WasmFunctionTemplate.Singleton {
        public IsJavaObject(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName() {
            return "extern.isjavaobject";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            WasmRefType jlObjectRef = util.getJavaLangObjectType().asNonNull();
            Function f = ctxt.createFunction(TypeUse.withResult(WasmPrimitiveType.i32, WasmRefType.EXTERNREF), (Object)"Check if reference is a Java Object");
            Instructions instructions = f.getInstructions();
            WasmId.Local objectParam = f.getParam(0);
            instructions.add(new Instruction.RefTest(Instruction.AnyExternConversion.toAny(objectParam.getter()), jlObjectRef));
            return f;
        }
    }

    public static class ExtractJSValue
    extends WasmFunctionTemplate<Boolean> {
        public ExtractJSValue(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName(Boolean isGet) {
            return "jsnative." + (isGet != false ? "get" : "set");
        }

        public final WasmId.Func requestGetterFunctionId() {
            return this.requestFunctionId(true);
        }

        public final WasmId.Func requestSetterFunctionId() {
            return this.requestFunctionId(false);
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            ResolvedJavaType jsValueType = providers.getMetaAccess().lookupJavaType(JSValue.class);
            WebImageWasmGCIds.JavaStruct jsValueId = this.idFactory.newJavaStruct(jsValueType);
            WasmRefType jsValueRef = jsValueId.asNullable();
            WasmValType wasmExternRef = util.typeForJavaClass((Class)WasmExtern.class);
            boolean isGet = (Boolean)ctxt.getParameter();
            TypeUse typeUse = isGet ? TypeUse.forUnary(wasmExternRef, jsValueRef) : TypeUse.withoutResult(jsValueRef, wasmExternRef);
            Function f = ctxt.createFunction(typeUse, (Object)((isGet ? "Extract" : "Set") + "JavaScript Native Value"));
            Instructions instructions = f.getInstructions();
            WasmId.Local objectParam = f.getParam(0);
            if (isGet) {
                instructions.add(new Instruction.StructGet(jsValueId, providers.knownIds().jsNativeValueField, WasmUtil.Extension.None, objectParam.getter()));
            } else {
                WasmId.Local valueParam = f.getParam(1);
                instructions.add(new Instruction.StructSet(jsValueId, providers.knownIds().jsNativeValueField, new Instruction.RefCast(objectParam.getter(), jsValueRef), valueParam.getter()));
            }
            return f;
        }
    }
}

