/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.hub.Hybrid;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.PatchedWordConstant;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import com.oracle.svm.hosted.webimage.wasm.ast.ActiveElements;
import com.oracle.svm.hosted.webimage.wasm.ast.Data;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Global;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.StartFunction;
import com.oracle.svm.hosted.webimage.wasm.ast.Table;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.WasmModule;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasmgc.WasmFunctionIdConstant;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCAllocationSupport;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCUnsafeSupport;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.GCKnownIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCCloneSupport;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCFunctionTemplates;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCUnsafeTemplates;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.image.WasmGCImageHeapLayoutInfo;
import com.oracle.svm.hosted.webimage.wasmgc.image.WasmGCPartition;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmGCUtil;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.word.WordBase;

public class WasmGCHeapWriter {
    private final WebImageCodeCache codeCache;
    private final NativeImageHeap heap;
    private final WebImageWasmGCProviders providers;
    private final SequencedMap<NativeImageHeap.ObjectInfo, ObjectData> objectData = new LinkedHashMap<NativeImageHeap.ObjectInfo, ObjectData>();
    private final ActiveElements objectElements;
    private final WasmId.ArrayType indexArrayType;
    private final WasmId.Local indexArray;
    private final WasmId.ArrayType dispatchArrayType;
    private final WasmId.Local dispatchArray;

    public WasmGCHeapWriter(WebImageCodeCache codeCache, WebImageWasmGCProviders providers) {
        this.codeCache = codeCache;
        this.heap = codeCache.nativeImageHeap;
        this.providers = providers;
        this.objectElements = new ActiveElements(0, providers.util().getJavaLangObjectType());
        this.indexArrayType = providers.knownIds().innerArrayTypes.get(JavaKind.Int);
        this.indexArray = providers.idFactory().newTemporaryVariable(this.indexArrayType.asNonNull());
        this.dispatchArrayType = providers.knownIds().accessDispatchFieldType;
        this.dispatchArray = providers.idFactory().newTemporaryVariable(this.dispatchArrayType.asNonNull());
    }

    public WasmGCImageHeapLayoutInfo layout() {
        this.collectObjectData();
        return (WasmGCImageHeapLayoutInfo)this.heap.getLayouter().layout((ImageHeap)this.heap, 65536, ImageHeapLayouter.ImageHeapLayouterCallback.NONE);
    }

    public void write(WasmGCImageHeapLayoutInfo layout, WasmModule module) {
        byte[] dataSegment = this.writeDataSegment(layout);
        module.addData(new Data(this.providers.knownIds().dataSegmentId, dataSegment, "Image heap constants " + dataSegment.length + " bytes"));
        this.initializeObjects();
        Function initializeHeap = this.createInitializationFunction(module);
        module.addFunction(initializeHeap);
        module.setStartFunction(new StartFunction(initializeHeap.getId(), "Initialize Image Heap"));
        for (ObjectData data : this.objectData.values()) {
            if (!data.isEmbedded()) continue;
            WasmId.Global global = data.getGlobalVariable();
            module.addGlobal(new Global(global, true, new Instruction.RefNull((WasmRefType)global.getVariableType()), data));
        }
        module.addTable(new Table(this.providers.knownIds().imageHeapObjectTable, this.objectElements, "Image heap table"));
    }

    private Function createInitializationFunction(WasmModule module) {
        WebImageWasmIds.InternalFunction initializeImageHeap = this.providers.idFactory().newInternalFunction("initializeImageHeap");
        Function initializeHeap = Function.createSimple(this.providers.idFactory(), initializeImageHeap, TypeUse.withoutResult(new WasmValType[0]), "Initialize Image Heap");
        Instructions instructions = initializeHeap.getInstructions();
        instructions.addAll(this.createImageHeapInstructions(module));
        instructions.addAll(this.registerAndFillStaticFields(module));
        instructions.addAll(this.patchStaticFieldBaseObjects());
        instructions.add(new Instruction.TableFill(this.providers.knownIds().imageHeapObjectTable, Instruction.Const.forInt(0), new Instruction.RefNull(this.providers.util().getJavaLangObjectType()), Instruction.Const.forInt(this.objectElements.size())));
        return initializeHeap;
    }

    public SequencedCollection<ObjectData> getObjects() {
        return this.objectData.sequencedValues();
    }

    public ObjectData getConstantInfo(JavaConstant constant) {
        return (ObjectData)this.objectData.get(this.heap.getConstantInfo(constant));
    }

    private void collectObjectData() {
        Set embeddedConstants = this.codeCache.getEmbeddedConstants().keySet();
        HashSet embeddedObjectInfos = HashSet.newHashSet(embeddedConstants.size());
        for (Constant constant : embeddedConstants) {
            if (!(constant instanceof JavaConstant)) continue;
            JavaConstant javaConstant = (JavaConstant)constant;
            embeddedObjectInfos.add(this.heap.getConstantInfo(javaConstant));
        }
        WasmIdFactory idFactory = this.providers.idFactory();
        WasmGCUtil util = this.providers.util();
        int num = 0;
        for (NativeImageHeap.ObjectInfo info : this.heap.getObjects()) {
            boolean isEmbedded = embeddedObjectInfos.contains(info);
            HostedClass hType = info.getClazz();
            WasmRefType type = ((WasmRefType)util.typeForJavaType((JavaType)hType)).asNullable();
            WasmId.Global globalVariable = null;
            if (isEmbedded) {
                globalVariable = idFactory.newGlobal(type, "const.heap" + num);
                ++num;
            }
            ObjectData data = new ObjectData(info, globalVariable);
            assert (!this.objectData.containsKey(info)) : "Duplicate ObjectInfo " + String.valueOf(info);
            this.objectData.put(info, data);
        }
    }

    private byte[] writeDataSegment(WasmGCImageHeapLayoutInfo layoutInfo) {
        ByteBuffer bb = ByteBuffer.allocate((int)layoutInfo.getSerializedSize()).order(ByteOrder.LITTLE_ENDIAN);
        for (ObjectData data : this.objectData.values()) {
            if (data.isPseudo()) continue;
            ImageHeapPrimitiveArray imageHeapArray = (ImageHeapPrimitiveArray)data.getInfo().getConstant();
            this.heap.hConstantReflection.forEachArrayElement((JavaConstant)imageHeapArray, (element, index) -> {
                int offset = (int)(data.info.getOffset() + (long)(index * data.info.getClazz().getComponentType().getStorageKind().getByteCount()));
                PrimitiveConstant primitive = (PrimitiveConstant)element;
                switch (primitive.getJavaKind()) {
                    case Boolean: {
                        bb.put(offset, (byte)(primitive.asBoolean() ? 1 : 0));
                        break;
                    }
                    case Byte: {
                        bb.put(offset, (byte)primitive.asInt());
                        break;
                    }
                    case Short: {
                        bb.putShort(offset, (short)primitive.asInt());
                        break;
                    }
                    case Char: {
                        bb.putChar(offset, (char)primitive.asInt());
                        break;
                    }
                    case Int: {
                        bb.putInt(offset, primitive.asInt());
                        break;
                    }
                    case Float: {
                        bb.putFloat(offset, primitive.asFloat());
                        break;
                    }
                    case Long: {
                        bb.putLong(offset, primitive.asLong());
                        break;
                    }
                    case Double: {
                        bb.putDouble(offset, primitive.asDouble());
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere((String)primitive.toString());
                    }
                }
            });
        }
        return bb.array();
    }

    private void initializeObjects() {
        int nullIndex = this.objectElements.addElement(new Instruction.RefNull(this.providers.util().getJavaLangObjectType()).setComment("Null Object"));
        assert (nullIndex == 0) : nullIndex + " image heap objects were added to image heap table before the null pointer";
        for (ObjectData data : this.getObjects()) {
            Instruction init = this.createInitInstruction(data);
            init.setComment(this.commentForObject(data));
            int objectIndex = this.objectElements.addElement(init);
            data.setIndex(objectIndex);
        }
    }

    private static boolean shouldGenerateStaticField(HostedField field) {
        return field.isStatic() && field.hasLocation() && field.isAccessed();
    }

    private List<Instruction> registerAndFillStaticFields(WasmModule module) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        for (HostedField field : this.heap.hUniverse.getFields()) {
            Instruction initialValue;
            if (!WasmGCHeapWriter.shouldGenerateStaticField(field)) continue;
            assert (field.isWritten() || !field.isValueAvailable() || MaterializedConstantFields.singleton().contains(field.wrapped));
            WasmValType fieldType = this.providers.util().typeForJavaType((JavaType)field.getType());
            WebImageWasmGCIds.StaticField staticFieldId = this.providers.idFactory().forStaticField(fieldType, (ResolvedJavaField)field);
            if (field.isRead()) {
                JavaConstant fieldValue = this.readFieldValue(null, field);
                if (fieldValue instanceof PrimitiveConstant) {
                    PrimitiveConstant primitiveConstant = (PrimitiveConstant)fieldValue;
                    initialValue = Instruction.Const.forConstant(primitiveConstant);
                } else {
                    WasmRefType fieldRefType = (WasmRefType)fieldType;
                    initialValue = new Instruction.RefNull(fieldRefType);
                    if (!fieldValue.isDefaultForKind()) {
                        Instruction tableIndex = this.getArgumentForValue(fieldValue);
                        instructions.add(staticFieldId.setter(WasmGCFunctionTemplates.FillHeapObject.getObject(this.providers.knownIds(), tableIndex, fieldRefType)));
                    }
                }
            } else {
                Instruction instruction;
                if (fieldType instanceof WasmRefType) {
                    WasmRefType fieldRefType = (WasmRefType)fieldType;
                    instruction = new Instruction.RefNull(fieldRefType);
                } else {
                    instruction = Instruction.Const.defaultForType(fieldType);
                }
                initialValue = instruction;
            }
            module.addGlobal(new Global(staticFieldId, true, initialValue, "Static Field " + field.format("%T %H.%n")));
        }
        return instructions;
    }

    private Instruction createInitInstruction(ObjectData data) {
        NativeImageHeap.ObjectInfo objectInfo = data.getInfo();
        HostedClass hType = objectInfo.getClazz();
        ImageHeapConstant constant = objectInfo.getConstant();
        if (constant instanceof ImageHeapInstance) {
            return new Instruction.StructNew(this.providers.idFactory().newJavaStruct((ResolvedJavaType)hType));
        }
        if (constant instanceof ImageHeapArray) {
            ImageHeapArray array = (ImageHeapArray)constant;
            JavaKind elementKind = hType.getComponentType().getJavaKind();
            int length = array.getLength();
            WasmId.ArrayType innerArrayType = this.providers.knownIds().innerArrayTypes.get(elementKind);
            Instruction.ArrayNew innerArray = new Instruction.ArrayNew(innerArrayType, Instruction.Const.forInt(length));
            WasmRefType hubRefType = this.providers.util().getHubObjectType();
            return new Instruction.StructNew(this.providers.knownIds().arrayStructTypes.get(elementKind), new Instruction.RefNull(hubRefType), Instruction.Const.forInt(data.getInfo().getIdentityHashCode()), innerArray);
        }
        throw VMError.shouldNotReachHere((String)constant.toString());
    }

    private List<Instruction> createImageHeapInstructions(WasmModule module) {
        int maxObjects = WebImageWasmOptions.getNumberOfImageHeapObjectsPerFunction();
        ArrayList<ObjectData> objects = new ArrayList<ObjectData>(this.getObjects());
        int numPartitions = NumUtil.divideAndRoundUp((int)objects.size(), (int)maxObjects);
        Instructions[] partitions = new Instructions[numPartitions];
        for (int i = 0; i < partitions.length; ++i) {
            partitions[i] = new Instructions();
        }
        ListIterator it = objects.listIterator();
        while (it.hasNext()) {
            int idx = it.nextIndex();
            ObjectData data = (ObjectData)it.next();
            int partitionNumber = idx / maxObjects;
            this.fillHeapObject(data, partitions[partitionNumber]::add);
        }
        if (partitions.length == 1) {
            return partitions[0].get();
        }
        ArrayList<Instruction> callInstructions = new ArrayList<Instruction>(numPartitions);
        for (int partitionNumber = 0; partitionNumber < partitions.length; ++partitionNumber) {
            WebImageWasmIds.InternalFunction partitionFunction = this.providers.idFactory().newInternalFunction("fillHeapObjects" + partitionNumber);
            Function initializeHeap = Function.createSimple(this.providers.idFactory(), partitionFunction, TypeUse.withoutResult(new WasmValType[0]), "Fill image heap objects part " + partitionNumber);
            initializeHeap.getInstructions().addAll(partitions[partitionNumber].get());
            module.addFunction(initializeHeap);
            callInstructions.add(new Instruction.Call((WasmId.Func)partitionFunction, new Instruction[0]));
        }
        return callInstructions;
    }

    private void fillHeapObject(ObjectData data, Consumer<Instruction> gen) {
        ImageHeapConstant constant = data.getInfo().getConstant();
        if (data.isEmbedded()) {
            Instruction targetObject = this.getterForObject(data);
            gen.accept(new Instruction.GlobalSet(data.getGlobalVariable(), targetObject));
        }
        if (constant instanceof ImageHeapInstance) {
            this.fillObject(data, gen);
        } else if (constant instanceof ImageHeapArray) {
            this.fillArray(data, gen);
        } else {
            throw VMError.shouldNotReachHere((String)constant.toString());
        }
    }

    private List<Instruction> patchStaticFieldBaseObjects() {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        WebImageWasmIds.TempLocal pseudoHub = this.providers.idFactory().newTemporaryVariable(this.providers.util().getHubObjectType());
        this.patchStaticFieldBaseObject(WasmGCUnsafeSupport.STATIC_OBJECT_FIELD_BASE, false, pseudoHub, instructions::add);
        this.patchStaticFieldBaseObject(WasmGCUnsafeSupport.STATIC_PRIMITIVE_FIELD_BASE, true, pseudoHub, instructions::add);
        return instructions;
    }

    private void patchStaticFieldBaseObject(Object base, boolean isPrimitive, WasmId.Local pseudoHubLocal, Consumer<Instruction> gen) {
        WasmGCUtil util = this.providers.util();
        GCKnownIds knownIds = this.providers.knownIds();
        JavaConstant constant = this.providers.getSnippetReflection().forObject(base);
        ObjectData data = this.getConstantInfo(constant);
        ArrayList<HostedField> staticFields = new ArrayList<HostedField>();
        for (HostedField f : ((HostedMetaAccess)this.providers.getMetaAccess()).getUniverse().getFields()) {
            if (!WasmGCHeapWriter.shouldGenerateStaticField(f) || f.getStorageKind().isPrimitive() != isPrimitive) continue;
            staticFields.add(f);
        }
        gen.accept(pseudoHubLocal.setter(new Instruction.StructNew(util.getHubObjectId())));
        gen.accept(new Instruction.StructSet(util.getHubObjectId(), knownIds.accessDispatchField, pseudoHubLocal.getter(), this.createAccessDispatchArray(staticFields, gen)));
        gen.accept(new Instruction.StructSet(util.getJavaLangObjectId(), knownIds.hubField, WasmGCFunctionTemplates.FillHeapObject.getObject(knownIds, Instruction.Const.forInt(data.index)), pseudoHubLocal.getter()));
    }

    private void fillObject(ObjectData data, Consumer<Instruction> gen) {
        assert (data.isPseudo()) : "Object instances cannot be serialized" + String.valueOf(data.getInfo());
        NativeImageHeap.ObjectInfo info = data.getInfo();
        HostedInstanceClass clazz = (HostedInstanceClass)info.getClazz();
        ImageHeapInstance instance = (ImageHeapInstance)info.getConstant();
        DynamicHubLayout dynamicHubLayout = this.heap.dynamicHubLayout;
        Instructions args = new Instructions();
        args.add(WasmGCHeapWriter.getObjectIndex(data));
        args.add(this.getHubIndex(data));
        args.add(Instruction.Const.forInt(data.getInfo().getIdentityHashCode()).setComment("Identity hash code"));
        if (dynamicHubLayout.isDynamicHub((HostedType)clazz)) {
            HostedType objectType = (HostedType)this.providers.getConstantReflection().asJavaType((Constant)instance);
            args.add(this.createHubAccessDispatchArray(objectType, gen));
            args.add(this.createHubVtableArray(instance));
            args.add(this.createHubTypeCheckSlots(instance));
            args.add(this.createNewInstanceFuncRef(objectType));
            args.add(this.createCloneFuncRef(objectType));
        } else if (HybridLayout.isHybrid((ResolvedJavaType)clazz)) {
            throw VMError.shouldNotReachHere((String)("Found unsupported @" + Hybrid.class.getSimpleName() + " image heap object of type: " + String.valueOf(clazz)));
        }
        clazz = WasmGCHeapWriter.getFirstClassWithFields((HostedClass)clazz);
        for (HostedField field : WasmGCHeapWriter.getInstanceFields((HostedClass)clazz)) {
            args.add(this.getArgumentForField(info, field));
        }
        gen.accept(new Instruction.Call(this.providers.knownIds().fillHeapObjectTemplate.requestFunctionId(clazz), args).setComment(this.commentForObject(data)));
    }

    private JavaConstant readFieldValue(NativeImageHeap.ObjectInfo info, HostedField field) {
        ImageHeapInstance instance = info == null ? null : (ImageHeapInstance)info.getConstant();
        try {
            return this.heap.hConstantReflection.readFieldValue((ResolvedJavaField)field, (JavaConstant)instance);
        }
        catch (AnalysisError.TypeNotFoundError ex) {
            throw NativeImageHeap.reportIllegalType((Object)ex.getType(), (Object)info);
        }
    }

    private Instruction getArgumentForField(NativeImageHeap.ObjectInfo info, HostedField field) {
        JavaConstant value = this.readFieldValue(info, field);
        return this.getArgumentForValue(value).setComment(field.format("%T %h.%n"));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Instruction getArgumentForValue(JavaConstant value) {
        void var2_9;
        if (value instanceof PatchedWordConstant) {
            PatchedWordConstant patchedConstant = (PatchedWordConstant)value;
            WordBase wordBase = patchedConstant.getWord();
            if (!(wordBase instanceof MethodPointer)) throw VMError.shouldNotReachHere((String)("Pointers to memory should not appear in the WasmGC image heap: " + String.valueOf(value)));
            MethodPointer methodPointer = (MethodPointer)wordBase;
            Instruction.Relocation relocation = Instruction.Relocation.forConstant((VMConstant)new SubstrateMethodPointerConstant(methodPointer));
            return var2_9;
        } else if (value.getJavaKind() == JavaKind.Object) {
            if (value.isNull()) {
                Instruction.Const const_ = Instruction.Const.forInt(0);
                return var2_9;
            } else {
                Instruction.Const const_ = Instruction.Const.forInt(this.getConstantInfo(value).getIndex());
            }
            return var2_9;
        } else {
            Instruction.Const const_ = Instruction.Const.forConstant((PrimitiveConstant)value);
        }
        return var2_9;
    }

    private Instruction createHubAccessDispatchArray(HostedType objectType, Consumer<Instruction> gen) {
        if (!objectType.getWrapped().isAnySubtypeInstantiated()) {
            return new Instruction.RefNull(this.dispatchArrayType);
        }
        List<HostedField> instanceFields = Arrays.stream(objectType.getInstanceFields(true)).filter(HostedField::hasLocation).toList();
        return this.createAccessDispatchArray(instanceFields, gen);
    }

    private Instruction createAccessDispatchArray(List<HostedField> allFields, Consumer<Instruction> gen) {
        List<HostedField> readFields = allFields.stream().filter(HostedField::isRead).toList();
        List<HostedField> writtenFields = allFields.stream().filter(HostedField::isWritten).toList();
        if (readFields.isEmpty() && writtenFields.isEmpty()) {
            return new Instruction.RefNull(this.dispatchArrayType);
        }
        int maxOffset = Stream.concat(readFields.stream(), writtenFields.stream()).mapToInt(ResolvedJavaField::getOffset).max().getAsInt();
        int arrayLength = 2 * (maxOffset + 1);
        gen.accept(this.dispatchArray.setter(new Instruction.ArrayNew(this.dispatchArrayType, Instruction.Const.forInt(arrayLength))));
        for (HostedField field : readFields) {
            gen.accept(this.setDispatchArrayElement(this.dispatchArray, field, true));
        }
        for (HostedField field : writtenFields) {
            gen.accept(this.setDispatchArrayElement(this.dispatchArray, field, false));
        }
        return this.dispatchArray.getter();
    }

    private Instruction createHubVtableArray(ImageHeapInstance instance) {
        WasmId.ArrayType vtableFieldType = this.providers.knownIds().vtableFieldType;
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        WordBase[] vtable = (WordBase[])this.heap.readInlinedField(dynamicHubLayout.vTableField, (JavaConstant)instance);
        int vtableLength = vtable.length;
        if (vtableLength == 0) {
            return new Instruction.RefNull(vtableFieldType);
        }
        Instruction[] vtableEntries = new Instruction[vtableLength];
        for (int i = 0; i < vtableLength; ++i) {
            MethodPointer vtableSlot = (MethodPointer)vtable[i];
            vtableEntries[i] = Instruction.Relocation.forConstant((VMConstant)new SubstrateMethodPointerConstant(vtableSlot));
        }
        return new Instruction.ArrayNewFixed(vtableFieldType, vtableEntries);
    }

    private Instruction createHubTypeCheckSlots(ImageHeapInstance instance) {
        WasmId.ArrayType typeCheckSlotsFieldType = this.providers.knownIds().typeCheckSlotsFieldType;
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        short[] typeIDSlots = (short[])this.heap.readInlinedField(dynamicHubLayout.closedTypeWorldTypeCheckSlotsField, (JavaConstant)instance);
        int typeIDSlotsLength = typeIDSlots.length;
        Instruction[] typeCheckSlotEntries = new Instruction[typeIDSlotsLength];
        for (int i = 0; i < typeIDSlotsLength; ++i) {
            typeCheckSlotEntries[i] = Instruction.Const.forInt(typeIDSlots[i]);
        }
        return new Instruction.ArrayNewFixed(typeCheckSlotsFieldType, typeCheckSlotEntries);
    }

    private Instruction createNewInstanceFuncRef(HostedType objectType) {
        if (WasmGCAllocationSupport.needsDynamicAllocationTemplate(objectType)) {
            return new Instruction.RefFunc(this.providers.knownIds().instanceCreateTemplate.requestFunctionId(objectType.getJavaClass()));
        }
        return new Instruction.RefNull(this.providers.knownIds().newInstanceFieldType);
    }

    private Instruction createCloneFuncRef(HostedType objectType) {
        if (WasmGCCloneSupport.needsCloneTemplate(objectType)) {
            if (objectType instanceof HostedInstanceClass) {
                HostedInstanceClass hostedInstanceClass = (HostedInstanceClass)objectType;
                return new Instruction.RefFunc(this.providers.knownIds().objectCloneTemplate.requestFunctionId(hostedInstanceClass));
            }
            if (objectType.isArray()) {
                JavaKind componentKind = objectType.getComponentType().getStorageKind();
                return new Instruction.RefFunc(this.providers.knownIds().arrayCloneTemplate.requestFunctionId(componentKind));
            }
        }
        return new Instruction.RefNull(this.providers.knownIds().cloneFieldType);
    }

    private Instruction setDispatchArrayElement(WasmId.Local dispatchArray, HostedField field, boolean isRead) {
        WasmGCUnsafeTemplates.FieldAccess fieldAccessTemplate = this.providers.knownIds().fieldAccessTemplate;
        Instruction.Const index = Instruction.Const.forInt(isRead ? 2 * field.getOffset() : 2 * field.getOffset() + 1);
        WasmId.Func accessorFunction = isRead ? fieldAccessTemplate.requestReadFunctionId(field) : fieldAccessTemplate.requestWriteFunctionId(field);
        return new Instruction.ArraySet(this.dispatchArrayType, dispatchArray.getter(), index, Instruction.Relocation.forConstant(new WasmFunctionIdConstant(accessorFunction)));
    }

    private void fillArray(ObjectData data, Consumer<Instruction> gen) {
        Instruction finalArg;
        NativeImageHeap.ObjectInfo info = data.getInfo();
        HostedArrayClass clazz = (HostedArrayClass)info.getClazz();
        ImageHeapArray array = (ImageHeapArray)info.getConstant();
        HostedType componentType = clazz.getComponentType();
        JavaKind componentKind = componentType.getJavaKind();
        int length = array.getLength();
        if (data.getPartition().isPseudo()) {
            Instruction[] instructions = new Instruction[length];
            this.heap.hConstantReflection.forEachArrayElement((JavaConstant)array, (element, index) -> {
                instructions[index] = element.isNull() ? Instruction.Const.forInt(0) : Instruction.Const.forInt(this.getConstantInfo((JavaConstant)element).getIndex());
            });
            finalArg = WasmGCHeapWriter.createFixedArray(this.indexArray, this.indexArrayType, instructions, gen);
        } else {
            finalArg = Instruction.Const.forInt((int)data.getInfo().getOffset()).setComment("Data segment offset");
        }
        WasmId.Func fillFunction = this.providers.knownIds().fillHeapArrayTemplate.requestFunctionId(componentKind);
        gen.accept(new Instruction.Call(fillFunction, WasmGCHeapWriter.getObjectIndex(data), this.getHubIndex(data), finalArg).setComment(this.commentForObject(data)));
    }

    private static Instruction fillArray(WasmId.ArrayType arrayType, Instruction dest, Instruction[] src, int offset, int length) {
        Instruction[] slice = Arrays.copyOfRange(src, offset, offset + length);
        Instruction.ArrayNewFixed tempArray = new Instruction.ArrayNewFixed(arrayType, slice);
        return new Instruction.ArrayCopy(arrayType, arrayType, dest, Instruction.Const.forInt(offset), tempArray, Instruction.Const.forInt(0), Instruction.Const.forInt(length));
    }

    private static Instruction createFixedArray(WasmId.Local arrayLocal, WasmId.ArrayType arrayType, Instruction[] instructions, Consumer<Instruction> gen) {
        int length = instructions.length;
        if (length > 10000) {
            gen.accept(arrayLocal.setter(new Instruction.ArrayNew(arrayType, Instruction.Const.forInt(length))));
            for (int offset = 0; offset < length; offset += 10000) {
                int sliceLength = Math.min(length - offset, 10000);
                gen.accept(WasmGCHeapWriter.fillArray(arrayType, arrayLocal.getter(), instructions, offset, sliceLength));
            }
            return arrayLocal.getter();
        }
        return new Instruction.ArrayNewFixed(arrayType, instructions);
    }

    private static Instruction getObjectIndex(ObjectData data) {
        return Instruction.Const.forInt(data.getIndex()).setComment("Table index");
    }

    private Instruction getHubIndex(ObjectData data) {
        HostedClass clazz = data.getInfo().getClazz();
        JavaConstant hubConstant = this.providers.getConstantReflection().asJavaClass((ResolvedJavaType)clazz);
        return Instruction.Const.forInt(this.getConstantInfo(hubConstant).getIndex()).setComment("Table index for hub: " + clazz.toJavaName());
    }

    private Instruction getterForObject(ObjectData data) {
        WasmRefType type = ((WasmRefType)this.providers.util().typeForJavaType((JavaType)data.info.getClazz())).asNonNull();
        return new Instruction.RefCast(new Instruction.TableGet(this.providers.knownIds().imageHeapObjectTable, Instruction.Const.forInt(data.getIndex())), type);
    }

    private String commentForObject(ObjectData data) {
        HostedClass clazz = data.getInfo().getClazz();
        StringBuilder comment = new StringBuilder(clazz.toJavaName());
        if (DynamicHubLayout.singleton().isDynamicHub((HostedType)clazz)) {
            ResolvedJavaType t = this.providers.getConstantReflection().asJavaType((Constant)data.getInfo().getConstant());
            Class representedClazz = OriginalClassProvider.getJavaClass((JavaType)t);
            comment.append(" for ").append(representedClazz.getTypeName());
        }
        return comment.toString();
    }

    private static List<HostedField> filterFields(HostedClass clazz, List<HostedField> fields) {
        Stream<HostedField> stream = fields.stream().filter(HostedField::isRead);
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        if (dynamicHubLayout.isDynamicHub((HostedType)clazz)) {
            stream = stream.filter(field -> !dynamicHubLayout.isIgnoredField(field));
        }
        return stream.toList();
    }

    public static List<HostedField> getInstanceFields(HostedClass clazz) {
        ArrayList<HostedField> fields = new ArrayList<HostedField>();
        for (HostedClass superType = clazz; superType != null; superType = superType.getSuperclass()) {
            fields.addAll(WasmGCHeapWriter.getOwnInstanceFields(superType));
        }
        return fields;
    }

    public static List<HostedField> getOwnInstanceFields(HostedClass clazz) {
        return WasmGCHeapWriter.filterFields(clazz, List.of(clazz.getInstanceFields(false)));
    }

    public static HostedInstanceClass getFirstClassWithFields(HostedClass clazz) {
        HostedClass nextSuperClass = clazz;
        while (!nextSuperClass.isJavaLangObject() && WasmGCHeapWriter.getOwnInstanceFields(nextSuperClass).isEmpty()) {
            nextSuperClass = nextSuperClass.getSuperclass();
        }
        return (HostedInstanceClass)nextSuperClass;
    }

    public static final class ObjectData {
        private final NativeImageHeap.ObjectInfo info;
        private final WasmId.Global globalVariable;
        private int index = -1;

        public ObjectData(NativeImageHeap.ObjectInfo info, WasmId.Global globalVariable) {
            this.info = info;
            this.globalVariable = globalVariable;
        }

        public NativeImageHeap.ObjectInfo getInfo() {
            return this.info;
        }

        public boolean isEmbedded() {
            return this.globalVariable != null;
        }

        public int getIndex() {
            assert (this.index > 0) : "Index not yet set";
            return this.index;
        }

        public void setIndex(int index) {
            assert (this.index == -1) : "Index already set to " + this.index;
            assert (index > 0) : "Invalid index: " + index;
            this.index = index;
        }

        public WasmId.Global getGlobalVariable() {
            assert (this.isEmbedded()) : "Only embedded objects use a global variable";
            return this.globalVariable;
        }

        public WasmGCPartition getPartition() {
            return (WasmGCPartition)this.info.getPartition();
        }

        public boolean isPseudo() {
            return this.getPartition().isPseudo();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(this.getInfo().getClazz().getJavaClass()).append(", ");
            if (this.isEmbedded()) {
                sb.append("embedded, ");
            }
            if (this.isPseudo()) {
                sb.append("pseudo, ");
            }
            if (this.index > 0) {
                sb.append("table index: ").append(this.index).append(", ");
            }
            sb.append(this.info).append(']');
            return sb.toString();
        }
    }
}

