/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.svm.core.hub.Hybrid;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmBackend;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.GCKnownIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCHeapWriter;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmGCUtil;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import com.oracle.svm.webimage.wasmgc.WasmExtern;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.nodes.extended.AbstractBoxingNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WasmGCFunctionTemplates {
    private static boolean isValidArrayComponentKind(JavaKind kind) {
        return switch (kind) {
            case JavaKind.Boolean, JavaKind.Byte, JavaKind.Short, JavaKind.Char, JavaKind.Int, JavaKind.Float, JavaKind.Long, JavaKind.Double, JavaKind.Object -> true;
            default -> false;
        };
    }

    public static class UnsafeCreate
    extends WasmFunctionTemplate.Singleton {
        public UnsafeCreate(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName() {
            return "unsafe.create";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context context) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)context.getProviders();
            WasmGCUtil util = providers.util();
            Function f = context.createFunction(TypeUse.withResult(util.getJavaLangObjectType(), util.getHubObjectType()), (Object)"Creates an uninitialized instance of the given class");
            WasmId.Local clazzParam = f.getParam(0);
            f.getInstructions().add(providers.builder().createUninitialized(clazzParam.getter()));
            return f;
        }
    }

    public static class Throw
    extends WasmFunctionTemplate.Singleton {
        public Throw(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName() {
            return "throw";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context context) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)context.getProviders();
            Function f = context.createFunction(TypeUse.withoutResult(providers.util().getThrowableType()), (Object)"Throws a Java exception");
            WasmId.Local exceptionParam = f.getParam(0);
            f.getInstructions().add(new Instruction.Throw(providers.knownIds().getJavaThrowableTag(), exceptionParam.getter()));
            return f;
        }
    }

    public static class ArrayCopy
    extends WasmFunctionTemplate<JavaKind> {
        public ArrayCopy(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected boolean isValidParameter(JavaKind javaKind) {
            return javaKind.getSlotCount() > 0;
        }

        @Override
        protected String getFunctionName(JavaKind javaKind) {
            return "arraycopy." + String.valueOf(javaKind);
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            JavaKind componentKind = (JavaKind)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmRefType object = providers.util().getJavaLangObjectType();
            WasmId.ArrayType innerArrayType = providers.knownIds().innerArrayTypes.get(componentKind);
            WasmRefType arrayStruct = providers.knownIds().arrayStructTypes.get(componentKind).asNullable();
            Function f = ctxt.createFunction(TypeUse.withoutResult(object, WasmPrimitiveType.i32, object, WasmPrimitiveType.i32, WasmPrimitiveType.i32), (Object)("Array copy for " + String.valueOf(componentKind)));
            WasmId.Local fromArrayParam = f.getParam(0);
            WasmId.Local fromIndexParam = f.getParam(1);
            WasmId.Local toArrayParam = f.getParam(2);
            WasmId.Local toIndexParam = f.getParam(3);
            WasmId.Local lengthParam = f.getParam(4);
            f.getInstructions().add(new Instruction.ArrayCopy(innerArrayType, innerArrayType, providers.builder.getInnerArray(new Instruction.RefCast(toArrayParam.getter(), arrayStruct), componentKind), toIndexParam.getter(), providers.builder.getInnerArray(new Instruction.RefCast(fromArrayParam.getter(), arrayStruct), componentKind), fromIndexParam.getter(), lengthParam.getter()));
            return f;
        }
    }

    public static class FillHeapArray
    extends WasmFunctionTemplate<JavaKind> {
        public FillHeapArray(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected boolean isValidParameter(JavaKind javaKind) {
            return javaKind.getSlotCount() > 0;
        }

        @Override
        protected String getFunctionName(JavaKind javaKind) {
            return "heap.init.array." + String.valueOf(javaKind);
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            JavaKind componentKind = (JavaKind)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            GCKnownIds knownIds = providers.knownIds();
            WasmId.StructType arrayStructType = knownIds.arrayStructTypes.get(componentKind);
            WasmId.ArrayType innerArrayType = knownIds.innerArrayTypes.get(componentKind);
            WasmId.ArrayType objectIndicesArrayType = knownIds.innerArrayTypes.get(JavaKind.Int);
            boolean isObject = componentKind.isObject();
            ArrayList<WasmValType> argTypes = new ArrayList<WasmValType>();
            argTypes.add(WasmPrimitiveType.i32);
            argTypes.add(WasmPrimitiveType.i32);
            if (isObject) {
                argTypes.add(objectIndicesArrayType.asNonNull());
            } else {
                argTypes.add(WasmPrimitiveType.i32);
            }
            Function f = ctxt.createFunction(TypeUse.withoutResult(argTypes.toArray(new WasmValType[0])), (Object)("Fill image heap " + String.valueOf(componentKind) + " array"));
            Instructions instructions = f.getInstructions();
            WasmId.Local objectIndexParam = f.getParam(0);
            WasmId.Local hubIndexParam = f.getParam(1);
            WebImageWasmIds.TempLocal arrayRef = this.idFactory.newTemporaryVariable(arrayStructType.asNonNull());
            WebImageWasmIds.TempLocal innerArray = this.idFactory.newTemporaryVariable(innerArrayType.asNonNull());
            WebImageWasmIds.TempLocal arrayLength = this.idFactory.newTemporaryVariable(WasmPrimitiveType.i32);
            instructions.add(arrayRef.setter(FillHeapObject.getObject(knownIds, objectIndexParam.getter(), arrayStructType.asNonNull())));
            instructions.add(innerArray.setter(providers.builder().getInnerArray(arrayRef.getter(), componentKind)));
            instructions.add(arrayLength.setter(new Instruction.ArrayLen(innerArray.getter())));
            instructions.add(new Instruction.StructSet(arrayStructType, knownIds.hubField, arrayRef.getter(), FillHeapObject.getHub(providers, hubIndexParam.getter())));
            if (isObject) {
                WasmId.Local indicesArrayParam = f.getParam(2);
                WebImageWasmIds.TempLocal loopIndex = this.idFactory.newTemporaryVariable(WasmPrimitiveType.i32);
                WebImageWasmIds.InternalLabel loopLabel = this.idFactory.newInternalLabel("loop");
                Instruction.Loop loop = new Instruction.Loop(loopLabel);
                instructions.add(loop);
                Instruction.If ifInstr = new Instruction.If(null, Instruction.Binary.Op.I32LtS.create(loopIndex.getter(), arrayLength.getter()));
                loop.instructions.add(ifInstr);
                Instructions thenInstructions = ifInstr.thenInstructions;
                Instruction objectRef = FillHeapObject.getObject(knownIds, new Instruction.ArrayGet(objectIndicesArrayType, WasmUtil.Extension.None, indicesArrayParam.getter(), loopIndex.getter()));
                thenInstructions.add(new Instruction.ArraySet(innerArrayType, innerArray.getter(), loopIndex.getter(), objectRef));
                thenInstructions.add(loopIndex.setter(Instruction.Binary.Op.I32Add.create(loopIndex.getter(), Instruction.Const.forInt(1))));
                thenInstructions.add(new Instruction.Break(loopLabel));
            } else {
                WasmId.Local offsetParam = f.getParam(2);
                instructions.add(new Instruction.ArrayInitData(innerArrayType, knownIds.dataSegmentId, innerArray.getter(), Instruction.Const.forInt(0), offsetParam.getter(), arrayLength.getter()));
            }
            return f;
        }
    }

    public static class FillHeapObject
    extends WasmFunctionTemplate<HostedInstanceClass> {
        public FillHeapObject(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected boolean isValidParameter(HostedInstanceClass instanceClass) {
            return instanceClass.isJavaLangObject() || !WasmGCHeapWriter.getOwnInstanceFields((HostedClass)instanceClass).isEmpty();
        }

        @Override
        protected String getFunctionName(HostedInstanceClass hostedType) {
            return "heap.init.object." + WebImageNamingConvention.getInstance().identForType((ResolvedJavaType)hostedType);
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            HostedInstanceClass clazz = (HostedInstanceClass)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            WebImageWasmGCIds.JavaStruct typeId = providers.idFactory().newJavaStruct((ResolvedJavaType)clazz);
            DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
            List<HostedField> ownFields = WasmGCHeapWriter.getOwnInstanceFields((HostedClass)clazz);
            List<HostedField> notOwnFields = WasmGCHeapWriter.getInstanceFields(clazz.getSuperclass());
            ArrayList<HostedField> instanceFields = new ArrayList<HostedField>(ownFields.size() + notOwnFields.size());
            instanceFields.addAll(ownFields);
            instanceFields.addAll(notOwnFields);
            ArrayList<WasmValType> paramTypes = new ArrayList<WasmValType>();
            paramTypes.add(WasmPrimitiveType.i32);
            paramTypes.add(WasmPrimitiveType.i32);
            paramTypes.add(WasmPrimitiveType.i32);
            if (dynamicHubLayout.isDynamicHub((HostedType)clazz)) {
                paramTypes.add(providers.knownIds().accessDispatchFieldType.asNullable());
                paramTypes.add(providers.knownIds().vtableFieldType.asNullable());
                paramTypes.add(providers.knownIds().typeCheckSlotsFieldType.asNullable());
                paramTypes.add(providers.knownIds().newInstanceFieldType.asNullable());
                paramTypes.add(providers.knownIds().cloneFieldType.asNullable());
            } else if (HybridLayout.isHybrid((ResolvedJavaType)clazz)) {
                throw VMError.shouldNotReachHere((String)("Found unsupported @" + Hybrid.class.getSimpleName() + " image heap object of type: " + String.valueOf(clazz)));
            }
            int numNonFieldParams = paramTypes.size();
            for (HostedField field : instanceFields) {
                HostedType fieldType = (HostedType)util.canonicalizeJavaType((ResolvedJavaType)field.getType());
                if (fieldType.isPrimitive()) {
                    paramTypes.add(util.typeForJavaType((JavaType)fieldType));
                    continue;
                }
                paramTypes.add(WasmPrimitiveType.i32);
            }
            Function f = ctxt.createFunction(TypeUse.withoutResult(paramTypes.toArray(new WasmValType[0])), (Object)("Fill image heap object of type " + clazz.toJavaName()));
            Instructions instructions = f.getInstructions();
            WasmId.Local objectIndexParam = f.getParam(0);
            WasmId.Local hubIndexParam = f.getParam(1);
            WasmId.Local hashCodeParam = f.getParam(2);
            WebImageWasmIds.TempLocal objectRef = this.idFactory.newTemporaryVariable(typeId.asNonNull());
            instructions.add(objectRef.setter(FillHeapObject.getObject(providers.knownIds(), objectIndexParam.getter(), typeId.asNonNull())));
            if (dynamicHubLayout.isDynamicHub((HostedType)clazz)) {
                WasmId.Local accessDispatchParam = f.getParam(3);
                WasmId.Local vtableParam = f.getParam(4);
                WasmId.Local typeCheckSlotsParam = f.getParam(5);
                WasmId.Local newInstanceFunctionParam = f.getParam(6);
                WasmId.Local cloneFunctionParam = f.getParam(7);
                instructions.add(new Instruction.StructSet(typeId, providers.knownIds().accessDispatchField, objectRef.getter(), accessDispatchParam.getter()));
                instructions.add(new Instruction.StructSet(typeId, providers.knownIds().vtableField, objectRef.getter(), vtableParam.getter()));
                instructions.add(new Instruction.StructSet(typeId, providers.knownIds().typeCheckSlotsField, objectRef.getter(), typeCheckSlotsParam.getter()));
                instructions.add(new Instruction.StructSet(typeId, providers.knownIds().newInstanceField, objectRef.getter(), newInstanceFunctionParam.getter()));
                instructions.add(new Instruction.StructSet(typeId, providers.knownIds().cloneField, objectRef.getter(), cloneFunctionParam.getter()));
            }
            if (clazz.isJavaLangObject()) {
                instructions.add(new Instruction.StructSet(typeId, providers.knownIds().hubField, objectRef.getter(), FillHeapObject.getHub(providers, hubIndexParam.getter())));
                instructions.add(new Instruction.StructSet(typeId, providers.knownIds().identityHashCodeField, objectRef.getter(), hashCodeParam.getter()));
            } else {
                Instructions superCallArgs = new Instructions();
                superCallArgs.add(objectIndexParam.getter());
                superCallArgs.add(hubIndexParam.getter());
                superCallArgs.add(hashCodeParam.getter());
                for (int i = ownFields.size(); i < instanceFields.size(); ++i) {
                    WasmId.Local argParam = f.getParam(numNonFieldParams + i);
                    superCallArgs.add(argParam.getter().setComment(((HostedField)instanceFields.get(i)).format("%T %h.%n")));
                }
                HostedInstanceClass nextSuperClass = WasmGCHeapWriter.getFirstClassWithFields(clazz.getSuperclass());
                instructions.add(new Instruction.Call(providers.knownIds().fillHeapObjectTemplate.requestFunctionId(nextSuperClass), superCallArgs));
            }
            int i = 0;
            for (HostedField field : ownFields) {
                WasmId.Local argParam = f.getParam(numNonFieldParams + i);
                HostedType fieldType = (HostedType)util.canonicalizeJavaType((ResolvedJavaType)field.getType());
                Instruction value = fieldType.isPrimitive() ? argParam.getter() : FillHeapObject.getObject(providers.knownIds(), argParam.getter(), (WasmRefType)util.typeForJavaType((JavaType)fieldType));
                instructions.add(new Instruction.StructSet(typeId, this.idFactory.newJavaField((ResolvedJavaField)field), objectRef.getter(), value));
                ++i;
            }
            return f;
        }

        public static Instruction getHub(WebImageWasmGCProviders providers, Instruction index) {
            return FillHeapObject.getObject(providers.knownIds(), index, providers.idFactory().newJavaStruct(providers.getMetaAccess().lookupJavaType(Class.class)).asNonNull());
        }

        public static Instruction getObject(GCKnownIds knownIds, Instruction index) {
            return FillHeapObject.getObject(knownIds, index, null);
        }

        public static Instruction getObject(GCKnownIds knownIds, Instruction index, WasmRefType targetType) {
            Instruction result = new Instruction.TableGet(knownIds.imageHeapObjectTable, index);
            if (targetType != null) {
                result = new Instruction.RefCast(result, targetType);
            }
            return result;
        }
    }

    public static class IndirectCallBridge
    extends WasmFunctionTemplate<HostedMethod> {
        public IndirectCallBridge(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected boolean isValidParameter(HostedMethod hostedMethod) {
            return hostedMethod.getImplementations().length > 1;
        }

        @Override
        protected String getFunctionName(HostedMethod hostedMethod) {
            return "bridge." + WebImageNamingConvention.getInstance().identForType((ResolvedJavaType)hostedMethod.getDeclaringClass()) + "." + WebImageNamingConvention.getInstance().identForMethod((ResolvedJavaMethod)hostedMethod);
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            HostedMethod hostedMethod = (HostedMethod)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            GCKnownIds knownIds = providers.knownIds();
            ResolvedJavaType[] paramTypes = WebImageWasmBackend.constructParamTypes(providers, hostedMethod);
            ResolvedJavaType returnType = WebImageWasmBackend.constructReturnType((ResolvedJavaMethod)hostedMethod);
            TypeUse typeUse = WebImageWasmBackend.signatureToTypeUse(providers, (JavaType[])paramTypes, (JavaType)returnType);
            WasmId.FuncType funcType = providers.util().functionIdForMethod(typeUse);
            Function f = ctxt.createFunction(typeUse, (Object)("Bridge for indirect calls to " + hostedMethod.format("%H.%n(%P)")));
            WasmId.Local receiverParam = f.getParam(0);
            Instructions params = new Instructions();
            for (WasmId.Local param : f.getParams()) {
                params.add(param.getter());
            }
            Instruction.Call functionIdx = new Instruction.Call(knownIds.getFunctionIndexTemplate.requestFunctionId(), receiverParam.getter(), Instruction.Const.forInt(hostedMethod.getVTableIndex()));
            f.getInstructions().add(new Instruction.CallIndirect(knownIds.functionTable, (Instruction)functionIdx, funcType, typeUse, params));
            return f;
        }
    }

    public static class GetFunctionIndex
    extends WasmFunctionTemplate.Singleton {
        public GetFunctionIndex(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName() {
            return "get_funtable_idx";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            GCKnownIds knownIds = providers.knownIds();
            WasmRefType objectValType = providers.util().getJavaLangObjectType();
            WasmId.StructType hubStructType = providers.util().getHubObjectId();
            Function f = ctxt.createFunction(TypeUse.withResult(WasmPrimitiveType.i32, objectValType, WasmPrimitiveType.i32), (Object)"Loads the global function table index from the Object's vtable");
            WasmId.Local objectParam = f.getParam(0);
            WasmId.Local vtableIndexParam = f.getParam(1);
            Instruction hub = providers.builder.getHub(objectParam.getter());
            Instruction.StructGet vtable = new Instruction.StructGet(hubStructType, knownIds.vtableField, WasmUtil.Extension.None, hub);
            f.getInstructions().add(Instruction.Unary.Op.I32Wrap64.create(new Instruction.ArrayGet(knownIds.vtableFieldType, WasmUtil.Extension.None, vtable, vtableIndexParam.getter())));
            return f;
        }
    }

    public static class AllocatingBox
    extends WasmFunctionTemplate<JavaKind> {
        public AllocatingBox(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected boolean isValidParameter(JavaKind javaKind) {
            return javaKind.isPrimitive();
        }

        @Override
        protected String getFunctionName(JavaKind javaKind) {
            return "box." + javaKind.name();
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            JavaKind boxedKind = (JavaKind)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            MetaAccessProvider metaAccess = providers.getMetaAccess();
            Class boxedJavaClass = boxedKind.toBoxedJavaClass();
            ResolvedJavaType boxing = metaAccess.lookupJavaType(boxedJavaClass);
            WebImageWasmGCIds.JavaStruct boxedStruct = this.idFactory.newJavaStruct(boxing);
            WasmRefType returnValue = boxedStruct.asNonNull();
            ResolvedJavaField valueField = AbstractBoxingNode.getValueField((ResolvedJavaType)boxing);
            Function f = ctxt.createFunction(TypeUse.forUnary(returnValue, providers.util().mapType(boxedKind)), (Object)("Creates a boxed " + boxedKind.name()));
            Instructions instructions = f.getInstructions();
            WasmId.Local valueParam = f.getParam(0);
            WebImageWasmIds.TempLocal boxed = this.idFactory.newTemporaryVariable(returnValue);
            instructions.add(boxed.setter(new Instruction.Call(providers.knownIds().instanceCreateTemplate.requestFunctionId(boxedJavaClass), new Instruction[0])));
            instructions.add(new Instruction.StructSet(boxedStruct, this.idFactory.newJavaField(valueField), boxed.getter(), valueParam.getter()));
            instructions.add(new Instruction.Return(boxed.getter()));
            return f;
        }
    }

    public static class InstanceCreate
    extends WasmFunctionTemplate<Class<?>> {
        public InstanceCreate(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected boolean isValidParameter(Class<?> parameter) {
            return !parameter.isArray();
        }

        @Override
        protected String getFunctionName(Class<?> type) {
            return "struct." + type.getName() + ".create";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            Class key = (Class)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            MetaAccessProvider metaAccess = providers.getMetaAccess();
            ResolvedJavaType type = metaAccess.lookupJavaType(key);
            WebImageWasmGCIds.JavaStruct structType = this.idFactory.newJavaStruct(type);
            WasmRefType structValType = structType.asNonNull();
            WebImageWasmIds.DescriptorFuncType funcType = this.idFactory.newFuncType(new FunctionTypeDescriptor(providers.knownIds().newInstanceFieldType, true, TypeUse.withResult(structValType, new WasmValType[0])));
            Function f = ctxt.createFunction(funcType, (Object)("Creates an instance of type " + String.valueOf(key)));
            WebImageWasmIds.TempLocal structVar = this.idFactory.newTemporaryVariable(structValType);
            JavaConstant hubConstant = providers.getConstantReflection().asJavaClass(type);
            Instructions instructions = f.getInstructions();
            instructions.add(structVar.tee(new Instruction.StructNew(structType)));
            instructions.add(new Instruction.StructSet(structType, providers.knownIds().hubField, new Instruction.Nop(), ctxt.getCodeGenTool().getConstantRelocation(hubConstant)));
            instructions.add(new Instruction.Return(structVar.getter()));
            return f;
        }
    }

    public static class ArrayCreate
    extends WasmFunctionTemplate<Class<?>> {
        public ArrayCreate(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName(Class<?> componentType) {
            return "array." + componentType.getCanonicalName() + ".create";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            Class componentType = (Class)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            ResolvedJavaType resolvedComponentType = providers.getMetaAccess().lookupJavaType(componentType);
            JavaKind componentKind = resolvedComponentType.getJavaKind();
            WasmRefType arrayStructType = this.idFactory.newJavaArrayStruct(componentKind).asNullable();
            JavaConstant hubConstant = providers.getConstantReflection().asJavaClass(resolvedComponentType.getArrayClass());
            assert (!hubConstant.isNull()) : hubConstant;
            Function f = ctxt.createFunction(TypeUse.forUnary(arrayStructType, WasmPrimitiveType.i32), (Object)("Creates a Java array of type " + String.valueOf(componentType) + "[]"));
            WasmId.Local lengthParam = f.getParam(0);
            f.getInstructions().add(providers.builder().createNewArray(componentKind, ctxt.getCodeGenTool().getConstantRelocation(hubConstant), lengthParam.getter()));
            return f;
        }
    }

    public static class ArrayElementStore
    extends WasmFunctionTemplate<JavaKind> {
        public ArrayElementStore(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected boolean isValidParameter(JavaKind parameter) {
            return WasmGCFunctionTemplates.isValidArrayComponentKind(parameter);
        }

        @Override
        protected String getFunctionName(JavaKind kind) {
            return "array." + kind.name() + ".write";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            JavaKind componentKind = (JavaKind)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmRefType arrayStructType = this.idFactory.newJavaArrayStruct(componentKind).asNullable();
            WasmValType elementType = providers.util().mapType(componentKind);
            Function f = ctxt.createFunction(TypeUse.withoutResult(arrayStructType, WasmPrimitiveType.i32, elementType), (Object)("Stores an array element to an array struct with component kind " + String.valueOf(componentKind)));
            WasmId.Local arrayParam = f.getParam(0);
            WasmId.Local indexParam = f.getParam(1);
            WasmId.Local valueParam = f.getParam(2);
            f.getInstructions().add(providers.builder().setArrayElement(arrayParam.getter(), indexParam.getter(), valueParam.getter(), componentKind));
            return f;
        }
    }

    public static class ArrayElementLoad
    extends WasmFunctionTemplate<JavaKind> {
        public ArrayElementLoad(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected boolean isValidParameter(JavaKind parameter) {
            return WasmGCFunctionTemplates.isValidArrayComponentKind(parameter);
        }

        @Override
        protected String getFunctionName(JavaKind kind) {
            return "array." + kind.name() + ".read";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            JavaKind componentKind = (JavaKind)ctxt.getParameter();
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmRefType arrayStructType = this.idFactory.newJavaArrayStruct(componentKind).asNullable();
            WasmValType elementType = providers.util().mapType(componentKind);
            Function f = ctxt.createFunction(TypeUse.forBinary(elementType, arrayStructType, WasmPrimitiveType.i32), (Object)("Loads an array element from an array struct with component kind " + String.valueOf(componentKind)));
            WasmId.Local arrayParam = f.getParam(0);
            WasmId.Local indexParam = f.getParam(1);
            f.getInstructions().add(providers.builder().getArrayElement(arrayParam.getter(), indexParam.getter(), componentKind));
            return f;
        }
    }

    public static class ArrayLength
    extends WasmFunctionTemplate.Singleton {
        public ArrayLength(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected String getFunctionName() {
            return "array.length";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmRefType arrayStructType = providers.knownIds().baseArrayType.asNullable();
            Function f = ctxt.createFunction(TypeUse.forUnary(WasmPrimitiveType.i32, arrayStructType), (Object)"Get array length of an array struct");
            WasmId.Local arrayParam = f.getParam(0);
            f.getInstructions().add(providers.builder().getArrayLength(arrayParam.getter()));
            return f;
        }
    }

    public static class WrapExtern
    extends WasmFunctionTemplate.Singleton {
        public WrapExtern(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName() {
            return "extern.wrap";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            WasmGCUtil util = providers.util();
            ResolvedJavaType wasmExternType = providers.getMetaAccess().lookupJavaType(WasmExtern.class);
            WebImageWasmGCIds.JavaStruct wasmExternId = this.idFactory.newJavaStruct(wasmExternType);
            WasmRefType javaLangObjectType = util.getJavaLangObjectType();
            JavaConstant hubConstant = providers.getConstantReflection().asJavaClass(providers.getMetaAccess().lookupJavaType(WasmExtern.class));
            Function f = ctxt.createFunction(TypeUse.forUnary(javaLangObjectType, WasmRefType.EXTERNREF), (Object)"Wrap externref in Java object");
            WasmId.Local externRefParam = f.getParam(0);
            Instruction.If nullCheck = new Instruction.If(null, Instruction.Unary.Op.RefIsNull.create(externRefParam.getter()));
            nullCheck.thenInstructions.add(new Instruction.Return(new Instruction.RefNull(javaLangObjectType)));
            f.getInstructions().add(nullCheck);
            Instruction.If javaObjectTest = new Instruction.If(null, new Instruction.RefTest(Instruction.AnyExternConversion.toAny(externRefParam.getter()), javaLangObjectType));
            javaObjectTest.thenInstructions.add(new Instruction.Return(new Instruction.RefCast(Instruction.AnyExternConversion.toAny(externRefParam.getter()), javaLangObjectType)));
            f.getInstructions().add(javaObjectTest);
            Instruction.Const identityHashCode = Instruction.Const.forInt(0);
            f.getInstructions().add(new Instruction.StructNew(wasmExternId, ctxt.getCodeGenTool().getConstantRelocation(hubConstant), identityHashCode, externRefParam.getter()));
            return f;
        }
    }

    public static class ToExtern
    extends WasmFunctionTemplate.Singleton {
        public ToExtern(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected String getFunctionName() {
            return "extern.unwrap";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context ctxt) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)ctxt.getProviders();
            ResolvedJavaType wasmExternType = providers.getMetaAccess().lookupJavaType(WasmExtern.class);
            WebImageWasmGCIds.JavaStruct wasmExternId = this.idFactory.newJavaStruct(wasmExternType);
            WasmRefType wasmExternRef = wasmExternId.asNonNull();
            Function f = ctxt.createFunction(TypeUse.forUnary(WasmRefType.EXTERNREF, providers.util().getJavaLangObjectType()), (Object)"Converts a Java object to an externref. WasmExtern instances are simply unwrapped.");
            WasmId.Local objectParam = f.getParam(0);
            Instruction.If ifInstr = new Instruction.If(null, new Instruction.RefTest(objectParam.getter(), wasmExternRef));
            Instructions thenBranch = ifInstr.thenInstructions;
            Instructions elseBranch = ifInstr.elseInstructions;
            f.getInstructions().add(ifInstr);
            thenBranch.add(new Instruction.Return(new Instruction.StructGet(wasmExternId, providers.knownIds().embedderField, WasmUtil.Extension.None, new Instruction.RefCast(objectParam.getter(), wasmExternRef))));
            elseBranch.add(new Instruction.Return(Instruction.AnyExternConversion.toExtern(objectParam.getter())));
            return f;
        }
    }
}

