/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.GCKnownIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.visitors.WasmGCElementCreator;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmGCUtil;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.WasmForeignCallDescriptor;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import java.util.Map;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.ForeignCallWithExceptionNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

public class WasmGCCloneSupport {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CLONE = SnippetRuntime.findForeignCall(WasmGCCloneSupport.class, (String)"doClone", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CLONE};
    public static final WasmForeignCallDescriptor CLONE_TEMPLATE = new WasmForeignCallDescriptor("clone", Object.class, new Class[]{Object.class});

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    public static void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        lowerings.put(SubstrateObjectCloneNode.class, new ObjectCloneLowering());
        lowerings.put(SubstrateObjectCloneWithExceptionNode.class, new ObjectCloneWithExceptionLowering());
    }

    public static boolean needsCloneTemplate(HostedType type) {
        return type.isCloneableWithAllocation();
    }

    public static TypeUse getCloneFieldTypeUse(WasmGCUtil util) {
        WasmId.StructType javaLangObjectId = util.getJavaLangObjectId();
        return TypeUse.forUnary(javaLangObjectId.asNonNull(), javaLangObjectId.asNullable());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object doClone(Object original) throws CloneNotSupportedException {
        if (original == null) {
            throw new NullPointerException();
        }
        if (!(original instanceof Cloneable)) {
            throw new CloneNotSupportedException("Object is no instance of Cloneable.");
        }
        return WasmGCCloneSupport.callCloneTemplate(CLONE_TEMPLATE, original);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callCloneTemplate(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    static final class ObjectCloneLowering
    implements NodeLoweringProvider<SubstrateObjectCloneNode> {
        ObjectCloneLowering() {
        }

        public void lower(SubstrateObjectCloneNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallNode call = (ForeignCallNode)graph.add((Node)new ForeignCallNode((ForeignCallDescriptor)CLONE, new ValueNode[]{node.getObject()}));
            call.setBci(node.bci());
            call.setStamp(node.stamp(NodeView.DEFAULT));
            graph.replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)call);
        }
    }

    static final class ObjectCloneWithExceptionLowering
    implements NodeLoweringProvider<SubstrateObjectCloneWithExceptionNode> {
        ObjectCloneWithExceptionLowering() {
        }

        public void lower(SubstrateObjectCloneWithExceptionNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)CLONE, new ValueNode[]{node.getObject()}));
            call.setBci(node.bci());
            call.setStamp(node.stamp(NodeView.DEFAULT));
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }

    public static class ArrayCloneTemplate
    extends WasmFunctionTemplate<JavaKind> {
        public ArrayCloneTemplate(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected boolean isValidParameter(JavaKind componentKind) {
            return componentKind.getSlotCount() > 0;
        }

        @Override
        protected String getFunctionName(JavaKind componentKind) {
            return "clone.array." + String.valueOf(componentKind);
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context context) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)context.getProviders();
            GCKnownIds knownIds = providers.knownIds();
            WasmGCUtil util = providers.util();
            JavaKind componentKind = (JavaKind)context.getParameter();
            WebImageWasmGCIds.JavaArrayStruct arrayStruct = this.idFactory.newJavaArrayStruct(componentKind);
            WasmRefType arrayStructType = arrayStruct.asNonNull();
            Function f = Function.create(this.idFactory, context.getId(), knownIds.cloneFieldType, WasmGCCloneSupport.getCloneFieldTypeUse(util), "Clones array of component kind " + String.valueOf(componentKind));
            Instructions instructions = f.getInstructions();
            WebImageWasmIds.TempLocal arrayRef = this.idFactory.newTemporaryVariable(arrayStructType);
            WebImageWasmIds.TempLocal clonedArray = this.idFactory.newTemporaryVariable(arrayStructType);
            WebImageWasmIds.TempLocal arrayLength = this.idFactory.newTemporaryVariable(WasmPrimitiveType.i32);
            instructions.add(arrayRef.setter(new Instruction.RefCast(f.getParam(0).getter(), arrayStructType)));
            instructions.add(arrayLength.setter(providers.builder.getArrayLength(arrayRef.getter())));
            instructions.add(clonedArray.setter(providers.builder().createNewArray(componentKind, providers.builder().getHub(arrayRef.getter()), arrayLength.getter())));
            instructions.add(new Instruction.Call(knownIds.arrayCopyTemplate.requestFunctionId(componentKind), arrayRef.getter(), Instruction.Const.forInt(0), clonedArray.getter(), Instruction.Const.forInt(0), arrayLength.getter()));
            instructions.add(new Instruction.Return(clonedArray.getter()));
            return f;
        }
    }

    public static class ObjectCloneTemplate
    extends WasmFunctionTemplate<HostedInstanceClass> {
        public ObjectCloneTemplate(WasmIdFactory idFactory) {
            super(idFactory, true);
        }

        @Override
        protected String getFunctionName(HostedInstanceClass clazz) {
            return "clone.object." + clazz.getJavaClass().getTypeName();
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context context) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)context.getProviders();
            GCKnownIds knownIds = providers.knownIds();
            WasmGCUtil util = providers.util();
            HostedClass type = (HostedClass)context.getParameter();
            WebImageWasmGCIds.JavaStruct struct = this.idFactory.newJavaStruct((ResolvedJavaType)type);
            WasmRefType wasmType = struct.asNonNull();
            Function f = Function.create(this.idFactory, context.getId(), knownIds.cloneFieldType, WasmGCCloneSupport.getCloneFieldTypeUse(util), "Clones object of type " + type.getJavaClass().getTypeName());
            WebImageWasmIds.TempLocal objectRef = this.idFactory.newTemporaryVariable(wasmType);
            f.getInstructions().add(objectRef.setter(new Instruction.RefCast(f.getParam(0).getter(), wasmType)));
            Instructions fields = new Instructions();
            fields.add(new Instruction.StructGet(struct, knownIds.hubField, WasmUtil.Extension.None, objectRef.getter()));
            fields.add(Instruction.Const.forInt(0));
            for (ResolvedJavaField field : WasmGCElementCreator.getInstanceFields((ResolvedJavaType)type)) {
                HostedField hField = (HostedField)field;
                WebImageWasmGCIds.JavaField javaField = this.idFactory.newJavaField(field);
                fields.add(new Instruction.StructGet(struct, javaField, WasmUtil.Extension.forKind(hField.getStorageKind()), objectRef.getter()));
            }
            f.getInstructions().add(new Instruction.StructNew(struct, fields.toArray()));
            return f;
        }
    }

    public static class GenericCloneTemplate
    extends WasmFunctionTemplate.Singleton {
        public GenericCloneTemplate(WasmIdFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String getFunctionName() {
            return "clone.object";
        }

        @Override
        protected Function createFunction(WasmFunctionTemplate.Context context) {
            WebImageWasmGCProviders providers = (WebImageWasmGCProviders)context.getProviders();
            WasmGCUtil util = providers.util();
            GCKnownIds knownIds = providers.knownIds();
            Function f = context.createFunction(WasmGCCloneSupport.getCloneFieldTypeUse(util), (Object)"Clones an arbitrary cloneable object");
            WasmId.Local objectParam = f.getParam(0);
            f.getInstructions().add(new Instruction.CallRef(knownIds.cloneFieldType, (Instruction)new Instruction.StructGet(util.getHubObjectId(), knownIds.cloneField, WasmUtil.Extension.None, providers.builder().getHub(objectParam.getter())), Instructions.asInstructions(objectParam.getter())));
            return f;
        }
    }
}

