/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.codegen;

import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.GCKnownIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import jdk.vm.ci.meta.JavaKind;

public class WasmGCBuilder {
    private final WebImageWasmGCProviders providers;
    private final WasmIdFactory idFactory;
    private final GCKnownIds knownIds;

    public WasmGCBuilder(WebImageWasmGCProviders providers) {
        this.providers = providers;
        this.idFactory = providers.idFactory();
        this.knownIds = providers.knownIds();
    }

    public Instruction isArrayStruct(Instruction ref, JavaKind componentKind) {
        return new Instruction.RefTest(ref, this.knownIds.getArrayStructType(componentKind).asNonNull());
    }

    public Instruction getInnerArray(Instruction arrayStruct, JavaKind componentKind) {
        return new Instruction.StructGet(this.knownIds.getArrayStructType(componentKind), this.knownIds.innerArrayField, WasmUtil.Extension.None, arrayStruct);
    }

    public Instruction getArrayLength(Instruction arrayStruct) {
        return new Instruction.ArrayLen(this.getInnerArray(arrayStruct, null));
    }

    public Instruction getArrayElement(Instruction arrayStruct, Instruction index, JavaKind componentKind) {
        WebImageWasmGCIds.JavaInnerArray innerArray = this.idFactory.newJavaInnerArray(componentKind);
        return new Instruction.ArrayGet(innerArray, WasmUtil.Extension.forKind(componentKind), this.getInnerArray(arrayStruct, componentKind), index);
    }

    public Instruction setArrayElement(Instruction arrayStruct, Instruction index, Instruction value, JavaKind componentKind) {
        WebImageWasmGCIds.JavaInnerArray innerArray = this.idFactory.newJavaInnerArray(componentKind);
        return new Instruction.ArraySet(innerArray, this.getInnerArray(arrayStruct, componentKind), index, value);
    }

    public Instruction getHub(Instruction objectStruct) {
        WasmId.StructType baseObjectId = this.providers.util().getJavaLangObjectId();
        return new Instruction.StructGet(baseObjectId, this.knownIds.hubField, WasmUtil.Extension.None, objectStruct);
    }

    public Instruction createNewArray(JavaKind componentKind, Instruction hub, Instruction length) {
        Instruction.ArrayNew innerArray = new Instruction.ArrayNew(this.providers.knownIds().innerArrayTypes.get(componentKind), length);
        return new Instruction.StructNew(this.providers.knownIds().arrayStructTypes.get(componentKind), hub, Instruction.Const.forInt(0), innerArray);
    }

    public Instruction createUninitialized(Instruction hub) {
        return new Instruction.CallRef(this.knownIds.newInstanceFieldType, (Instruction)new Instruction.StructGet(this.providers.util().getHubObjectId(), this.knownIds.newInstanceField, WasmUtil.Extension.None, hub), new Instructions());
    }
}

