/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.ast.visitors;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.WasmModule;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmElementCreator;
import com.oracle.svm.hosted.webimage.wasmgc.ast.ArrayType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.FieldType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.FunctionType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.RecTypeGroupBuilder;
import com.oracle.svm.hosted.webimage.wasmgc.ast.RecursiveGroup;
import com.oracle.svm.hosted.webimage.wasmgc.ast.StructType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.TypeDefinition;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.GCKnownIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCCloneSupport;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmPackedType;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmStorageType;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import com.oracle.svm.webimage.wasmgc.WasmExtern;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.webimage.api.JSValue;

public class WasmGCElementCreator
extends WasmElementCreator {
    private final WebImageWasmGCProviders wasmProviders;
    private final WasmIdFactory idFactory;
    private final GCKnownIds knownIds;
    protected Set<WasmId> processedIds = new HashSet<WasmId>();
    protected RecTypeGroupBuilder recGroupBuilder = RecursiveGroup.builder();

    public WasmGCElementCreator(WebImageWasmGCProviders wasmProviders) {
        this.wasmProviders = wasmProviders;
        this.idFactory = wasmProviders.idFactory();
        this.knownIds = wasmProviders.knownIds();
    }

    @Override
    protected void registerType(WasmId.Type id) {
        if (!this.processedIds.add(id)) {
            return;
        }
        if (id == this.knownIds.baseArrayType) {
            this.registerBaseArrayType();
        } else if (id == this.knownIds.accessDispatchFieldType) {
            this.registerAccessDispatchArray();
        } else if (id == this.knownIds.vtableFieldType) {
            this.registerVtableArray();
        } else if (id == this.knownIds.typeCheckSlotsFieldType) {
            this.registerTypeCheckSlotsArray();
        } else if (id == this.knownIds.newInstanceFieldType) {
            this.registerNewInstanceFuncType();
        } else if (id == this.knownIds.cloneFieldType) {
            this.registerCloneFuncType();
        } else {
            WasmId.Type type = id;
            Objects.requireNonNull(type);
            WasmId.Type type2 = type;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WebImageWasmGCIds.JavaStruct.class, WebImageWasmGCIds.JavaArrayStruct.class, WebImageWasmGCIds.JavaInnerArray.class, WebImageWasmIds.DescriptorFuncType.class}, (Object)type2, n)) {
                case 0: {
                    WebImageWasmGCIds.JavaStruct javaStruct = (WebImageWasmGCIds.JavaStruct)type2;
                    this.registerNewJavaStructType(javaStruct);
                    break;
                }
                case 1: {
                    WebImageWasmGCIds.JavaArrayStruct javaArrayStruct = (WebImageWasmGCIds.JavaArrayStruct)type2;
                    this.registerNewJavaArrayStruct(javaArrayStruct);
                    break;
                }
                case 2: {
                    WebImageWasmGCIds.JavaInnerArray javaInnerArray = (WebImageWasmGCIds.JavaInnerArray)type2;
                    this.registerNewJavaInnerArray(javaInnerArray);
                    break;
                }
                case 3: {
                    WebImageWasmIds.DescriptorFuncType funcType = (WebImageWasmIds.DescriptorFuncType)type2;
                    this.registerNewFunctionType(funcType);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere((String)id.toString());
                }
            }
        }
    }

    protected void registerTypeDefinition(TypeDefinition definition) {
        this.recGroupBuilder.addTypeDefinition(definition);
        if (definition.supertype != null) {
            this.registerType(definition.supertype);
        }
        TypeDefinition typeDefinition = definition;
        Objects.requireNonNull(typeDefinition);
        TypeDefinition typeDefinition2 = typeDefinition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayType.class, StructType.class, FunctionType.class}, (Object)typeDefinition2, n)) {
            case 0: {
                ArrayType arrayType = (ArrayType)typeDefinition2;
                this.visitType(arrayType.elementType.storageType);
                break;
            }
            case 1: {
                StructType structType = (StructType)typeDefinition2;
                for (StructType.Field field : structType.fields) {
                    this.visitType(field.fieldType.storageType);
                }
                break;
            }
            case 2: {
                FunctionType funcType = (FunctionType)typeDefinition2;
                this.visitTypeUse(funcType.typeUse);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)definition);
            }
        }
    }

    @Override
    protected void registerNewFunctionType(WebImageWasmIds.DescriptorFuncType funcType) {
        this.registerTypeDefinition(funcType.createTypeDefinition(null));
    }

    protected void registerNewJavaStructType(WebImageWasmGCIds.JavaStruct javaStruct) {
        ResolvedJavaType javaType = javaStruct.javaType;
        List<ResolvedJavaField> instanceFields = WasmGCElementCreator.getInstanceFields(javaType);
        ArrayList<StructType.Field> fields = new ArrayList<StructType.Field>(this.getBaseFields());
        if (this.wasmProviders.getMetaAccess().lookupJavaType(JSValue.class).isAssignableFrom(javaType)) {
            fields.add(new StructType.Field(this.knownIds.jsNativeValueField, FieldType.mutable(this.wasmProviders.util().typeForJavaClass((Class)WasmExtern.class)), "JavaScript Native Value"));
        }
        for (ResolvedJavaField field : instanceFields) {
            WebImageWasmGCIds.JavaField fieldId = this.idFactory.newJavaField(field);
            ResolvedJavaType fieldType = field.getType().resolve(javaType);
            WasmStorageType wasmType = this.wasmProviders.util().storageTypeForJavaType((JavaType)fieldType);
            fields.add(new StructType.Field(fieldId, FieldType.mutable(wasmType), field.format("%H.%n(%T)")));
        }
        if (javaType.equals((Object)this.wasmProviders.getMetaAccess().lookupJavaType(DynamicHub.class))) {
            fields.addAll(this.getExtraHubFields());
        }
        if (javaType.equals((Object)this.wasmProviders.getMetaAccess().lookupJavaType(WasmExtern.class))) {
            fields.add(new StructType.Field(this.knownIds.embedderField, FieldType.immutable(WasmRefType.EXTERNREF), "Internal field holding a reference to an embedder object"));
        }
        boolean isFinal = false;
        if (javaType instanceof HostedType) {
            HostedType hostedType = (HostedType)javaType;
            isFinal = hostedType.getSubTypes().length == 0;
        }
        WebImageWasmGCIds.JavaStruct superClassId = null;
        ResolvedJavaType superClass = javaType.getSuperclass();
        if (superClass != null) {
            superClassId = this.idFactory.newJavaStruct(superClass);
        }
        StructType def = new StructType(javaStruct, superClassId, isFinal, fields, javaType.toJavaName(true));
        this.registerTypeDefinition(def);
    }

    protected void registerNewJavaArrayStruct(WebImageWasmGCIds.JavaArrayStruct javaArrayStruct) {
        JavaKind componentKind = javaArrayStruct.componentKind;
        WasmId.StructType superClassId = this.knownIds.baseArrayType;
        WebImageWasmGCIds.JavaInnerArray javaInnerArray = this.knownIds.innerArrayTypes.get(componentKind);
        List<StructType.Field> fields = this.getArrayFields(javaInnerArray.asNonNull());
        WebImageWasmGCIds.JavaArrayStruct arrayStruct = this.knownIds.arrayStructTypes.get(componentKind);
        StructType def = new StructType(arrayStruct, superClassId, true, fields, componentKind.getJavaName() + "[]");
        this.registerTypeDefinition(def);
    }

    protected void registerNewJavaInnerArray(WebImageWasmGCIds.JavaInnerArray javaInnerArray) {
        JavaKind kind = javaInnerArray.kind;
        FieldType fieldType = FieldType.mutable(this.wasmProviders.util().storageTypeForKind(kind));
        ArrayType def = new ArrayType(javaInnerArray, null, true, fieldType, "Inner array for " + String.valueOf(kind) + "[]");
        this.registerTypeDefinition(def);
    }

    protected void registerBaseArrayType() {
        WasmId.StructType objectId = this.wasmProviders.util().getJavaLangObjectId();
        List<StructType.Field> fields = this.getArrayFields(WasmRefType.Kind.ARRAY.nonNull());
        StructType def = new StructType(this.knownIds.baseArrayType, objectId, false, fields, "Base type for all array wrapper structs");
        this.registerTypeDefinition(def);
    }

    protected void registerAccessDispatchArray() {
        ArrayType def = new ArrayType(this.knownIds.accessDispatchFieldType, null, true, FieldType.mutable(WasmPrimitiveType.i32), "Holds function table indices for unsafe access dispatch");
        this.registerTypeDefinition(def);
    }

    protected void registerVtableArray() {
        ArrayType def = new ArrayType(this.knownIds.vtableFieldType, null, true, FieldType.immutable(WasmPrimitiveType.i64), "Holds function table indices for vtable dispatch");
        this.registerTypeDefinition(def);
    }

    protected void registerTypeCheckSlotsArray() {
        ArrayType def = new ArrayType(this.knownIds.typeCheckSlotsFieldType, null, true, FieldType.immutable(WasmPackedType.i16), "Closed type world type check slots");
        this.registerTypeDefinition(def);
    }

    protected void registerNewInstanceFuncType() {
        FunctionType def = new FunctionType(this.knownIds.newInstanceFieldType, null, false, TypeUse.withResult(this.wasmProviders.util().getJavaLangObjectId().asNonNull(), new WasmValType[0]), null);
        this.registerTypeDefinition(def);
    }

    protected void registerCloneFuncType() {
        FunctionType def = new FunctionType(this.knownIds.cloneFieldType, null, true, WasmGCCloneSupport.getCloneFieldTypeUse(this.wasmProviders.util()), null);
        this.registerTypeDefinition(def);
    }

    protected StructType.Field getInnerArrayField(WasmValType fieldType) {
        return new StructType.Field(this.knownIds.innerArrayField, FieldType.immutable(fieldType), "Inner array field for array structs");
    }

    protected List<StructType.Field> getBaseFields() {
        WasmRefType hubWasmType = this.wasmProviders.util().getHubObjectType();
        return List.of(new StructType.Field(this.knownIds.hubField, FieldType.mutable(hubWasmType), "Dynamic Hub"), new StructType.Field(this.knownIds.identityHashCodeField, FieldType.mutable(WasmPrimitiveType.i32), "Identity Hash Code"));
    }

    protected List<StructType.Field> getExtraHubFields() {
        return List.of(new StructType.Field(this.knownIds.accessDispatchField, FieldType.mutable(this.knownIds.accessDispatchFieldType.asNullable()), "Access dispatch table"), new StructType.Field(this.knownIds.vtableField, FieldType.mutable(this.knownIds.vtableFieldType.asNullable()), "Vtable holding indices into the global function table"), new StructType.Field(this.knownIds.typeCheckSlotsField, FieldType.mutable(this.knownIds.typeCheckSlotsFieldType.asNullable()), "Closed type world type check slots"), new StructType.Field(this.knownIds.newInstanceField, FieldType.mutable(this.knownIds.newInstanceFieldType.asNullable()), "Function pointer to create a new instance of this type"), new StructType.Field(this.knownIds.cloneField, FieldType.mutable(this.knownIds.cloneFieldType.asNullable()), "Function pointer to clone object of this type"));
    }

    protected List<StructType.Field> getArrayFields(WasmValType innerArrayType) {
        ArrayList<StructType.Field> fields = new ArrayList<StructType.Field>(this.getBaseFields());
        fields.add(this.getInnerArrayField(innerArrayType));
        return fields;
    }

    public static List<ResolvedJavaField> getInstanceFields(ResolvedJavaType javaType) {
        LinkedList<ResolvedJavaField> fields = new LinkedList<ResolvedJavaField>();
        for (ResolvedJavaType superType = javaType; superType != null; superType = superType.getSuperclass()) {
            for (ResolvedJavaField field : superType.getInstanceFields(false)) {
                fields.addFirst(field);
            }
        }
        return fields;
    }

    @Override
    public void visitModule(WasmModule m) {
        super.visitModule(m);
        m.addRecursiveGroup(this.recGroupBuilder.build("All type definitions"));
    }
}

