/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.ast.id;

import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.wasm.ast.id.ResolverContext;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class WebImageWasmGCIds {

    public static class StaticField
    extends WasmId.Global {
        public final ResolvedJavaField field;

        public StaticField(WasmValType variableType, ResolvedJavaField field) {
            super(variableType, "field.static." + WebImageNamingConvention.getInstance().identForType(field.getDeclaringClass()) + "." + WebImageNamingConvention.getInstance().identForProperty(field));
            this.field = field;
            assert (field.isStatic()) : field;
        }
    }

    public static class InternalArray
    extends WasmId.ArrayType {
        public final String name;

        public InternalArray(String name) {
            this.name = name;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "array." + this.name;
        }
    }

    public static class JavaInnerArray
    extends WasmId.ArrayType {
        public final JavaKind kind;

        public JavaInnerArray(JavaKind kind) {
            this.kind = kind;
            assert (kind.isPrimitive() || kind == JavaKind.Object) : kind;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "array." + String.valueOf(this.kind);
        }
    }

    public static class InternalField
    extends WasmId.Field {
        public final String name;

        public InternalField(String name) {
            this.name = name;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "field." + this.name;
        }
    }

    public static class InternalStruct
    extends WasmId.StructType {
        public final String name;

        public InternalStruct(String name) {
            this.name = name;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "struct." + this.name;
        }
    }

    public static class InternalFuncType
    extends WasmId.FuncType {
        private final String name;

        public InternalFuncType(String name) {
            this.name = name;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "func." + this.name;
        }
    }

    public static class JavaField
    extends WasmId.Field {
        public final ResolvedJavaField field;

        public JavaField(ResolvedJavaField field) {
            this.field = field;
        }

        @Override
        public String doResolve(ResolverContext ctxt) {
            return ctxt.namingConvention.identForType(this.field.getDeclaringClass()) + "_" + ctxt.namingConvention.identForProperty(this.field);
        }

        @Override
        public String toInnerString() {
            return this.field.format("%H.%n");
        }
    }

    public static class JavaArrayStruct
    extends WasmId.StructType {
        public final JavaKind componentKind;

        public JavaArrayStruct(JavaKind componentKind) {
            this.componentKind = componentKind;
            assert (componentKind.isPrimitive() || componentKind.isObject()) : componentKind;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "struct.array." + this.componentKind.getJavaName();
        }
    }

    public static class JavaStruct
    extends WasmId.StructType {
        public final ResolvedJavaType javaType;

        public JavaStruct(ResolvedJavaType type) {
            this.javaType = type;
            assert (type.isInstanceClass()) : type;
        }

        @Override
        public String doResolve(ResolverContext ctxt) {
            return ctxt.namingConvention.identForType(this.javaType);
        }

        @Override
        public String toInnerString() {
            return this.javaType.toJavaName(true);
        }
    }
}

