/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.ast.id;

import com.oracle.svm.hosted.webimage.wasm.ast.Export;
import com.oracle.svm.hosted.webimage.wasm.ast.id.KnownIds;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCCloneSupport;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCFunctionTemplates;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCJSBodyTemplates;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCUnsafeTemplates;
import java.util.EnumMap;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;

public class GCKnownIds
extends KnownIds {
    public final EnumMap<JavaKind, WebImageWasmGCIds.JavaArrayStruct> arrayStructTypes = new EnumMap(JavaKind.class);
    public final EnumMap<JavaKind, WebImageWasmGCIds.JavaInnerArray> innerArrayTypes = new EnumMap(JavaKind.class);
    public final WebImageWasmGCIds.InternalField innerArrayField;
    public final WasmId.StructType baseArrayType;
    public final WasmId.Field hubField;
    public final WebImageWasmGCIds.InternalField identityHashCodeField;
    public final WasmId.Field accessDispatchField;
    public final WasmId.ArrayType accessDispatchFieldType;
    public final WasmId.Field vtableField;
    public final WasmId.ArrayType vtableFieldType;
    public final WasmId.Field typeCheckSlotsField;
    public final WasmId.ArrayType typeCheckSlotsFieldType;
    public final WasmId.Field newInstanceField;
    public final WasmId.FuncType newInstanceFieldType;
    public final WasmId.Field cloneField;
    public final WasmId.FuncType cloneFieldType;
    public final WebImageWasmGCIds.InternalField embedderField;
    public final WebImageWasmGCIds.InternalField jsNativeValueField;
    public final WasmId.Table imageHeapObjectTable;
    public final WasmId.Data dataSegmentId;
    public final WasmGCFunctionTemplates.ToExtern toExternTemplate;
    public final WasmGCFunctionTemplates.WrapExtern wrapExternTemplate;
    public final WasmGCFunctionTemplates.ArrayElementLoad arrayLoadTemplate;
    public final WasmGCFunctionTemplates.ArrayLength arrayLengthTemplate;
    public final WasmGCFunctionTemplates.ArrayElementStore arrayStoreTemplate;
    public final WasmGCFunctionTemplates.ArrayCreate arrayCreateTemplate;
    public final WasmGCFunctionTemplates.InstanceCreate instanceCreateTemplate;
    public final WasmGCFunctionTemplates.AllocatingBox allocatingBoxTemplate;
    public final WasmGCFunctionTemplates.GetFunctionIndex getFunctionIndexTemplate;
    public final WasmGCFunctionTemplates.IndirectCallBridge indirectCallBridgeTemplate;
    public final WasmGCFunctionTemplates.FillHeapObject fillHeapObjectTemplate;
    public final WasmGCFunctionTemplates.FillHeapArray fillHeapArrayTemplate;
    public final WasmGCFunctionTemplates.ArrayCopy arrayCopyTemplate;
    public final WasmGCFunctionTemplates.Throw throwTemplate;
    public final WasmGCFunctionTemplates.UnsafeCreate unsafeCreateTemplate;
    public final WasmGCUnsafeTemplates.FieldAccess fieldAccessTemplate;
    public final WasmGCUnsafeTemplates.ArrayAccess arrayAccessTemplate;
    public final WasmGCUnsafeTemplates.DispatchAccess dispatchAccessTemplate;
    public final WasmGCUnsafeTemplates.GetDispatchIndex getDispatchIndexTemplate;
    public final WasmGCCloneSupport.GenericCloneTemplate genericCloneTemplate;
    public final WasmGCCloneSupport.ObjectCloneTemplate objectCloneTemplate;
    public final WasmGCCloneSupport.ArrayCloneTemplate arrayCloneTemplate;
    public final WasmGCJSBodyTemplates.ExtractJSValue extractJSValueTemplate;
    public final WasmGCJSBodyTemplates.IsJavaObject isJavaObjectTemplate;
    private final List<Export> functionExports;

    public GCKnownIds(WasmIdFactory idFactory) {
        super(idFactory);
        JavaKind[] arrayComponentKinds;
        for (JavaKind kind : arrayComponentKinds = new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Short, JavaKind.Char, JavaKind.Int, JavaKind.Float, JavaKind.Long, JavaKind.Double, JavaKind.Object}) {
            this.arrayStructTypes.computeIfAbsent(kind, idFactory::newJavaArrayStruct);
        }
        for (JavaKind kind : arrayComponentKinds) {
            this.innerArrayTypes.computeIfAbsent(kind, idFactory::newJavaInnerArray);
        }
        this.innerArrayField = idFactory.newInternalField("inner");
        this.baseArrayType = idFactory.newInternalStruct("baseArray");
        this.hubField = idFactory.newInternalField("dynamicHub");
        this.identityHashCodeField = idFactory.newInternalField("identityHashCode");
        this.accessDispatchField = idFactory.newInternalField("accessDispatch");
        this.accessDispatchFieldType = idFactory.newInternalArray("accessDispatchTable");
        this.vtableField = idFactory.newInternalField("vtable");
        this.vtableFieldType = idFactory.newInternalArray("vtable");
        this.typeCheckSlotsField = idFactory.newInternalField("closedTypeWorldTypeCheckSlots");
        this.typeCheckSlotsFieldType = idFactory.newInternalArray("closedTypeWorldTypeCheckSlots");
        this.newInstanceField = idFactory.newInternalField("newInstance");
        this.newInstanceFieldType = idFactory.newInternalFuncType("newInstance");
        this.cloneField = idFactory.newInternalField("clone");
        this.cloneFieldType = idFactory.newInternalFuncType("clone");
        this.embedderField = idFactory.newInternalField("embedderObject");
        this.jsNativeValueField = idFactory.newInternalField("jsNativeValue");
        this.imageHeapObjectTable = idFactory.newTable();
        this.dataSegmentId = idFactory.newDataSegment("imageHeap");
        this.toExternTemplate = new WasmGCFunctionTemplates.ToExtern(idFactory);
        this.wrapExternTemplate = new WasmGCFunctionTemplates.WrapExtern(idFactory);
        this.arrayLoadTemplate = new WasmGCFunctionTemplates.ArrayElementLoad(idFactory);
        this.arrayLengthTemplate = new WasmGCFunctionTemplates.ArrayLength(idFactory);
        this.arrayStoreTemplate = new WasmGCFunctionTemplates.ArrayElementStore(idFactory);
        this.arrayCreateTemplate = new WasmGCFunctionTemplates.ArrayCreate(idFactory);
        this.instanceCreateTemplate = new WasmGCFunctionTemplates.InstanceCreate(idFactory);
        this.allocatingBoxTemplate = new WasmGCFunctionTemplates.AllocatingBox(idFactory);
        this.getFunctionIndexTemplate = new WasmGCFunctionTemplates.GetFunctionIndex(idFactory);
        this.indirectCallBridgeTemplate = new WasmGCFunctionTemplates.IndirectCallBridge(idFactory);
        this.fillHeapObjectTemplate = new WasmGCFunctionTemplates.FillHeapObject(idFactory);
        this.fillHeapArrayTemplate = new WasmGCFunctionTemplates.FillHeapArray(idFactory);
        this.arrayCopyTemplate = new WasmGCFunctionTemplates.ArrayCopy(idFactory);
        this.throwTemplate = new WasmGCFunctionTemplates.Throw(idFactory);
        this.unsafeCreateTemplate = new WasmGCFunctionTemplates.UnsafeCreate(idFactory);
        this.fieldAccessTemplate = new WasmGCUnsafeTemplates.FieldAccess(idFactory);
        this.arrayAccessTemplate = new WasmGCUnsafeTemplates.ArrayAccess(idFactory);
        this.dispatchAccessTemplate = new WasmGCUnsafeTemplates.DispatchAccess(idFactory);
        this.getDispatchIndexTemplate = new WasmGCUnsafeTemplates.GetDispatchIndex(idFactory);
        this.genericCloneTemplate = new WasmGCCloneSupport.GenericCloneTemplate(idFactory);
        this.objectCloneTemplate = new WasmGCCloneSupport.ObjectCloneTemplate(idFactory);
        this.arrayCloneTemplate = new WasmGCCloneSupport.ArrayCloneTemplate(idFactory);
        this.extractJSValueTemplate = new WasmGCJSBodyTemplates.ExtractJSValue(idFactory);
        this.isJavaObjectTemplate = new WasmGCJSBodyTemplates.IsJavaObject(idFactory);
        this.functionExports = List.of(Export.forFunction(this.unsafeCreateTemplate.requestFunctionId(), "unsafe.create", "Create uninitialized instance of given class"), Export.forFunction(this.wrapExternTemplate.requestFunctionId(), "extern.wrap", "Wrap externref in WasmExtern"), Export.forFunction(this.toExternTemplate.requestFunctionId(), "extern.unwrap", "Unwrap Java object to externref"), Export.forFunction(this.toExternTemplate.requestFunctionId(), "extern.isjavaobject", "Check if reference is a Java Object"), Export.forFunction(this.arrayLoadTemplate.requestFunctionId(JavaKind.Char), "array.char.read", "Read element of char array"), Export.forFunction(this.arrayLoadTemplate.requestFunctionId(JavaKind.Object), "array.object.read", "Read element of Object array"), Export.forFunction(this.arrayLengthTemplate.requestFunctionId(), "array.length", "Length of a Java array"), Export.forFunction(this.arrayStoreTemplate.requestFunctionId(JavaKind.Char), "array.char.write", "Write element of char array"), Export.forFunction(this.arrayStoreTemplate.requestFunctionId(JavaKind.Object), "array.object.write", "Write element of Object array"), Export.forFunction(this.arrayCreateTemplate.requestFunctionId(Character.TYPE), "array.char.create", "Create char array"), Export.forFunction(this.arrayCreateTemplate.requestFunctionId(String.class), "array.string.create", "Create String array"));
    }

    public WasmId.StructType getArrayStructType(JavaKind componentKind) {
        return componentKind == null ? this.baseArrayType : (WasmId.StructType)this.arrayStructTypes.get(componentKind);
    }

    @Override
    public List<WasmFunctionTemplate<?>> getFunctionTemplates() {
        return List.of(this.wrapExternTemplate, this.arrayCreateTemplate, this.instanceCreateTemplate, this.allocatingBoxTemplate, this.getFunctionIndexTemplate, this.indirectCallBridgeTemplate, this.arrayAccessTemplate, this.dispatchAccessTemplate, this.getDispatchIndexTemplate, this.arrayCopyTemplate, this.throwTemplate, this.unsafeCreateTemplate, this.genericCloneTemplate, this.extractJSValueTemplate, this.isJavaObjectTemplate);
    }

    @Override
    public List<WasmFunctionTemplate<?>> getLateFunctionTemplates() {
        return List.of(this.toExternTemplate, this.arrayLoadTemplate, this.arrayLengthTemplate, this.arrayStoreTemplate, this.fieldAccessTemplate, this.fillHeapObjectTemplate, this.fillHeapArrayTemplate, this.objectCloneTemplate, this.arrayCloneTemplate);
    }

    @Override
    public List<Export> getExports() {
        return this.functionExports;
    }
}

