/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasmgc.ast.RecursiveGroup;
import com.oracle.svm.hosted.webimage.wasmgc.ast.TypeDefinition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class RecTypeGroupBuilder {
    private final Map<WasmId.Type, List<WasmId.Type>> subTypeMap = new HashMap<WasmId.Type, List<WasmId.Type>>();
    private final Map<WasmId.Type, TypeDefinition> typeDefinitions = new HashMap<WasmId.Type, TypeDefinition>();
    private final List<WasmId.Type> roots = new ArrayList<WasmId.Type>();

    protected RecTypeGroupBuilder() {
    }

    public void addTypeDefinition(TypeDefinition definition) {
        WasmId.Type typeId = definition.getId();
        WasmId.Type superType = definition.supertype;
        assert (!this.typeDefinitions.containsKey(typeId)) : "Duplicate type registered: " + String.valueOf(definition);
        this.typeDefinitions.put(typeId, definition);
        if (superType == null) {
            this.roots.add(typeId);
        } else {
            this.subTypeMap.computeIfAbsent(superType, t -> new ArrayList()).add(typeId);
        }
    }

    public RecursiveGroup build(Object comment) {
        LinkedHashSet<TypeDefinition> topologicalSort = LinkedHashSet.newLinkedHashSet(this.typeDefinitions.size());
        ArrayDeque<WasmId.Type> worklist = new ArrayDeque<WasmId.Type>(this.roots);
        while (!worklist.isEmpty()) {
            WasmId.Type t = (WasmId.Type)worklist.pop();
            TypeDefinition typeDefinition = this.typeDefinitions.get(t);
            assert (!topologicalSort.contains(typeDefinition)) : "Type already visited: " + String.valueOf(t);
            assert (typeDefinition.supertype == null || topologicalSort.contains(this.typeDefinitions.get(typeDefinition.supertype))) : "Supertype of " + String.valueOf(t) + " not yet visited";
            topologicalSort.add(typeDefinition);
            List<WasmId.Type> subTypes = this.subTypeMap.get(t);
            if (subTypes == null) continue;
            subTypes.forEach(worklist::push);
        }
        assert (topologicalSort.size() <= this.typeDefinitions.size()) : "Topological sort found too many type definitions: " + new HashSet<TypeDefinition>(topologicalSort).removeAll(this.typeDefinitions.values());
        assert (topologicalSort.size() >= this.typeDefinitions.size()) : "Some type definitions were not encountered during topological sort (are there cycles?): " + new HashSet<TypeDefinition>(this.typeDefinitions.values()).removeAll(topologicalSort);
        return new RecursiveGroup(topologicalSort, comment);
    }
}

