/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.nodes.LoadMethodByIndexNode;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.hosted.webimage.WebImageLoweringProvider;
import com.oracle.svm.hosted.webimage.snippets.WebImageIdentityHashCodeSnippets;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCAllocationSupport;
import com.oracle.svm.hosted.webimage.wasmgc.snippets.WasmGCAllocationSnippets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.api.replacements.SnippetTemplateCache;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ClassIsArrayNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.UnsafeAccessNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryLoadNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryStoreNode;
import jdk.graal.compiler.nodes.java.AbstractUnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.LoadExceptionObjectNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.memory.ExtendableMemoryAccess;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyNode;
import jdk.graal.compiler.replacements.nodes.IdentityHashCodeNode;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;

public class WebImageWasmGCLoweringProvider
extends WebImageLoweringProvider {
    private static final Set<Class<?>> DEFAULT_LOWERABLE_NODES = new HashSet<Class>(Arrays.asList(ClassIsArrayNode.class, IdentityHashCodeNode.class, AtomicReadAndAddNode.class, AtomicReadAndWriteNode.class, FixedAccessNode.class, UnsafeAccessNode.class, AbstractUnsafeCompareAndSwapNode.class, UnsafeMemoryLoadNode.class, UnsafeMemoryStoreNode.class, DeadEndNode.class));
    private static final Set<Class<?>> NODE_LOWERING_NODES = new HashSet<Class>(Arrays.asList(EnsureClassInitializedNode.class, ValidateNewInstanceClassNode.class, GetClassNode.class, ArrayCopyNode.class, LoadExceptionObjectNode.class, BytecodeExceptionNode.class, ThrowBytecodeExceptionNode.class, SubstrateObjectCloneNode.class, SubstrateObjectCloneWithExceptionNode.class, IntegerDivRemNode.class, DeoptimizeNode.class, LoadMethodByIndexNode.class));

    public WebImageWasmGCLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target);
    }

    public void initialize(OptionValues options, SnippetCounter.Group.Factory factory, Providers providers) {
        super.initialize(options, factory, providers);
        providers.getReplacements().registerSnippetTemplateCache((SnippetTemplateCache)new WasmGCAllocationSnippets.Templates(options, providers));
    }

    protected IdentityHashCodeSnippets.Templates createIdentityHashCodeSnippets(OptionValues options, Providers providers) {
        return WebImageIdentityHashCodeSnippets.createTemplates(options, providers);
    }

    private static boolean shouldUseNodeLoweringProvider(Node n) {
        for (Class<?> c : NODE_LOWERING_NODES) {
            if (!c.isInstance(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        if (WebImageWasmGCLoweringProvider.shouldUseNodeLoweringProvider(n)) {
            NodeLoweringProvider nodeLoweringProvider = (NodeLoweringProvider)this.getLowerings().get(n.getClass());
            if (nodeLoweringProvider == null) {
                throw GraalError.unimplemented((String)("No LoweringProvider found for " + String.valueOf(n.getClass())));
            }
            nodeLoweringProvider.lower(n, tool);
        } else if (n instanceof DynamicNewArrayNode) {
            DynamicNewArrayNode newArray = (DynamicNewArrayNode)n;
            WebImageWasmGCLoweringProvider.lowerDynamicNewArray(newArray);
        } else {
            super.lower(n, tool);
        }
    }

    @Override
    public boolean shouldLower(Node n) {
        for (Class<?> c : DEFAULT_LOWERABLE_NODES) {
            if (!c.isInstance(n)) continue;
            return true;
        }
        return false;
    }

    private static void lowerDynamicNewArray(DynamicNewArrayNode newArray) {
        if (newArray.getKnownElementKind() == JavaKind.Object) {
            return;
        }
        StructuredGraph graph = newArray.graph();
        ForeignCallNode foreignCall = (ForeignCallNode)graph.add((Node)new ForeignCallNode((ForeignCallDescriptor)WasmGCAllocationSupport.DYNAMIC_NEW_ARRAY, new ValueNode[]{newArray.getElementType(), newArray.length()}));
        graph.replaceFixedWithFixed((FixedWithNextNode)newArray, (FixedWithNextNode)foreignCall);
    }

    public Integer smallestCompareWidth() {
        return 32;
    }

    public boolean supportsBulkZeroingOfEden() {
        return true;
    }

    public boolean writesStronglyOrdered() {
        return true;
    }

    public boolean divisionOverflowIsJVMSCompliant() {
        return false;
    }

    public boolean narrowsUseCastValue() {
        return false;
    }

    public boolean supportsFoldingExtendIntoAccess(ExtendableMemoryAccess access, MemoryExtendKind extendKind) {
        if (!access.isCompatibleWithExtend(extendKind)) {
            return false;
        }
        return access instanceof ReadNode;
    }
}

