/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.GCRelatedMXBeans;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.code.SubstrateSuitesCreatorProvider;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.ExceptionSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.WebImageFeature;
import com.oracle.svm.hosted.webimage.codegen.WebImageNoRegisterConfig;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.snippets.WebImageIdentityHashCodeSnippets;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmAssembler;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCAllocationSupport;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCArrayCopySupport;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCConversion;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCGraphBuilderPlugins;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCTypeCheckSupport;
import com.oracle.svm.hosted.webimage.wasmgc.WebImageWasmGCLoweringProvider;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WasmGCCloneSupport;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCBackend;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import com.oracle.svm.hosted.webimage.wasmgc.phases.WebImageWasmGCSuitesCreatorProvider;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.wasmgc.WasmExtern;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.java.LoadExceptionObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.TargetGraphBuilderPlugins;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageWasmGCPlatform.class})
public class WebImageWasmGCFeature
implements InternalFeature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(WebImageFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateRegisterConfigFactory.class, (config, metaAccess, target, preserveFramePointer) -> new WebImageNoRegisterConfig());
        ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(this){

            public SubstrateBackend newBackend(Providers newProviders) {
                return new WebImageWasmGCBackend(newProviders);
            }
        });
        ImageSingletons.add(SubstrateLoweringProviderFactory.class, WebImageWasmGCLoweringProvider::new);
        ImageSingletons.add(TargetGraphBuilderPlugins.class, (Object)new WasmGCGraphBuilderPlugins());
        ImageSingletons.add(SubstrateSuitesCreatorProvider.class, (Object)((Object)new WebImageWasmGCSuitesCreatorProvider()));
        ImageSingletons.add(GCRelatedMXBeans.class, (Object)new GCRelatedMXBeans());
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        WasmAssembler.install();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : WasmGCAllocationSupport.FOREIGN_CALLS) {
            access.registerAsRoot((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true, "WasmGC allocation foreign calls, registered in " + String.valueOf(WebImageWasmGCFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
        access.registerAsRoot((AnalysisMethod)WasmGCConversion.PROXY_OBJECT.findMethod((MetaAccessProvider)access.getMetaAccess()), true, "Calls to this method are created after compilation, registered in " + String.valueOf(WebImageWasmGCFeature.class), new MultiMethod.MultiMethodKey[0]);
        access.registerAsUnsafeAllocated(WasmExtern.class);
        access.registerAsRoot((AnalysisMethod)WasmGCArrayCopySupport.ARRAYCOPY.findMethod((MetaAccessProvider)access.getMetaAccess()), true, "System.arraycopy support, registered in " + String.valueOf(WebImageWasmGCFeature.class), new MultiMethod.MultiMethodKey[0]);
        access.registerAsRoot((AnalysisMethod)WasmGCCloneSupport.CLONE.findMethod((MetaAccessProvider)access.getMetaAccess()), true, "Cloning support, registered in " + String.valueOf(WebImageWasmGCFeature.class), new MultiMethod.MultiMethodKey[0]);
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : WasmGCTypeCheckSupport.FOREIGN_CALLS) {
            access.registerAsRoot((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true, "Type check support, registered in " + String.valueOf(WebImageWasmGCFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        WasmGCAllocationSupport.registerForeignCalls(foreignCalls);
        WasmGCConversion.registerForeignCalls(foreignCalls);
        foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{WebImageIdentityHashCodeSnippets.COMPUTE_IDENTITY_HASH_CODE});
        WasmGCArrayCopySupport.registerForeignCalls(foreignCalls);
        WasmGCTypeCheckSupport.registerForeignCalls(foreignCalls);
        WasmGCCloneSupport.registerForeignCalls(foreignCalls);
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        SubstrateAllocationSnippets allocationSnippets = (SubstrateAllocationSnippets)ImageSingletons.lookup(SubstrateAllocationSnippets.class);
        SubstrateAllocationSnippets.Templates templates = new SubstrateAllocationSnippets.Templates(options, providers, allocationSnippets);
        templates.registerLowering(lowerings);
        WasmGCArrayCopySupport.registerLowering(lowerings);
        lowerings.put((Class<Node>)LoadExceptionObjectNode.class, (NodeLoweringProvider<?>)new ExceptionSnippets.LoadExceptionObjectLowering());
        WasmGCCloneSupport.registerLowerings(lowerings);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        WasmGCAllocationSupport.preRegisterAllocationTemplates((WebImageWasmGCProviders)((Object)ImageSingletons.lookup(WebImageProviders.class)));
    }
}

