/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.util.ReflectUtil;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCMetadataLowerer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.Pair;

public class WebImageWasmGCCodeCache
extends WebImageCodeCache {
    private final Map<HostedMethod, String> exportedMethodMetadata = new LinkedHashMap<HostedMethod, String>();
    private final Map<HostedMethod, String> exportedSingleAbstractMethods = new LinkedHashMap<HostedMethod, String>();

    public WebImageWasmGCCodeCache(Map<HostedMethod, CompilationResult> compilationResultMap, NativeImageHeap imageHeap) {
        super(compilationResultMap, imageHeap);
    }

    @Override
    public void buildRuntimeMetadata(DebugContext debug, SnippetReflectionProvider snippetReflectionProvider) {
        super.buildRuntimeMetadata(debug, snippetReflectionProvider);
        for (Pair orderedCompilation : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)orderedCompilation.getLeft();
            WebImageWasmGCCodeCache.registerMethodMetadata(method, "META.", this.exportedMethodMetadata);
        }
        for (HostedType type : this.nativeImageHeap.hMetaAccess.getUniverse().getTypes()) {
            HostedMethod method;
            Optional sam = ReflectUtil.singleAbstractMethodForClass((MetaAccessProvider)this.nativeImageHeap.hMetaAccess, type);
            if (!sam.isPresent() || !(method = (HostedMethod)sam.get()).isCompiled()) continue;
            WebImageWasmGCCodeCache.registerMethodMetadata(method, "SAM.", this.exportedSingleAbstractMethods);
        }
    }

    private static void registerMethodMetadata(HostedMethod m, String prefix, Map<HostedMethod, String> map) {
        Optional<String> exportedName = WasmGCMetadataLowerer.createMethodMetadata(m, prefix);
        exportedName.ifPresent(name -> map.put(m, (String)name));
    }

    public Map<HostedMethod, String> getExportedMethodMetadata() {
        return this.exportedMethodMetadata;
    }

    public Map<HostedMethod, String> getExportedSingleAbstractMethods() {
        return this.exportedSingleAbstractMethods;
    }
}

