/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.hosted.webimage.wasm.debug.WasmDebug;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmTrapNode;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.word.LocationIdentity;

public class WasmGCUnsafeSupport {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor FATAL_ACCESS_ERROR = SnippetRuntime.findForeignCall(WasmGCUnsafeSupport.class, (String)"fatalAccessError", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final Object STATIC_OBJECT_FIELD_BASE = new Object();
    public static final Object STATIC_PRIMITIVE_FIELD_BASE = new Object();

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void fatalAccessError(Object receiver, String s, long offset, boolean isRead) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fatal unsafe ").append(isRead ? "read" : "write").append(" error");
        if (receiver == null) {
            sb.append(" for null object: ");
        } else {
            sb.append(" for object of type ").append(receiver.getClass().getTypeName());
        }
        sb.append(" at offset ").append(offset).append(": ").append(s);
        WasmDebug.getErrorStream().println(sb);
        WasmTrapNode.trap();
    }

    @Fold
    public static boolean includeErrorMessage() {
        return (Boolean)Options.UnsafeErrorMessages.getValue();
    }

    static class Options {
        public static final HostedOptionKey<Boolean> UnsafeErrorMessages = new HostedOptionKey((Object)true);

        Options() {
        }
    }
}

