/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCUnalignedUnsafeSupport;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCUnsafeSupport;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageWasmGCPlatform.class})
class WasmGCUnsafeFeature
implements InternalFeature {
    WasmGCUnsafeFeature() {
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        if (WasmGCUnsafeSupport.includeErrorMessage()) {
            foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{WasmGCUnsafeSupport.FATAL_ACCESS_ERROR});
        }
        Collection<SnippetRuntime.SubstrateForeignCallDescriptor> collection = WasmGCUnalignedUnsafeSupport.READ_ARRAY_FOREIGN_CALLS.values();
        SubstrateForeignCallsProvider substrateForeignCallsProvider = foreignCalls;
        Objects.requireNonNull(substrateForeignCallsProvider);
        SubstrateForeignCallsProvider substrateForeignCallsProvider2 = substrateForeignCallsProvider;
        collection.forEach(xva$0 -> substrateForeignCallsProvider2.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{xva$0}));
        Collection<SnippetRuntime.SubstrateForeignCallDescriptor> collection2 = WasmGCUnalignedUnsafeSupport.WRITE_ARRAY_FOREIGN_CALLS.values();
        SubstrateForeignCallsProvider substrateForeignCallsProvider3 = foreignCalls;
        Objects.requireNonNull(substrateForeignCallsProvider3);
        substrateForeignCallsProvider2 = substrateForeignCallsProvider3;
        collection2.forEach(xva$0 -> substrateForeignCallsProvider2.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{xva$0}));
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(other -> {
            if (BuildPhaseProvider.isHostedUniverseBuilt()) {
                if (other == StaticFieldsSupport.getCurrentLayerStaticObjectFields()) {
                    return WasmGCUnsafeSupport.STATIC_OBJECT_FIELD_BASE;
                }
                if (other == StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields()) {
                    return WasmGCUnsafeSupport.STATIC_PRIMITIVE_FIELD_BASE;
                }
            }
            return other;
        });
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        if (WasmGCUnsafeSupport.includeErrorMessage()) {
            access.getBigBang().addRootMethod((AnalysisMethod)WasmGCUnsafeSupport.FATAL_ACCESS_ERROR.findMethod((MetaAccessProvider)access.getMetaAccess()), true, (Object)("Fatal Unsafe error handler, registered in " + String.valueOf(WasmGCUnsafeFeature.class)), new MultiMethod.MultiMethodKey[0]);
        }
        Stream.concat(WasmGCUnalignedUnsafeSupport.READ_ARRAY_FOREIGN_CALLS.values().stream(), WasmGCUnalignedUnsafeSupport.WRITE_ARRAY_FOREIGN_CALLS.values().stream()).forEach(descriptor -> access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true, (Object)("Unsafe array accesses, registered in " + String.valueOf(WasmGCUnsafeFeature.class)), new MultiMethod.MultiMethodKey[0]));
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        StaticFieldsSupport.setData((Object[])new Object[0], (byte[])new byte[0]);
        access.getHeapScanner().rescanObject(StaticFieldsSupport.getCurrentLayerStaticObjectFields());
        access.getHeapScanner().rescanObject(StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields());
    }
}

