/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCUnsafeSupport;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;

public class WasmGCUnalignedUnsafeSupport {
    public static final Map<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor> READ_ARRAY_FOREIGN_CALLS = new HashMap<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor>();
    public static final Map<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor> WRITE_ARRAY_FOREIGN_CALLS = new HashMap<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor>();

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static byte readArrayByte(Object o, long offset) {
        int scaledOffset = WasmGCUnalignedUnsafeSupport.getScaledOffset(o, offset);
        int indexScale = WasmGCUnalignedUnsafeSupport.getArrayIndexScale(o);
        int index = scaledOffset / indexScale;
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        long longBits = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, byte[].class, short[].class, char[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
            case 0 -> {
                boolean[] bools = (boolean[])object2;
                if (bools[index]) {
                    yield 1L;
                }
                yield 0L;
            }
            case 1 -> {
                byte[] bytes = (byte[])object2;
                yield bytes[index];
            }
            case 2 -> {
                short[] shorts = (short[])object2;
                yield shorts[index];
            }
            case 3 -> {
                char[] chars = (char[])object2;
                yield chars[index];
            }
            case 4 -> {
                int[] ints = (int[])object2;
                yield ints[index];
            }
            case 5 -> {
                long[] longs = (long[])object2;
                yield longs[index];
            }
            case 6 -> {
                float[] floats = (float[])object2;
                yield Float.floatToRawIntBits(floats[index]);
            }
            case 7 -> {
                double[] doubles = (double[])object2;
                yield Double.doubleToRawLongBits(doubles[index]);
            }
            default -> {
                if (WasmGCUnsafeSupport.includeErrorMessage()) {
                    WasmGCUnsafeSupport.fatalAccessError(o, "Unsupported type for unaligned array access", offset, true);
                }
                throw new UnsupportedOperationException();
            }
        };
        int rightShift = 8 * WasmGCUnalignedUnsafeSupport.elementByteOffset(scaledOffset, indexScale);
        return (byte)(longBits >> rightShift);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static boolean readArrayBoolean(Object o, long offset) {
        return WasmGCUnalignedUnsafeSupport.readArrayByte(o, offset) != 0;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static char readArrayChar(Object o, long offset) {
        return (char)WasmGCUnalignedUnsafeSupport.readArrayAndDeserialize(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Char));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static short readArrayShort(Object o, long offset) {
        return (short)WasmGCUnalignedUnsafeSupport.readArrayAndDeserialize(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Short));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static int readArrayInt(Object o, long offset) {
        return (int)WasmGCUnalignedUnsafeSupport.readArrayAndDeserialize(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Int));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static long readArrayLong(Object o, long offset) {
        return WasmGCUnalignedUnsafeSupport.readArrayAndDeserialize(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Long));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static float readArrayFloat(Object o, long offset) {
        return Float.intBitsToFloat((int)WasmGCUnalignedUnsafeSupport.readArrayAndDeserialize(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Float)));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static double readArrayDouble(Object o, long offset) {
        return Double.longBitsToDouble(WasmGCUnalignedUnsafeSupport.readArrayAndDeserialize(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Double)));
    }

    private static long readArrayAndDeserialize(Object o, long offset, int byteWidth) {
        long result = 0L;
        for (int i = 0; i < byteWidth; ++i) {
            byte value = WasmGCUnalignedUnsafeSupport.readArrayByte(o, offset + (long)i);
            result |= ((long)value & 0xFFL) << 8 * i;
        }
        return result;
    }

    private static int elementByteOffset(long offset, int byteWidth) {
        return (int)(offset % (long)byteWidth);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayByte(Object o, long offset, byte value) {
        int scaledOffset = WasmGCUnalignedUnsafeSupport.getScaledOffset(o, offset);
        int indexScale = WasmGCUnalignedUnsafeSupport.getArrayIndexScale(o);
        int index = scaledOffset / indexScale;
        int valueOffset = WasmGCUnalignedUnsafeSupport.elementByteOffset(scaledOffset, indexScale);
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, byte[].class, short[].class, char[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
            case 0: {
                boolean[] bools = (boolean[])object2;
                bools[index] = value != 0;
                break;
            }
            case 1: {
                byte[] bytes = (byte[])object2;
                bytes[index] = value;
                break;
            }
            case 2: {
                short[] shorts = (short[])object2;
                shorts[index] = (short)WasmGCUnalignedUnsafeSupport.setByte(shorts[index], valueOffset, value);
                break;
            }
            case 3: {
                char[] chars = (char[])object2;
                chars[index] = (char)WasmGCUnalignedUnsafeSupport.setByte(chars[index], valueOffset, value);
                break;
            }
            case 4: {
                int[] ints = (int[])object2;
                ints[index] = (int)WasmGCUnalignedUnsafeSupport.setByte(ints[index], valueOffset, value);
                break;
            }
            case 5: {
                long[] longs = (long[])object2;
                longs[index] = WasmGCUnalignedUnsafeSupport.setByte(longs[index], valueOffset, value);
                break;
            }
            case 6: {
                float[] floats = (float[])object2;
                floats[index] = Float.intBitsToFloat((int)WasmGCUnalignedUnsafeSupport.setByte(Float.floatToRawIntBits(floats[index]), valueOffset, value));
                break;
            }
            case 7: {
                double[] doubles = (double[])object2;
                doubles[index] = Double.longBitsToDouble(WasmGCUnalignedUnsafeSupport.setByte(Double.doubleToRawLongBits(doubles[index]), valueOffset, value));
                break;
            }
            default: {
                if (WasmGCUnsafeSupport.includeErrorMessage()) {
                    WasmGCUnsafeSupport.fatalAccessError(o, "Unsupported type for unaligned array access", offset, true);
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    private static long setByte(long currentValue, int position, byte value) {
        int leftShift = position * 8;
        return currentValue & (255L << leftShift ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << leftShift;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayBoolean(Object o, long offset, boolean value) {
        WasmGCUnalignedUnsafeSupport.writeArrayByte(o, offset, (byte)(value ? 1 : 0));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayChar(Object o, long offset, char value) {
        WasmGCUnalignedUnsafeSupport.serializeAndWriteArray(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Char), value);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayShort(Object o, long offset, short value) {
        WasmGCUnalignedUnsafeSupport.serializeAndWriteArray(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Short), value);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayInt(Object o, long offset, int value) {
        WasmGCUnalignedUnsafeSupport.serializeAndWriteArray(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Int), value);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayLong(Object o, long offset, long value) {
        WasmGCUnalignedUnsafeSupport.serializeAndWriteArray(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Long), value);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayFloat(Object o, long offset, float value) {
        WasmGCUnalignedUnsafeSupport.serializeAndWriteArray(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Float), Float.floatToRawIntBits(value));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void writeArrayDouble(Object o, long offset, double value) {
        WasmGCUnalignedUnsafeSupport.serializeAndWriteArray(o, offset, WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Double), Double.doubleToRawLongBits(value));
    }

    private static void serializeAndWriteArray(Object o, long offset, int byteWidth, long value) {
        for (int i = 0; i < byteWidth; ++i) {
            WasmGCUnalignedUnsafeSupport.writeArrayByte(o, offset + (long)i, (byte)(value >>> 8 * i));
        }
    }

    private static int getScaledOffset(Object o, long offset) {
        return Math.toIntExact(offset - (long)WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(o));
    }

    private static int getArrayBaseOffset(Object o) {
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, byte[].class, short[].class, char[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
            case 0 -> {
                boolean[] bools = (boolean[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Boolean);
            }
            case 1 -> {
                byte[] bytes = (byte[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Byte);
            }
            case 2 -> {
                short[] shorts = (short[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Short);
            }
            case 3 -> {
                char[] chars = (char[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Char);
            }
            case 4 -> {
                int[] ints = (int[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Int);
            }
            case 5 -> {
                long[] longs = (long[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Long);
            }
            case 6 -> {
                float[] floats = (float[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Float);
            }
            case 7 -> {
                double[] doubles = (double[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayBaseOffset(JavaKind.Double);
            }
            default -> 0;
        };
    }

    private static int getArrayIndexScale(Object o) {
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, byte[].class, short[].class, char[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
            case 0 -> {
                boolean[] bools = (boolean[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Boolean);
            }
            case 1 -> {
                byte[] bytes = (byte[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Byte);
            }
            case 2 -> {
                short[] shorts = (short[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Short);
            }
            case 3 -> {
                char[] chars = (char[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Char);
            }
            case 4 -> {
                int[] ints = (int[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Int);
            }
            case 5 -> {
                long[] longs = (long[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Long);
            }
            case 6 -> {
                float[] floats = (float[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Float);
            }
            case 7 -> {
                double[] doubles = (double[])object2;
                yield WasmGCUnalignedUnsafeSupport.getArrayIndexScale(JavaKind.Double);
            }
            default -> 1;
        };
    }

    @AlwaysInline(value="kind is a constant")
    private static int getArrayBaseOffset(JavaKind kind) {
        return ((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getArrayBaseOffset(kind);
    }

    @AlwaysInline(value="kind is a constant")
    private static int getArrayIndexScale(JavaKind kind) {
        return ((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getArrayIndexScale(kind);
    }

    static {
        for (JavaKind componentKind : List.of(JavaKind.Boolean, JavaKind.Byte, JavaKind.Short, JavaKind.Char, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double)) {
            READ_ARRAY_FOREIGN_CALLS.put(componentKind, SnippetRuntime.findForeignCall(WasmGCUnalignedUnsafeSupport.class, (String)("readArray" + componentKind.name()), (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.ANY_LOCATION}));
            WRITE_ARRAY_FOREIGN_CALLS.put(componentKind, SnippetRuntime.findForeignCall(WasmGCUnalignedUnsafeSupport.class, (String)("writeArray" + componentKind.name()), (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.ANY_LOCATION}));
        }
    }
}

