/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.webimage.wasm.WasmForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.word.LocationIdentity;

public class WasmGCTypeCheckSupport {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor IS_EXACT_OR_NULL = SnippetRuntime.findForeignCall(WasmGCTypeCheckSupport.class, (String)"isExactTypeOrNull", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor IS_EXACT_NON_NULL = SnippetRuntime.findForeignCall(WasmGCTypeCheckSupport.class, (String)"isExactTypeNonNull", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor INSTANCEOF = SnippetRuntime.findForeignCall(WasmGCTypeCheckSupport.class, (String)"instanceOf", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor INSTANCEOF_DYNAMIC = SnippetRuntime.findForeignCall(WasmGCTypeCheckSupport.class, (String)"instanceOfDynamic", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CLASS_IS_ASSIGNABLE_FROM = SnippetRuntime.findForeignCall(WasmGCTypeCheckSupport.class, (String)"classIsAssignableFrom", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{IS_EXACT_OR_NULL, IS_EXACT_NON_NULL, INSTANCEOF, INSTANCEOF_DYNAMIC, CLASS_IS_ASSIGNABLE_FROM};
    public static final WasmForeignCallDescriptor SLOT_TYPE_CHECK = new WasmForeignCallDescriptor("slotTypeCheck", Boolean.TYPE, new Class[]{Short.TYPE, Short.TYPE, Short.TYPE, DynamicHub.class});

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native boolean slotTypeCheck0(@Node.ConstantNodeParameter ForeignCallDescriptor var0, short var1, short var2, short var3, Class<?> var4);

    private static boolean slotTypeCheck(short start, short range, short slot, DynamicHub checkedHub) {
        return WasmGCTypeCheckSupport.slotTypeCheck0(SLOT_TYPE_CHECK, start, range, slot, DynamicHub.toClass((DynamicHub)checkedHub));
    }

    @AlwaysInline(value="allowsNull is a constant")
    protected static boolean isExactType(Object object, boolean allowsNull, DynamicHub exactType) {
        if (object == null) {
            return allowsNull;
        }
        return DynamicHub.fromClass(object.getClass()) == exactType;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    protected static boolean isExactTypeOrNull(Object object, DynamicHub exactType) {
        return WasmGCTypeCheckSupport.isExactType(object, true, exactType);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    protected static boolean isExactTypeNonNull(Object object, DynamicHub exactType) {
        return WasmGCTypeCheckSupport.isExactType(object, false, exactType);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    protected static boolean instanceOf(Object object, boolean allowsNull, short start, short range, short slot) {
        if (object == null) {
            return allowsNull;
        }
        return WasmGCTypeCheckSupport.slotTypeCheck(start, range, slot, DynamicHub.fromClass(object.getClass()));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    protected static boolean instanceOfDynamic(DynamicHub type, Object object, boolean allowsNull) {
        return WasmGCTypeCheckSupport.instanceOf(object, allowsNull, type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    protected static boolean classIsAssignableFrom(DynamicHub thisClass, DynamicHub otherClass) {
        return WasmGCTypeCheckSupport.slotTypeCheck(thisClass.getTypeCheckStart(), thisClass.getTypeCheckRange(), thisClass.getTypeCheckSlot(), otherClass);
    }
}

