/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.type.ClassMetadataLowerer;
import com.oracle.svm.webimage.api.Nothing;
import com.oracle.svm.webimage.wasmgc.WasmGCMetadata;
import java.util.ArrayList;
import java.util.Optional;

public class WasmGCMetadataLowerer {
    public static final String METADATA_PREFIX = "META.";
    public static final String SAM_PREFIX = "SAM.";
    public static final String SEPARATOR = " ";

    static String registerClassAndGetEncoding(HostedType type) {
        Class<Nothing> effectiveType = type.isPrimitive() || type.getWrapped().isAnySubtypeInstantiated() ? type.getJavaClass() : Nothing.class;
        return WasmGCMetadata.registerClass(effectiveType);
    }

    static Optional<String> createMethodMetadata(HostedMethod m, String prefix) {
        HostedType type = m.getDeclaringClass();
        if (!ClassMetadataLowerer.isInstantiatedOrSubclassInstantiated(type) || !ClassMetadataLowerer.shouldEmitMetadata(m)) {
            return Optional.empty();
        }
        if (m.isStatic()) {
            return Optional.empty();
        }
        ResolvedSignature signature = m.getSignature();
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(WasmGCMetadataLowerer.registerClassAndGetEncoding(type));
        parts.add(m.getName());
        parts.add(WasmGCMetadataLowerer.registerClassAndGetEncoding((HostedType)signature.getReturnType()));
        for (int i = 0; i < signature.getParameterCount(false); ++i) {
            HostedType paramType = (HostedType)signature.getParameterType(i);
            parts.add(WasmGCMetadataLowerer.registerClassAndGetEncoding(paramType));
        }
        return Optional.of(prefix + String.join((CharSequence)SEPARATOR, parts));
    }
}

