/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.hosted.webimage.JSGraphBuilderPlugins;
import com.oracle.svm.hosted.webimage.wasm.WasmLMGraphBuilderPlugins;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCAllocationSupport;
import com.oracle.svm.hosted.webimage.wasmgc.snippets.WasmGCAllocationSnippets;
import java.lang.reflect.Type;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.SnippetSubstitutionInvocationPlugin;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.TargetGraphBuilderPlugins;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class WasmGCGraphBuilderPlugins
implements TargetGraphBuilderPlugins {
    public void registerPlugins(GraphBuilderConfiguration.Plugins plugins, OptionValues options) {
        InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(() -> {
            JSGraphBuilderPlugins.registerStringPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerCurrentIsolatePlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerThreadPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Int);
            WasmLMGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Long);
            WasmLMGraphBuilderPlugins.registerShortPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerCharacterPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerArraysPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerMathPlugins(Math.class, invocationPlugins);
            WasmLMGraphBuilderPlugins.registerMathPlugins(StrictMath.class, invocationPlugins);
            WasmLMGraphBuilderPlugins.unregisterArrayFillPlugins(invocationPlugins);
            WasmGCGraphBuilderPlugins.registerAllocationPlugins(invocationPlugins);
            WasmGCGraphBuilderPlugins.registerArraysSupportPlugins(invocationPlugins);
        });
    }

    private static void registerAllocationPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, WasmGCAllocationSupport.class);
        r.register((InvocationPlugin)new SnippetSubstitutionInvocationPlugin<WasmGCAllocationSnippets.Templates>(WasmGCAllocationSnippets.Templates.class, "dynamicNewArrayImpl", new Type[]{Class.class, Integer.TYPE}){

            public SnippetTemplate.SnippetInfo getSnippet(WasmGCAllocationSnippets.Templates templates) {
                return templates.dynamicNewArraySnippet;
            }
        });
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport").setAllowOverwrite(true);
        r.register(new InvocationPlugin("vectorizedMismatch", new Type[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode aObject, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                b.addPush(JavaKind.Int, NotNode.create((ValueNode)length));
                return true;
            }
        });
    }
}

